### $Id: simulate.q,v 1.2 1998/06/30 22:04:57 bates Exp $
###
###            Fit a general linear mixed effects model
###
### Copyright 1997, 1998 Jose C. Pinheiro <jcp@research.bell-labs.com>,
###                      Douglas M. Bates <bates@stat.wisc.edu>
###
### This file is part of the nlme library for S and related languages.
### It is made available under the terms of the GNU General Public
### License, version 2, or at your option, any later version,
### incorporated herein by reference.
### 
### This program is distributed in the hope that it will be
### useful, but WITHOUT ANY WARRANTY; without even the implied
### warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
### PURPOSE.  See the GNU General Public License for more
### details.
### 
### You should have received a copy of the GNU General Public
### License along with this program; if not, write to the Free
### Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
### MA 02111-1307, USA

"createConLin"<-
  function(fixed, data = sys.parent(),
	   random = pdSymm(eval(as.call(fixed[-2]))))
{
  Call <- match.call()
  if(!inherits(fixed, "formula") || length(fixed) != 3) {
    stop("\nFixed-effects model must be a formula of the form \"resp ~ pred\"")
  }
  REML <- FALSE
  reSt <- reStruct(random, REML = REML, data = NULL)
  groups <- getGroupsFormula(reSt)
  if(is.null(groups)) {
    if(inherits(data, "groupedData")) {
      groups <- getGroupsFormula(data)
      groupsL <- rev(getGroupsFormula(data, 
				      asList = TRUE))
      Q <- length(groupsL)
      if(length(reSt) != Q) {		# may need to repeat reSt
	if(length(reSt) != 1) {
	  stop("Incompatible lengths for \"random\" and grouping factors")
	}
	auxForm <-
	  eval(parse(text = paste("~", deparse(formula(random)[[2]]), "|",
		       deparse(groups[[2]]))))
	reSt <- reStruct(auxForm, REML = REML, data = NULL)
      }
      else {
	names(reSt) <- names(groupsL)
      }
    }
    else {
      stop(paste("Data must inherit from \"groupedData\" class ",
		 "if random does not define groups"))
    }
  }
  ## create an lme structure containing the random effects model
  lmeSt <- lmeStruct(reStruct = reSt)	
  ## extract a data frame with enough information to evaluate
  ## fixed, groups, reStruct, corStruct, and varStruct
  dataMix <-
    model.frame(formula = asOneFormula(formula(lmeSt), fixed, groups), data = data)
  origOrder <- row.names(dataMix)	# preserve the original order
  ## sort the model.frame by groups and get the matrices and parameters
  ## used in the estimation procedures
  grps <- getGroups(dataMix, eval(parse(text = paste("~1",
					  deparse(groups[[2]]), sep = "|"))))	
  ## ordering data by groups
  if(inherits(grps, "factor")) {	# single level
    ##"order" treats a single named argument peculiarly so must split this off
    ord <- order(grps)			
    grps <- data.frame(grps)
    row.names(grps) <- origOrder
    names(grps) <- as.character(deparse((groups[[2]])))
  }
  else {
    ord <- do.call("order", grps)	
    ## making group levels unique
    for(i in 2:ncol(grps)) {
      grps[, i] <- paste(as.character(grps[, i - 1]), as.character(grps[, i]), 
			 sep = "/")
      NULL
    }
  }
  grps <- grps[ord,  , drop = FALSE]
  dataMix <- dataMix[ord,  , drop = FALSE]
  revOrder <- match(origOrder, row.names(dataMix)) # putting in orig. order
  ## obtaining basic model matrices
  N <- nrow(grps)
  Z <- model.matrix(reSt, dataMix)
  ncols <- attr(Z, "ncols")
  Names(lmeSt$reStruct) <- attr(Z, "nams")	
  ## keeping the contrasts for later use in predict
  contr <- attr(Z, "contr")
  X <- model.frame(fixed, dataMix)
  auxContr <- lapply(X, function(el)
		     if(inherits(el, "factor")) contrasts(el))
  contr <- c(contr, auxContr[is.na(match(names(auxContr), names(contr)))])
  contr <- contr[!unlist(lapply(contr, is.null))]
  X <- model.matrix(fixed, X)
  y <- eval(fixed[[2]], dataMix)
  ncols <- c(ncols, dim(X)[2], 1)
  Q <- ncol(grps)	## creating the condensed linear model
  list(Xy = array(c(Z, X, y), c(N, sum(ncols)),
	 list(row.names(dataMix),
	      c(dimnames(Z)[[2]], dimnames(X)[[2]], deparse(fixed[[2]])))),
       dims = MEdims(grps, ncols), logLik = 0)
}

"simulate.lme"<-
  function(m1, m2, Random.seed, nsim = 1000, sigma, niterEM = c(40, 200))
  ## m1 is a list of arguments to lme to define the null model
  ## m2 is an option list of arguments to lme to define the feared model
{
  if (missing(Random.seed)) {
    aux <- rnorm(1)			# DMB using "aux" to confuse everyone :-)
    Random.seed <- .Random.seed
  }
  assign(".Random.seed", Random.seed, where = 1)
  m1 <- as.list(match.call(lme, substitute(m1))[ -1 ])
  fits <- list(null = do.call("lme", m1))
  condL <- list(null = do.call("createConLin", m1))
  ycol <- list(null = ncol(condL$null$Xy))
  storage.mode(condL$null$Xy) <- "double" # just in case
  pdims <- list(null = as.integer(unlist(condL$null$dims)))
  DeltaInv <- lapply(fits$null$modelStruct$reStruct, pdMatrix, factor = TRUE )
  Delta <- list(null = lapply(DeltaInv, solve))
  delt <- list(null = as.double(unlist(Delta$null)))
  ldelt <- list(null = length(delt$null))
  value <- list(null = list(ML = array(double(nsim * (ldelt$null + 4)),
			      c(nsim, ldelt$null + 4),
			      list(NULL,
				   c("cvrg", "info", "logLik", "lRlen",
				     paste("delta", 1:(ldelt$null), sep = ""))))))
  value$null$REML <- value$null$ML
  attr(value, "call") <- match.call()
  attr(value, "Random.seed") <- Random.seed
  ALT <- FALSE
  if (!missing(m2)) {
    m2 <- as.list(match.call(lme, substitute(m2))[-1])
    ALT <- TRUE
    aux <- m1
    aux[names(m2)] <- m2
    fits[["alt"]] <- do.call("lme", aux)
    condL[["alt"]] <- do.call("createConLin", aux)
    storage.mode(condL$alt$Xy) <- "double"
    pdims$alt <- as.integer(unlist(condL$alt$dims))
    DeltaInv <- lapply(fits$alt$modelStruct$reStruct, pdMatrix, factor = TRUE )
    Delta$alt <- lapply(DeltaInv, solve)
    delt$alt <- as.double(unlist(Delta$alt))
    ldelt$alt <- length(delt$alt)
    ycol$alt <- ncol(condL$alt$Xy)
    value$alt <- list(ML = array(double(nsim * (ldelt$alt + 4)),
			c(nsim, ldelt$alt + 4),
			list(NULL,
			     c("cvrg", "info", "logLik", "lRlen",
			       paste("delta", 1:(ldelt$alt), sep = "")))))
    value$alt$REML <- value$alt$ML
  }
  nullD <- condL$null$dims
  base <-				# form the base response from fixed effects
   matrix(condL$null$Xy[nullD$ZXoff$X +
			1:(nullD$ZXlen$X * nullD$ncol[nullD$Q + 1])],
	  nrow = nullD$N) %*% fits$null$coefficients$fixed
  N <- nullD$N
  if (any(nullD$qvec > 1)) {
    stop("only handling the case of variance components now")
  }
  if (nullD$Q > 1) {
    stop("only handling one level of random effects now")
  }
  ngrp <- nullD$ngrps[1]
  if (missing(sigma)) sigma <- fits$null$sigma
  sdgrp <- sigma/delt$null
  ind <- rep(1:ngrp, nullD$ZXlen[[1]])
  for (i in 1:nsim) {
    if (ALT) {
      condL$alt$Xy[, ycol$alt] <- condL$null$Xy[, ycol$null] <-
	base + rnorm(N, sd = sigma) +
	  rnorm(ngrp, sd = sdgrp)[ind] * condL$null$Xy[, 1]
    } else {
      condL$null$Xy[, ycol$null] <-
	base + rnorm(N, sd = sigma) +
	  rnorm(ngrp, sd = sdgrp)[ind] * condL$null$Xy[, 1]
    }
    value$null$ML[i, ] <-
      unlist(.C("mixed_combined",
		ZXy = condL$null$Xy,
		pdims = pdims$null,
		DmHalf = double(sum(condL$null$dims$q^2)),
		nIter = as.integer( niterEM[1] ),
		pdClass = as.integer( 0 ),
		RML = as.integer( FALSE ),
		logLik = double(1),
		Ra = double(length(delt$null)),
		lRlen = double(1),
                cvrg = double(1),
                info = integer(1))[c("cvrg", "info", "logLik", "lRlen", "DmHalf")])
    value$null$REML[i, ] <-
      unlist(.C("mixed_combined",
		ZXy = condL$null$Xy,
		pdims = pdims$null,
		DmHalf = double(sum(condL$null$dims$q^2)),
		nIter = as.integer( niterEM[1] ),
		pdClass = as.integer( 0 ),
		RML = as.integer( TRUE ),
		logLik = double(1),
		Ra = double(length(delt$null)),
		lRlen = double(1),
                cvrg = double(1),
                info = integer(1))[c("cvrg", "info", "logLik", "lRlen", "DmHalf")])
    if (ALT) {
      value$alt$ML[i, ] <-
	unlist(.C("mixed_combined",
		  ZXy = condL$alt$Xy,
		  pdims = pdims$alt,
		  DmHalf = double(sum(condL$alt$dims$q^2)),
		  nIter = as.integer( niterEM[2] ),
		  pdClass = as.integer( 0 ),
		  RML = as.integer( FALSE ),
		  logLik = double(1),
		  Ra = double(length(delt$alt)),
		  lRlen = double(1),
                  cvrg = double(1),
                  info = integer(1))[
                    c("cvrg", "info", "logLik", "lRlen", "DmHalf")])
      value$alt$REML[i, ] <-
	unlist(.C("mixed_combined",
		  ZXy = condL$alt$Xy,
		  pdims = pdims$alt,
		  DmHalf = double(sum(condL$alt$dims$q^2)),
		  nIter = as.integer( niterEM[2] ),
		  pdClass = as.integer( 0 ),
		  RML = as.integer( TRUE ),
		  logLik = double(1),
		  Ra = double(length(delt$alt)),
		  lRlen = double(1),
                  cvrg = double(1),
                  info = integer(1))[
                    c("cvrg", "info", "logLik", "lRlen", "DmHalf")])
    }
  }
  attr(value$null, "dims") <- condL$null$dims
  if (ALT) {
    attr(value$alt, "dims") <- condL$alt$dims
  }
  class(value) <- "simulate.lme"
  value
}

print.simulate.lme <-
  function(x, ...)
{
  attr(x$null, "dims") <- NULL
  if (!is.null(x$alt)) {
    attr(x$alt, "dims") <- NULL
  }
  attr(x, "Random.seed") <- attr(x, "call") <- NULL
  NextMethod()
}

plot.simulate.lme <-
  function(x, ...)
{
  dots <- list(...)
  df <- as.list(dots$df)
  okML <- x$null$ML[, "info"] < 8 & x$alt$ML[, "info"]
  MLstat <- sort(2 * (x$alt$ML[okML, "logLik"] - x$null$ML[okML, "logLik"]))
  MLy <- unlist(lapply(df, function(df, x) pchisq(x, df), x = MLstat))
  MLdf <- rep(unlist(df), rep(length(MLstat), length(df)))
  MLx <- rep((1:length(MLstat) - 0.5)/length(MLstat), length(df))
  okREML <- x$null$REML[, "info"] < 8 & x$alt$REML[, "info"]
  REMLstat <- sort(2*(x$alt$REML[okREML, "logLik"] - x$null$REML[okREML, "logLik"]))
  REMLy <- unlist(lapply(df, function(df, x) pchisq(x, df), x = REMLstat))
  REMLdf <- rep(unlist(df), rep(length(REMLstat), length(df)))
  REMLx <- rep((1:length(REMLstat) - 0.5)/length(REMLstat), length(df))
  frm <- data.frame(x = c(MLx, REMLx), y = c(MLy, REMLy),
		    df = as.factor(c(MLdf, REMLdf)),
		    method = as.factor(rep(c("ML","REML"),
		      c(length(MLy), length(REMLy)))))
  xyplot(y ~ x | df * method, data = frm,
	 panel = function(x, y) { panel.grid();
				  panel.xyplot(x, y, type = "l")
				  panel.abline(0,1) },
	 strip = function(...) strip.default(..., style = 1),
	 xlab = "Theoretical quantiles", ylab = "Observed quantiles")
}
  
## Local Variables:
## mode:S
## End:
