### $Id: selfStart.q,v 1.1.1.1 1996/11/13 15:38:45 bates Exp $
 # Major classes, their constructors, and methods for standard generics
##*## selfStart - self-starting nonlinear regression models

getInitial <- 
  ## Create initial values for object from data
  function(object, data, ...) UseMethod("getInitial")

getInitial.formula <-
  function(object, data, ...)
{
  if(!is.null(attr(data, "parameters"))) {
    return(attr(data, "parameters"))
  }
  obj <- object				# kluge to create a copy inside this
  obj[[1]] <- as.name("~")		# function.match.call() is misbehaving
  switch (length(obj),
	  stop("argument \"object\" has an impossible length"),
	  {				# one-sided formula
	    func <- get(obj[[2]][[1]])
	    getInitial(func, data,
		       mCall = match.call(func, call = obj[[2]]))
	  },
	  {				# two-sided formula
	    func <- get(obj[[3]][[1]])
	    getInitial(func, data,
		       mCall = match.call(func, call = obj[[3]]),
		       LHS = obj[[2]])
	  })
}

getInitial.selfStart <-
  function(object, data, mCall, LHS = NULL)
{
  (attr(object, "initial"))(mCall = mCall, data = data, LHS = LHS)
}

nls <-
  function(formula, data = sys.parent(),
	   start = getInitial(formula, data),
	   control, 
	   algorithm = "default",
	   trace = F)
{
  convert.twiddle <- function(formula)
    {
      if(length(formula) < 3)
	return(formula)
      form <- call("~", call("-", formula[[2]], formula[[3]]))
      attr(form, "class") <- "formula"
      form
    }
  if(is.numeric(data))
    data <- sys.frame(data)
  cl <- class(data)
  if(inherits(data, "pframe")) {
    class(data) <- NULL
    pp <- parameters(data)
    if(length(pp)) {
      np <- names(pp)
      if(any(match(np, names(data), 0)))
	stop(
	     "can't have variables, parameters with same name"
	     )
      data[np] <- pp
    }
  }
  else if(inherits(data, "data.frame"))
    cl <- c("pframe", cl)
  class(data) <- NULL	
  ## First, figure out the par. names, make start a list
  switch(mode(start),
	 numeric = {
	   .parameters <- names(start)
	   start <- as.list(start)
	   names(start) <- .parameters
	 }
	 ,
	 list = {
	   .parameters <- names(start)
	 }
	 ,
	 NULL = .parameters <- parameter.names(formula, data),
	 stop("\"start\" should be numeric or list"))
  if(!length(.parameters))
    stop("names for parameters needed, from formula or from start")
  pn <- .parameters
  .expr <- formula	
  ## select the algorithm and possibly massage the formula
  if(length(start)) data[.parameters] <- start	#used by setup_nonlin
  data$.parameters <- .parameters
  nl.frame <- new.frame(data, F)
  frame.attr("class", nl.frame) <- cl	# in case data is returned
  formula <- switch(algorithm,
		    plinear = {
		      if(length(formula) < 3)
			stop(
			     "formula for plinear algorithm be of the form resp ~ array"
			     )
		      response <- eval(formula[[2]], nl.frame)
		      design <- eval(formula[[3]], nl.frame)
		      nnobs <- length(response)
		      nlinear <- if(is.matrix(design)) dim(design)[2] else 
		      length(design)/nnobs
		      form <- call("~", formula[[3]])
		      attr(form, "class") <- "formula"
		      form
		    }
		    ,
		    default = convert.twiddle(formula))
  dims <- .C("setup_nonlin",
	     n = integer(3),
	     list(formula),
	     as.integer(nl.frame))$n
  npar <- dims[1]
  nderiv <- dims[2]
  nobs <- dims[3]
  resp <- eval(.expr[[2]], nl.frame)
  if(length(.expr) == 2) resp[] <- 0	
  ## setup_nonlin will have set .parameters if missing
  if(is.null(start)) {
    start <- list()
    if(is.null(names(start)) && length(start) == length(pn))
      names(start) <- pn
    for(i in .parameters)
      start[[i]] <- get(i, frame = nl.frame)
  }
  asgn <- start
  si <- 1
  for(i in 1:length(asgn)) {
    ni <- length(asgn[[i]])
    asgn[[i]] <- seq(from = si, length = ni)
    si <- si + ni
  }
  start <- unlist(start)
  controlvals <- nls.control()
  if(!missing(control))
    controlvals[names(control)] <- control
  ret.data <- is.logical(ret.data <- controlvals$data) && ret.data
  max.iterations <- if(is.null(controlvals$maxiter)) 50 * npar else 
  controlvals$maxiter
  settings <- c(0, max.iterations, controlvals$minscale, controlvals$
		tolerance, 0)
  if(algorithm == "plinear") {
    settings[1] <- 1
    dims <- c(dims, nlinear)
    start <- c(start, numeric(nlinear))
    pn <- c(pn, paste(".lin", 1:nlinear, sep = ""))
    dims[3] <- nnobs
    outmat <- array(c(response, numeric(nnobs * (npar + nlinear))), 
		    c(nnobs, npar + nlinear + 1))
  }
  else outmat <- array(0, c(nobs, npar + 1))
  storage.mode(outmat) <- "double"
  storage.mode(start) <- "double"
  nls.trace <- if(missing(trace)) controlvals$trace else trace
  std.trace <- FALSE
  if(is.logical(nls.trace)) {
    if(std.trace <- nls.trace)
      nls.trace <- "trace.nls"
    else nls.trace <- NULL
  }
  else std.trace <- is.character(nls.trace) && nls.trace == "trace.nls"
  if(std.trace) {
    assign("trace.mat",
	   array(0, c(max.iterations, npar + 2),
		 list(NULL, c("obj.", "conv.", paste("par", 1:npar)))),
	   frame = 1)
    assign("trace.expr", expression(trace.mat[last.iteration,  ] <- it.row),
	   frame = 1)
  }
  z <- .C("do_nls",
	  parameters = start,
	  dims = as.integer(dims),
	  control = as.double(settings),
	  outmat = outmat,
	  trace = list(nls.trace))
  if(sum(abs(z$outmat[, 1])) == 0) {
					# converged to zero residuals
    z$control[5] <- F
  }
  if(z$control[5])
    stop(switch(as.integer(z$control[5]),
		"step factor reduced below minimum",
		"maximum number of iterations exceeded",
		"singular gradient matrix",
		"singular design matrix",
		"singular gradient matrix"))
  nls.out <- list(parameters = z$parameters, formula = .expr, call = 
		  match.call(), residuals = z$outmat[, 1])
  if(algorithm == "plinear") {
    class(nls.out) <- c("nls.pl", "nls")
    R <- qr(z$outmat[, -1])$qr[1:(npar + nlinear),  , drop = F]
  }
  else {
    class(nls.out) <- "nls"
    R <- qr(z$outmat[, -1])$qr[1:npar,  , drop = F]
  }
  R[lower.tri(R)] <- 0
  nls.out$R <- R
  nls.out$fitted.values <- resp - nls.out$residuals
  nls.out$assign <- asgn
  if(ret.data) {
    data <- sys.frame(nl.frame)
    data$.parameters <- NULL	
    ## dbdetach does the right thing--only matters that nl.frame>1
    if(inherits(data, "pframe"))
      data <- dbdetach(data, nl.frame)
    nls.out$data <- data
  }
  if(std.trace && exists("last.iteration", frame = 1))
    nls.out$trace <- get("trace.mat", frame = 1)[1:get(
					  "last.iteration", frame = 1),  ]
  nls.out
}

selfStart <- 
  ## Constructor for the selfStart class of objects
  function(model, initial, parameters, template) UseMethod("selfStart")

selfStart.default <-
  function(model, initial, parameters, template)
{
  structure(as.function(model), initial = as.function(initial),
	    class = "selfStart")
}

selfStart.formula <-
  function(model, initial, parameters, template = NULL)
{
  if (is.null(template)) {		# create a template if not given
    nm <- all.vars(model)
    if (any(msng <- is.na(match(parameters, nm)))) {
      stop(paste("Parameter(s)", parameters[msng],
		 "do not occur in the model formula"))
    }
    template <-
      as.function(c(structure(lapply(vector("list", length(nm)),
				     function(el) vector("missing")),
			      names = c(nm[is.na(match(nm, parameters))],
				  parameters)), list(vector("{"))))
  }
  structure(deriv(model, parameters, template),
	    initial = initial,
	    class = "selfStart")
}

sortedXyData <-
  ## Constructor of the sortedXyData class
  function(x, y, data) UseMethod("sortedXyData")

sortedXyData.default <-
  function(x, y, data)
{
  ## works for x and y either numeric or language elements
  ## that can be evaluated in data
  if (is.language(x)) {
    x <- eval(asOneSidedFormula(x)[[2]], data)
  }
  x <- as.numeric(x)
  if (is.language(y)) {
    y <- eval(asOneSidedFormula(y)[[2]], data)
  }
  y <- as.numeric(y)
  y.avg <- tapply(y, x, mean) 
  xvals <- as.numeric(names(y.avg))
  ord <- order(xvals)
  structure(na.omit(data.frame(x = xvals[ord], y = as.vector(y.avg[ord]))),
	    class = c("sortedXyData", "data.frame"))
}

NLSstClosestX <-
  ## find the x value in the xy frame whose y value is closest to yval
  function(xy, yval) UseMethod("NLSstClosestX")

NLSstClosestX.sortedXyData <-
  ## find the x value in the xy frame whose y value is closest to yval
  function(xy, yval)
{
  deviations <- abs(xy$y - yval)
  xy$x[match(min(deviations), deviations)]
}

NLSstRtAsymptote <-
  ## Find a reasonable value for the right asymptote.
  function(xy) UseMethod("NLSstRtAsymptote")

NLSstRtAsymptote.sortedXyData <-
  function(xy)
{
  ## Is the last response value closest to the minimum or to
  ## the maximum?
  in.range <- range(xy$y)
  last.dif <- abs(in.range - xy$y[nrow(xy)])
  ## Estimate the asymptote as the largest (smallest) response
  ## value plus (minus) 1/8 of the range. 
  if(match(min(last.dif), last.dif) == 2) {
    return(in.range[2] + diff(in.range)/8)
  }
  in.range[1] - diff(in.range)/8
}

NLSstLfAsymptote <-
  ## Find a reasonable value for the left asymptote.
  function(xy) UseMethod("NLSstLfAsymptote")

NLSstLfAsymptote.sortedXyData <-
  function(xy)
{
  ## Is the first response value closest to the minimum or to
  ## the maximum?
  in.range <- range(xy$y)
  first.dif <- abs(in.range - xy$y[1])
  ## Estimate the asymptote as the largest (smallest) response
  ## value plus (minus) 1/8 of the range. 
  if(match(min(first.dif), first.dif) == 2) {
    return(in.range[2] + diff(in.range)/8)
  }
  in.range[1] - diff(in.range)/8
}

NLSstAsymptotic <-
  ## fit the asymptotic regression model in the form
  ## b0 + b1*exp(-exp(lrc) * x)
  function(xy) UseMethod("NLSstAsymptotic")

NLSstAsymptotic.sortedXyData <-
  function(xy)
{
  xy$rt <- NLSstRtAsymptote(xy)
  ## Initial estimate of log(rate constant) from a linear regression
  structure(coef(nls(y ~ cbind(1, 1 - exp(-exp(lrc) * x)),
		     data = xy,
		     start = list(lrc =
			 as.vector(log(-coef(lm(log(abs(y - rt)) ~ x,
						data = xy))[2]))),
		     algorithm = "plinear"))[c(2, 3, 1)],
	    names = c("b0", "b1", "lrc"))
}
			     
### This file is automatically placed in Outline minor mode.
### The file is structured as follows:
### Chapters:     ^L # 
### Sections:    ##*##
### Subsections: ###*###
### Components:  non-comment lines flushed left
###              Random code beginning with a ####* comment

### Local variables:
### mode: S
### mode: outline-minor
### outline-regexp: "\^L\\|\\`#\\|##\\*\\|###\\*\\|[a-zA-Z]\\|####\\*"
### End:
