/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: read_binary_file.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <stdio.h>
#include <assert.h>

#include "data.h"

#define DEBUG 0

int read_binary_file(FILE *fileptr, char *file, Plot *plot)
{
  int i,j,num_fields,n;
  unsigned long num_Data,l, num_points;
  double *readin;
  Data **dd;


  /* read an int= the number of data fields in the file */
  /******************************************************/
  if((1 !=  fread((void *) &num_fields,sizeof(int),1,fileptr))
     && num_fields>0)
    {  
      fclose(fileptr);
      return 1;
    }
  plot->dim += num_fields;
#if(DEBUG)
  fprintf(stderr,"quickplot Info: num_fields = %d plot->dim = %d \n",num_fields,plot->dim);
#endif

  /* skip lines */
  /*******************************************/
  assert(NULL != (readin = (double *) malloc(sizeof(double)*num_fields)));
  num_points = 0;
  /**** skip_lines *****/
  if(plot->flag & VERBOSE && plot->skip_lines)
    fprintf(stderr,"quickplot Info: Skipping the first %d lines in file: %s\n",
	    plot->skip_lines,file);
  for(num_points=0;num_points>plot->skip_lines && num_fields == 
	fread((void *) readin,sizeof(double),(size_t) num_fields,fileptr)
	  ;num_points++);
  if(num_points < plot->skip_lines)
    {
      fprintf(stderr,
	      "quickplot ERROR: read only %d lines of data in file %s\n",
	      num_points,file);
      fprintf(stderr,"There must be at least %d lines of data in addition to the %d line(s) skipped\n",MIN_NUM_POINTS,plot->skip_lines);
      return 1;
    }

#if(DEBUG)
  fprintf(stderr,"quickplot info: skipped %d data lines\n",num_points);
#endif

  realloc_plot_data_and_max_min(plot,num_fields);

   /* need array of Data pointers to move through data with */
  assert((dd = (Data **) malloc(sizeof(Data *)*num_fields)) != NULL);

  /* get plot->min and plot->max initialed to the first value */
  /************************************************************/
  if(( i = fread((void *) readin,sizeof(double),
		 (size_t) num_fields,fileptr)) == num_fields)
    for(j = plot->dim-num_fields;j<plot->dim;j++)
      plot->min[j] = plot->max[j] = readin[j - plot->dim + num_fields];
  else
    {
      fprintf(stderr,
	      "quickplot ERROR: can't read any data from line number %d from file: %s\n",
	      plot->skip_lines+1,file);
      return 1;
    }

  /** read in data **/
  num_Data = 0UL;
  num_points = 0UL;
  add_data_size(plot,dd,num_fields,&num_Data);
  n = plot->dim - num_fields;
  num_points = 0;
  while(!feof(fileptr) && i == num_fields)
    {  
      if(dd[0] == NULL)
	add_data_size(plot,dd,num_fields,&num_Data);
      for(j=0;j<num_fields;j++)
	{
	  dd[j]->val = readin[j];
	  if(readin[j] > plot->max[j+n])
	    plot->max[j+n] = readin[j];
	  if(readin[j] < plot->min[j+n])
	    plot->min[j+n] = readin[j];

	  dd[j] = dd[j]->next;
	}
      num_points++;
      i = fread((void *) readin,sizeof(double),(size_t) num_fields,fileptr);
    }

  free(readin);
  fclose(fileptr);

  check_data_size(plot,num_fields,num_points);  
  assert((plot->num_points = (unsigned long *) realloc(
	   (void *)plot->num_points,
	   sizeof(unsigned long)*plot->dim)) != NULL);
  for(i=plot->dim - num_fields;i<plot->dim;i++)
    {
      plot->num_points[i] = num_points;
      if(plot->num_points[i] < MIN_NUM_POINTS)
	{
	  fprintf(stderr,
		  "quickplot ERROR: the file %s has only %d point(s) and the minumum number of points that can be plotted is %d .\n",
		  file,plot->num_points[i],MIN_NUM_POINTS);
	  exit(1);
	}
    }
#if(0)
  n = plot->dim - num_fields;
  for(i=0;i<num_fields;i++)
    dd[i] = plot->data[plot->dim  - num_fields+i];
  fprintf(stderr,"quickplot Info: FILE %s\nmax then min values\n",file);
  for(i=n;i<plot->dim;i++)
    {
      fprintf(stderr,"%g %g ",plot->max[i],plot->min[i]);
      fprintf(stderr,"num_points = %d\n",plot->num_points[i]);
    }
  fprintf(stderr,"\nmin values ",file);
  for(i=n;i<plot->dim;i++)
    fprintf(stderr,"%g ",plot->min[i]);
  fprintf(stderr,"\nnum_fields = %d\n",num_fields);
  while(dd[0] != NULL)
    {  
      for(i=0;i<num_fields;i++)
	{
	  fprintf(stderr,"%g ",dd[i]->val);
	  dd[i] = dd[i]->next;
	}
      fprintf(stderr,"\n");
    }
  /* exit(0);*/
#endif
  free(dd);
  
  if(plot->flag & VERBOSE)
    fprintf(stderr,
	    "quickplot Info: read in (%d lines) x (%d values/line) = (%d values) from file: %s\n",
	    num_points,num_fields,num_points*num_fields,file);
  return 0;
}

