/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

***********************************************************************/
/* $Id: make_labels.c,v 1.1 1998/02/28 18:09:06 lance Exp $ */
#include <stdio.h>
#include <assert.h>
#include <string.h>

#include "data.h"

void make_labels(Plot *plot)
{
  int i,j,k;
  char str2[32];
  sprintf(str2,"%c%d.%ds",045,DATA_LABEL_SIZE,DATA_LABEL_SIZE);


  /* set up field labels */
  assert((plot->label = (char **) malloc(sizeof(char *)*plot->dim)) != NULL);
  /* default labels first */
  for(i=0;i<plot->dim;i++)
    {
      char str1[DATA_LABEL_SIZE + 16];
      assert((plot->label[i] = (char *)malloc(
                 sizeof(char)*(DATA_LABEL_SIZE+1))) != NULL);
      str1[0] = '\0';
      sprintf(str1,"field-%d",i);
      sprintf(plot->label[i],str2,str1);
    }
  /* non-default labels: get plot->label[] from plot->labels */
  if(plot->flag & LABELS || plot->flag & READ_LABELS )
    {
      char str1[DATA_LABEL_SIZE + 16];
      int lenght;

      j = 0;
      lenght = strlen(plot->labels);
      /*printf("plot->labels= <%s>\n",plot->labels);*/
      for(i=0;i<plot->dim && j<lenght;i++)
	{
	  for(k=0;(plot->labels)[k+j] == plot->label_seperator && (k+j)<lenght;k++);
	  j += k;
	  for(k=0;(plot->labels)[k+j] != plot->label_seperator && (k+j)<lenght;k++);
	  /*printf("k = %d j = %d\n",k,j);*/
	  if(k != 0)
	    {
	      str1[0] = '\0';
	      if(k > DATA_LABEL_SIZE)
		{
		  strncpy(str1,&(plot->labels[j]),DATA_LABEL_SIZE);
		  str1[DATA_LABEL_SIZE] = '\0';
		}
	      else
		{
		  strncpy(str1,&(plot->labels[j]),k);
		  str1[k] = '\0';
		}
	      /*printf("str1 = <%s>\n",str1);*/
	      sprintf(plot->label[i],str2,str1);
	      /*printf("label[%d] = <%s>\n",i,plot->label[i]);*/
	    }
	  k++;
	  j += k;
	}
    }
}
