/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#include <config.h>
#include <assert.h>
#include <stdio.h>
#include "common.h"
#include "error.h"
#include "str.h"
#include "lexer.h"
#include "var.h"

/* Notes:

   If the weighting variable is deleted somehow (for instance by
   end-of-scope of TEMPORARY), weighting must be canceled.

   Scratch vars may not be used for weighting. */

/* WEIGHT transformation. */
typedef struct
  {
    trns_header h;
    int src;			/* `value' index of weighting variable. */
    int dest;			/* `value' index of $WEIGHT. */
  }
weight_trns;

int
cmd_weight (void)
{
  match_id (WEIGHT);

  if (match_id (OFF))
    default_dict.weight_var[0] = 0;
  else
    {
      variable *v;

      match_tok (BY);
      v = parse_variable ();
      if (!v)
	return 0;
      if (v->type == ALPHA)
	return msg (SE, _("The weighting variable must be numeric."));
      if (v->name[0] == '#')
	return msg (SE, _("The weighting variable may not be scratch."));

      strcpy (default_dict.weight_var, v->name);
    }
  if (token != '.')
    return msg (SE, _("`.' expected in `WEIGHT' command"));
  return 1;
}

#if 0 /* FIXME: dead code. */
static int
weight_trns_proc (any_trns * _t, ccase * c)
{
  weight_trns *t = (weight_trns *) _t;

  c->data[t->dest].f = c->data[t->src].f;
  return -1;
}
#endif

/* Global functions. */ 

/* Sets the weight_index member of dictionary D to an appropriate
   value for the value of weight_var, and returns the weighting
   variable if any or NULL if none. */
variable *
update_weighting (dictionary * d)
{
  if (d->weight_var[0])
    {
      variable *v = find_dict_variable (d, d->weight_var);
      if (v && v->type == NUMERIC)
	{
	  d->weight_index = v->fv;
	  return v;
	}
      else
	{
#if GLOBAL_DEBUGGING
	  printf (_("bad weighting variable, canceling\n"));
#endif
	  d->weight_var[0] = 0;
	}
    }

  d->weight_index = -1;
  return NULL;
}

/* Turns off case weighting for dictionary D. */
void
stop_weighting (dictionary * d)
{
  d->weight_var[0] = 0;
}
