/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

/* AIX requires this to be the first thing in the file.  */
#include <config.h>
#if __GNUC__
#define alloca __builtin_alloca
#else
#if HAVE_ALLOCA_H
#include <alloca.h>
#else
#ifdef _AIX
#pragma alloca
#else
#ifndef alloca			/* predefined by HP cc +Olibcalls */
char *alloca ();
#endif
#endif
#endif
#endif

#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "common.h"
#include "error.h"
#include "getline.h"
#include "misc.h"
#include "settings.h"
#include "str.h"

#define VME _("Virtual memory exhausted.")

#if ENDIAN==UNKNOWN
/* BIG or LITTLE, depending on this machine's endianness, as detected
   at program startup. */
int endian;
#endif

#ifndef SECOND_LOWEST_VALUE
/* "Second lowest" value for a flt64; that is, (-FLT64_MAX) + epsilon. */
double second_lowest_value;
#endif

/* argv[0] with stripped leading directories. */
char *pgmname;

/* Whether FINISH. has been executed. */
int finished;

/* The current date in the form DD MMM YYYY. */
char curdate[12];

/* Whether we're dropping down to interactive mode immediately because
   we hit end-of-file unexpectedly (or whatever). */
int start_interactive;

/* Name of interactive command-line history file. */
#if HAVE_LIBHISTORY
char *history_file;
#endif

void *
xmalloc (size_t size)
{
  void *vp;
  if (size == 0)
    return NULL;
  vp = malloc (size);
  if (!vp)
    {
#if DEBUGGING && __CHECKER__
      msg (MW, _("xmalloc(%lu): Inducing segfault."), (unsigned long) size);
      *((int *) 0) = 0;
#endif
      msg (FE, "xmalloc(%lu): %s", (unsigned long) size, VME);
    }
  return vp;
}

void *
xcalloc (size_t size)
{
  void *vp = xmalloc (size);
  memset (vp, 0, size);
  return vp;
}

void *
xrealloc (void *ptr, size_t size)
{
  void *vp;
  if (!size)
    {
      if (ptr)
	free (ptr);
      return NULL;
    }
  if (ptr)
    vp = realloc (ptr, size);
  else
    vp = malloc (size);
  if (!vp)
    msg (FE, "xrealloc(%lu): %s", (unsigned long) size, VME);
  return vp;
}

char *
xstrdup (const char *s)
{
  size_t size;
  char *t;

  assert (s != NULL);
  size = strlen (s) + 1;
  t = malloc (size);
  if (!t)
    msg (FE, "xstrdup(%lu): %s", (unsigned long) strlen (s), VME);
  memcpy (t, s, size);
  return t;
}

#if DEBUGGING
#undef stderr
#define stderr stdout
#endif /* DEBUGGING */

/* Support function for inferior compilers. */

#if !__GNUC__
char *
spprintf (char *buf, const char *format,...)
{
#if HAVE_GOOD_SPRINTF
  int count;
#endif
  va_list args;

  va_start (args, format);
#if HAVE_GOOD_SPRINTF
  count =
#endif
    vsprintf (buf, format, args);
  va_end (args);

#if HAVE_GOOD_SPRINTF
  return &buf[count];
#else
  return strchr (buf, 0);
#endif
}
#endif /* !__GNUC__ */

/* Support function for inferior compilers with buggy libraries. */

#if !__GNUC__ && !HAVE_GOOD_SPRINTF
int
nsprintf (char *buf, const char *format,...)
{
  va_list args;

  va_start (args, format);
  vsprintf (buf, format, args);
  va_end (args);

  return strlen (buf);
}

int
nvsprintf (char *buf, const char *format, va_list args)
{
  vsprintf (buf, format, args);
  return strlen (buf);
}
#endif /* not gcc and not good sprintf */
