/*
 * Grace - Graphics for Exploratory Data Analysis
 * 
 * Home page: http://plasma-gate.weizmann.ac.il/Grace/
 * 
 * Copyright (c) 1991-95 Paul J Turner, Portland, OR
 * Copyright (c) 1996-98 GRACE Development Team
 * 
 * Maintained by Evgeny Stambulchik <fnevgeny@plasma-gate.weizmann.ac.il>
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *
 * graph Panel
 *
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/Frame.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>

#include "globals.h"
#include "protos.h"
#include "motifinc.h"

static Widget but1[2];

static Widget graph_show_frame;
static Widget graph_focus_frame;

/*
 * Panel item declarations
 */
static Widget *graph_setcur_choice_item;
static Widget *graph_focus_choice_item;
static Widget graph_drawfocus_choice_item;
static Widget *graph_activate_choice_item;
static Widget *graph_kill_choice_item;
static Widget *graph_copyfrom_choice_item;
static Widget *graph_copyto_choice_item;
static Widget *graph_swapfrom_choice_item;
static Widget *graph_swapto_choice_item;
static Widget *graph_show_choice_item;

/*
 * Event and Notify proc declarations
 */
static void graph_focus_notify_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void graph_activate_notify_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void graph_kill_notify_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void graph_copy_notify_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void graph_show_notify_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void graph_swap_notify_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void update_focus_items(int gno);
static void update_show_items(void);

void update_graph_items(void)
{
    update_focus_items(cg);
    update_show_items();
}

static void graph_focus_notify_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int newcg;

    switch ((int) GetChoice(graph_focus_choice_item)) {
    case 0:
	focus_policy = FOCUS_CLICK;
	break;
    case 1:
	focus_policy = FOCUS_SET;
	break;
    case 2:
	focus_policy = FOCUS_FOLLOWS;
	break;
    }
    draw_focus_flag = (int) XmToggleButtonGetState(graph_drawfocus_choice_item) ? TRUE : FALSE;
    newcg = (int) GetChoice(graph_setcur_choice_item);
    if (newcg != cg) {
	switch_current_graph(newcg);
    }
}

static void graph_activate_notify_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int gno = (int) GetChoice(graph_activate_choice_item);

    set_graph_active(gno);
    update_all(cg);
    drawgraph();
    set_dirtystate();
}

static void graph_kill_notify_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    kill_graph((int) GetChoice(graph_kill_choice_item));
    update_all(cg);
    drawgraph();
}

static void graph_copy_notify_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int from = (int) GetChoice(graph_copyfrom_choice_item);
    int to = (int) GetChoice(graph_copyto_choice_item);

    if (from == to) {
	errwin("Graph from and graph to are the same");
	return;
    }
    if (!isactive_graph(from)) {
	errwin("Graph from isn't active");
	return;
    }
    if (isactive_graph(to)) {
	if (!yesno("Graph to copy to is active, kill it?", NULL, NULL, NULL)) {
	    return;
	}
    }
    copy_graph(from, to);
    update_all(cg);
    drawgraph();
}

static void graph_show_notify_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;

    for (i = 0; i < maxgraph; i++) {
	if (XmToggleButtonGetState(graph_show_choice_item[i]) == True) {
	    g[i].hidden = FALSE;
	} else {
	    g[i].hidden = TRUE;
	}
    }
    update_all(cg);
    drawgraph();
    set_dirtystate();
}

static void graph_swap_notify_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    int from = (int) GetChoice(graph_swapfrom_choice_item);
    int to = (int) GetChoice(graph_swapto_choice_item);

    if (from == to) {
	errwin("Graph from and graph to are the same");
	return;
    }
    swap_graph(from, to);
    update_all(cg);
    drawgraph();
}


static void update_focus_items(int gno)
{
    int itest = 0;

    if (graph_focus_frame) {
	SetChoice(graph_setcur_choice_item, gno);
	if (focus_policy == FOCUS_SET) {
	    itest = 1;
	} else if (focus_policy == FOCUS_CLICK) {
	    itest = 0;
	} else if (focus_policy == FOCUS_FOLLOWS) {
	    itest = 2;
	}
	SetChoice(graph_focus_choice_item, itest);
	XmToggleButtonSetState(graph_drawfocus_choice_item,
			       draw_focus_flag == TRUE ? True : False, False);
    }
}

static void update_show_items(void)
{
    int i;

    if (graph_show_frame) {
	for (i = 0; i < maxgraph; i++) {
	    if (g[i].hidden) {
		XmToggleButtonSetState(graph_show_choice_item[i], False, False);
	    } else {
		XmToggleButtonSetState(graph_show_choice_item[i], True, False);
	    }
	}
    }
}


void create_gactive_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget top, dialog;

    set_wait_cursor();
    if (top == NULL) {
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	top = XmCreateDialogShell(app_shell, "Activate graphs", NULL, 0);
	handle_close(top);
	dialog = XmCreateRowColumn(top, "rc", NULL, 0);

	graph_activate_choice_item = CreateGraphChoice(dialog, "Activate graph: ", maxgraph, 0);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) graph_activate_notify_proc, (XtPointer) NULL);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) top);

	XtManageChild(dialog);
    }
    XtRaise(top);
    unset_wait_cursor();
}

void create_gcopy_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget top, dialog;

    set_wait_cursor();
    if (top == NULL) {
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	top = XmCreateDialogShell(app_shell, "Copy graphs", NULL, 0);
	handle_close(top);
	dialog = XmCreateRowColumn(top, "rc", NULL, 0);

	graph_copyfrom_choice_item = CreateGraphChoice(dialog, "Copy graph: ", maxgraph, 0);
	graph_copyto_choice_item = CreateGraphChoice(dialog, "To graph: ", maxgraph, 0);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) graph_copy_notify_proc, (XtPointer) NULL);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) top);

	XtManageChild(dialog);
    }
    XtRaise(top);
    unset_wait_cursor();
}

void create_gswap_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget top, dialog;

    set_wait_cursor();
    if (top == NULL) {
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	top = XmCreateDialogShell(app_shell, "Swap graphs", NULL, 0);
	handle_close(top);
	dialog = XmCreateRowColumn(top, "rc", NULL, 0);

	graph_swapfrom_choice_item = CreateGraphChoice(dialog, "Swap graph: ", maxgraph, 0);

	graph_swapto_choice_item = CreateGraphChoice(dialog, "With graph: ", maxgraph, 0);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) graph_swap_notify_proc, (XtPointer) NULL);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) top);

	XtManageChild(dialog);
    }
    XtRaise(top);
    unset_wait_cursor();
}

void create_gkill_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget top, dialog;

    set_wait_cursor();
    if (top == NULL) {
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	top = XmCreateDialogShell(app_shell, "Kill graphs", NULL, 0);
	handle_close(top);
	dialog = XmCreateRowColumn(top, "rc", NULL, 0);

	graph_kill_choice_item = CreateGraphChoice(dialog, "Kill graph: ", maxgraph, 0);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) graph_kill_notify_proc, (XtPointer) NULL);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) top);

	XtManageChild(dialog);
    }
    XtRaise(top);
    unset_wait_cursor();
}

void create_gfocus_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget dialog;

    set_wait_cursor();
    if (graph_focus_frame == NULL) {
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	graph_focus_frame = XmCreateDialogShell(app_shell, "Set focus", NULL, 0);
	handle_close(graph_focus_frame);
	dialog = XmCreateRowColumn(graph_focus_frame, "rc", NULL, 0);
	graph_setcur_choice_item = CreateGraphChoice(dialog, "Set current graph to", maxgraph, 0);

	graph_focus_choice_item = (Widget *) CreatePanelChoice(dialog, "Graph focus",
							       4,
							     "Button press",
							       "As set",
							    "Follows mouse",
							       NULL,
							       NULL);
	graph_drawfocus_choice_item = XtVaCreateManagedWidget("Display focus markers",
					  xmToggleButtonWidgetClass, dialog,
							      NULL);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) graph_focus_notify_proc, (XtPointer) NULL);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) graph_focus_frame);

	XtManageChild(dialog);
    }
    XtRaise(graph_focus_frame);
    update_focus_items(cg);
    unset_wait_cursor();
}

void create_gshow_frame(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;
    static Widget dialog;
    Widget lab, rc;

    set_wait_cursor();
    if (graph_show_frame == NULL) {
	char *label1[2];
	label1[0] = "Accept";
	label1[1] = "Close";
	graph_show_frame = XmCreateDialogShell(app_shell, "Show graphs", NULL, 0);
	handle_close(graph_show_frame);
	dialog = XmCreateRowColumn(graph_show_frame, "rc", NULL, 0);

	lab = XtVaCreateManagedWidget("Select graphs for display (a graph must also be active to be seen):", xmLabelWidgetClass, dialog,
				      NULL);
	rc = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, dialog,
				     XmNorientation, XmHORIZONTAL,
				     XmNnumColumns, maxgraph / 10,
				     XmNpacking, XmPACK_COLUMN,
				     NULL);
	graph_show_choice_item = (Widget *) XtMalloc(maxgraph * sizeof(Widget));
	for (i = 0; i < maxgraph; i++) {
	    sprintf(buf, "%d", i);
	    graph_show_choice_item[i] = XtVaCreateManagedWidget(buf,
					      xmToggleButtonWidgetClass, rc,
								NULL);
	}

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, dialog, NULL);

	CreateCommandButtons(dialog, 2, but1, label1);
	XtAddCallback(but1[0], XmNactivateCallback, (XtCallbackProc) graph_show_notify_proc, (XtPointer) NULL);
	XtAddCallback(but1[1], XmNactivateCallback, (XtCallbackProc) destroy_dialog, (XtPointer) graph_show_frame);

	XtManageChild(dialog);
    }
    XtRaise(graph_show_frame);
    update_show_items();
    unset_wait_cursor();
}

