/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#include "vectP.h"
#include "pickP.h"
#include "appearance.h"

#ifndef alloca
#include <alloca.h>
#endif

Vect *
VectPick(Vect *v, Pick *p, Appearance *ap, Transform T)
{
  Point3 plist[2];
  int i, j, k, which, ok[2];
  int found;
  unsigned int apflag;

  /* Make sure that the edges do not register as visible - otherwise 
   * they could really mess things up */
  if (ap != NULL) {
    apflag = ap->flag;
    ap->flag &= ~APF_EDGEDRAW;
  }
    
  found = 0;

  for (i = k = 0; i < v->nvec; i++) {
    int nv = abs(v->vnvert[i]);
    
    which = 0;
    ok[0] = (0 < HPt3TransPt3(T, &v->p[k], &plist[0]));
    if(nv == 1) {
	if(ok[0] && PickFace(1, &plist[0], p, ap)) {
	    found = 1;
	    p->vi = k;
	}
	k++;
	continue;
    }
    for (j = 0; j < nv - 1;) {
      ok[1] = (0 < HPt3TransPt3(T, &v->p[k + (++j)], &plist[1]));
      if ((ok[0]||ok[1]) && PickFace(2, plist, p, ap)) {
	found = 1;
	p->vi = p->vi ? k + j : k + j - 1;
	p->ei[0] = k + j - 1;
	p->ei[1] = k + j;
      }
      ok[0] = ok[1];
      plist[0] = plist[1];
    }
    if (v->vnvert[i] < 0) {
      ok[1] = (0 < HPt3TransPt3(T, &v->p[k], &plist[1]));
      if ((ok[0]||ok[1]) && PickFace(2, plist, p, ap)) {
	found = 1;
	p->vi = p->vi ? k : k + j;
	p->ei[0] = k + j;
	p->ei[1] = k;
      }
    }
    k += nv;
  }

  if (ap != NULL) ap->flag = apflag;

  if (!found) return NULL;

  if (p->found & PW_VERT) 
    HPt3Transform(T, &v->p[p->vi], &p->v);
  else p->vi = -1;
  if (p->found & PW_EDGE) {
    HPt3Transform(T, &v->p[p->ei[0]], &p->e[0]);
    HPt3Transform(T, &v->p[p->ei[1]], &p->e[1]);
  } else p->ei[0] = p->ei[1] = -1;

  /* It really doesn't make sense to claim that we found a face hit...*/
  p->found &= ~PW_FACE;
  p->fi = -1;
  TmCopy(T, p->Tprim);

  return v;
}
