#include <stdio.h>
#include <string.h>
#include "geom.h"
#include "geomclass.h"
#include "transform.h"
#include "sphereP.h"

Sphere *SphereFLoad(file, fname) 
     FILE *file;
     char *fname;
{
  int ch;
  HPoint3 center;
  float radius;
  Geom *sphere;
  char *token;
  int space;
  int i;

  if (file == NULL) return NULL;

  space = TM_EUCLIDEAN;

  token = GeomToken(file);
  switch(*token) {
  case 'E': space = TM_EUCLIDEAN; token++; break;
  case 'H': space = TM_HYPERBOLIC; token++; break;
  case 'S':
    if(token[1] == 'S') {
	space = TM_SPHERICAL;
	token++;
    }
    break;
  }
  if(strcmp(token, "SPHERE") != 0)
    return NULL;

  if ( fgetnf(file, 1, &radius, 0) != 1 || fgetnf(file, 3, &center.x, 0) != 3 ) {
    OOGLSyntax(file, "%s: SPHERE: expected radius, then x y z", fname);
    return NULL;
  }

  center.w = 1.0;

  sphere = GeomCreate("sphere", CR_RADIUS, (double)radius, 
		      CR_CENTER, &center, CR_SPACE, space, CR_END);

  return (Sphere *)sphere;
}
