/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "skelP.h"

static GeomClass *aSkelMethods = NULL;

int SkelPresent = 1;

static char skelName[] = "skel";

char *
SkelName()
{
	return skelName;
}


GeomClass      *
SkelMethods()
{
	if (!aSkelMethods)
	{
		aSkelMethods = GeomClassCreate(skelName);

		aSkelMethods->name = SkelName;
		aSkelMethods->methods = (GeomMethodsFunc *) SkelMethods;
		aSkelMethods->create = (GeomCreateFunc *) SkelCreate;
		aSkelMethods->fload = (GeomFLoadFunc *) SkelFLoad;
		aSkelMethods->fsave = (GeomFSaveFunc *) SkelFSave;
		aSkelMethods->bound = (GeomBoundFunc *) SkelBound;
		aSkelMethods->Delete = (GeomDeleteFunc *) SkelDelete;
		aSkelMethods->draw = (GeomDrawFunc *) SkelDraw;
		aSkelMethods->copy = (GeomCopyFunc *) SkelCopy;
		aSkelMethods->pick = (GeomPickFunc *) SkelPick;
		aSkelMethods->transform = 
		  (GeomTransformFunc *) SkelTransform;
		aSkelMethods->transformto =
		  (GeomTransformToFunc *) SkelTransform; /* == TransformTo */
	}
	return aSkelMethods;
}
