/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

BBox *
QuadBound( Quad *q, Transform T )
{
    register int v;
    HPoint3 min, max;
    register HPoint3 *p;
    Point3 p0;

    p = q->p[0];

#ifdef BBOX_ND_HACK
    if(q->flags & QUAD_4D)
	return BBox_ND_hack(NULL, p, 4*q->maxquad);
#endif

    if (T != TM_IDENTITY)
    	HPt3TransPt3(T, p, (Point3 *)&min);
    else
	HPt3Normalize(p, &min);
    max = min;
    for( v = 4 * q->maxquad; --v > 0; ) {
        p++;
        if (T != TM_IDENTITY)
	    HPt3TransPt3(T, p, (Point3 *)&p0);
	else {
	    p0 = *(Point3 *)p;
	    if(p->w != 1.0 && p->w != 0.0)
		p0.x /= p->w, p0.y /= p->w, p0.z /= p->w;
	}
        if(min.x > p0.x) min.x = p0.x;
        else if(max.x < p0.x) max.x = p0.x;
        if(min.y > p0.y) min.y = p0.y;
        else if(max.y < p0.y) max.y = p0.y;
        if(min.z > p0.z) min.z = p0.z;
        else if(max.z < p0.z) max.z = p0.z;
    }
    
    return (BBox *) GeomCCreate (NULL, BBoxMethods(),
		CR_MIN, &min, CR_MAX, &max, CR_END);
}

