/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

/* $Header: /u/gcg/ngrap/src/lib/gprim/polylist/RCS/plevert.c,v 1.10 1995/07/07 14:01:30 trowley Exp $ */
/* $Source: /u/gcg/ngrap/src/lib/gprim/polylist/RCS/plevert.c,v $ */


/*
 * Evert all the normals in a polylist.
 */

#include	"polylistP.h"

PolyList *
PolyListEvert( register PolyList *polylist )
{
	register Poly	*p;
	register Vertex	*v;
	register int	i;

	polylist->flags ^= PL_EVNORM;

	if ((polylist->flags & (PL_HASVN|PL_HASPN)) == 0)
	{
		PolyListComputeNormals(polylist);
	} else {
	    i = polylist->n_polys;
	    for (p = polylist->p; --i >= 0; p++)
	    {
		p->pn.x = -p->pn.x;
		p->pn.y = -p->pn.y;
		p->pn.z = -p->pn.z;
	    }
	    i = polylist->n_verts;
	    for (v = polylist->vl; --i >= 0; v++) {
		v->vn.x = -v->vn.x;
		v->vn.y = -v->vn.y;
		v->vn.z = -v->vn.z;
	    }
	}
	return (polylist);
}
