/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "meshP.h"

static GeomClass *aMeshMethods = NULL;

int MeshPresent = 1;

static char meshName[] = "mesh";

extern Mesh      *MeshCreate( va_list );
extern Mesh      *MeshDelete( Mesh * );
extern Mesh      *MeshCopy( Mesh * );

char *
MeshName()
{
	return meshName;
}

GeomClass      *
MeshMethods()
{
	if (!aMeshMethods)
	{
		aMeshMethods = GeomClassCreate(meshName);

		aMeshMethods->name = MeshName;
		aMeshMethods->methods = (GeomMethodsFunc *) MeshMethods;
		aMeshMethods->create = (GeomCreateFunc *) MeshCreate;
		aMeshMethods->Delete = (GeomDeleteFunc *) MeshDelete;
		aMeshMethods->copy = (GeomCopyFunc *) MeshCopy;
		aMeshMethods->fload = (GeomFLoadFunc *) MeshFLoad;
		aMeshMethods->fsave = (GeomFSaveFunc *) MeshFSave;
		aMeshMethods->bound = (GeomBoundFunc *) MeshBound;
		aMeshMethods->boundsphere = 
		  (GeomBoundSphereFunc *) MeshBoundSphere;
		aMeshMethods->evert = (GeomEvertFunc *) MeshEvert;
		aMeshMethods->draw = (GeomDrawFunc *) MeshDraw;
		aMeshMethods->pick = (GeomPickFunc *) MeshPick;
		aMeshMethods->transform = 
		  (GeomTransformFunc *) MeshTransform;
		aMeshMethods->transformto = 
		  (GeomTransformToFunc *) MeshTransformTo;
	}
	return aMeshMethods;
}
