/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include <stdio.h>
#include "inst.h"
#include "streampool.h"
#include "transobj.h"
#include "handleP.h"
#include "listP.h"


List *
ListImport( Pool *p )
{
    List *list = NULL;
    List *new, **tailp = &list;
    int c, prevc;
    int brack = 0;
    int any = 0;
    FILE *file;

    if(p == NULL || (file = p->inf) == NULL)
	return NULL;

    if(strcmp(GeomToken(file), "LIST") != 0)
	return NULL;

    while((c = fnextc(file, 0)) != EOF) {
	switch(c) {
	case ';':
	case ')':
	    goto done;
	case CBRA:
	    brack++;
	    fgetc(file);
	    continue;
	case CKET:
	    if(--brack < 0) goto done;
	    fgetc(file);
	    if(prevc == CBRA) {
		/* Interpret "{ }" as a NULL entry in a list.  Leave it
		 * there as a placeholder -- could be deliberate.
		 */
		new = (List *)GeomCCreate(NULL, ListMethods(), CR_END);
		*tailp = new;
		tailp = &new->cdr;
		any = 1;
	    }
	    break;
	default:
	    new = (List *)GeomCCreate(NULL, ListMethods(), CR_END);
	    if(GeomStreamIn(p, &new->carhandle, &new->car)) {
		*tailp = new;
		tailp = &new->cdr;
		if(new->carhandle)
		    HandleRegister(&new->carhandle, (Ref *)new,
			       (Ref **)&new->car, HandleUpdRef);
	    } else {
		OOGLSyntax(file,
		 "Couldn't read LIST in \"%s\": error reading embedded object",
		 p->poolname);
		GeomDelete((Geom *)new);
		GeomDelete((Geom *)list);
		return NULL;
	    }
	    any = 1;
	    break;
	}
	prevc = c;
    }

    /*
     * If no list members appeared at all, call it a valid, empty List.
     * But if there were list members but none were readable, fail.
     * Hence the "any" flag.
     */
  done:
    if(brack > 0)
	OOGLSyntax(file, "Couldn't read LIST in \"%s\": too many %c's",
		p->poolname, CBRA);
    if(!any)
	return (List *)GeomCCreate(NULL, ListMethods(), CR_END); /* null LIST */
    return list;
}

int
ListExport( List *l, Pool *p )
{
    if(p == NULL || p->outf == NULL)
	return 0;

    fprintf(p->outf, "LIST\n");
    while(l != NULL) {
	if(!GeomStreamOut( p, l->carhandle, l->car ))
	    return 0;
	l = l->cdr;
    }
    return 1;
}
