/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "geomclass.h"

/* this needs to be here so that the shared memory code can work */
Geom *
GGeomCopy(g, object )
Geom *g, *object;
{
    RefInit((Ref *)g, object->magic);
    g->Class = object->Class;
    g->ap = object->ap;
    if(g->ap != NULL)
	g->ap = ApCopy(g->ap, NULL);
    g->aphandle = NULL;
}

Geom *
GeomCopy( object )
Geom *object;
{
    Geom *g;

    /* this is a little tricky */
    if( object == NULL )
	return NULL;
    if( object->Class->copy ) {
	g = (*object->Class->copy)(object);
	if(g != NULL)
	    GGeomCopy(g, object);
    } else {
	GeomError(1/*Warning-unimpl*/,"GeomCopy: no copy method for %s: %x",
		GeomName(object), object);
	RefIncr((Ref *)object);	/* Copy by reference -- XXX stopgap! */
	g = object;
    }
    return g;
}

