/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
   Celeste Fowler */

#include "hpoint3.h"
#include "point3.h"
#include "bezierP.h"

Bezier *
BezierTransform( b, T )
     Bezier *b;
     Transform T;
{
  int i;
  Point3 *p;
  HPoint3 *hp;
  int limit = (b->degree_u + 1)*(b->degree_v + 1);
 
  if (b->CtrlPnts != NULL) 
    if (b->dimn == 3)
      for (i = 0, p = (Point3 *)b->CtrlPnts; i < limit; i++, p++)
	Pt3Transform(T, p, p);
    else if (b->dimn == 4)
      for (i = 0, hp = (HPoint3 *)b->CtrlPnts; i < limit; i++, hp++)
	HPt3Transform(T, hp, hp);
    else {
      OOGLError(1, "Bezier patch of unfamiliar dimensions.");
      return NULL;
    }

  GeomDelete((Geom *)b->mesh);
  b->mesh = NULL;

  return(b);
}

Bezier *
BezierTransformTo( b, T )
     Bezier *b;
     Transform T;
{
  return(BezierTransform(b, T));
}
