/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"

BBox           *
BBoxTransform(bbox, T)
	register BBox	*bbox;
	Transform T;
{
	register int i;
	register HPoint3 *p;
	HPoint3 vert[8];

	for(i = 0, p = &vert[0]; i < 8; i++, p++) {
		*p = bbox->min;
		if(i&1) p->x = bbox->max.x;	/* Neat huh */
		if(i&2) p->y = bbox->max.y;	/* Binary encoding of verts */
		if(i&4) p->z = bbox->max.z;
	}
	

	p = &vert[0];
	HPt3Transform(T, p, p);
	HPt3Normalize(p, p);
	bbox->min = *p;
	bbox->max = bbox->min;
	i = 8-1;
	do {
	    p++;
	    HPt3Transform(T, p, p);
	    HPt3Normalize(p, p);
	    if(bbox->min.x > p->x) bbox->min.x = p->x;
	    else if(bbox->max.x < p->x) bbox->max.x = p->x;
	    if(bbox->min.y > p->y) bbox->min.y = p->y;
	    else if(bbox->max.y < p->y) bbox->max.y = p->y;
	    if(bbox->min.z > p->z) bbox->min.z = p->z;
	    else if(bbox->max.z < p->z) bbox->max.z = p->z;
	} while(--i > 0);
	return (bbox);
}
