/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "transform3.h"

void
Ctm3AlignX( Transform3 T, Point3 *axis )
{
    Ctm3Align( T, axis, &TM3_XAXIS );
}

void
Ctm3AlignY( Transform3 T, Point3 *axis )
{
    Ctm3Align( T, axis, &TM3_YAXIS );
}

void
Ctm3AlignZ( Transform3 T, Point3 *axis )
{
    Ctm3Align( T, axis, &TM3_ZAXIS );
}

void
Ctm3Align( Transform3 T, Point3 *axis, Point3 *newaxis )
{
    Transform3 Ta;

    Tm3Align( Ta, axis, newaxis );
    Tm3Concat(Ta, T, T);
}
