#! /bin/sh
# Wrapper for emodule_wish which sets up tcl/tk library envariables.
# We use our own private libraries rather than system-installed ones,
# if emodule_wish is statically linked with a particular version --
# at present, it's tcl 7.4 and tk 4.0 on most systems.
# On Linux, we link dynamically with the system libtk.so/libtcl.so
# (which for us are tcl 7.5 & tk 4.1 as of 1997), so we don't supply the
# library files, and this script avoids setting {TCL,TK}_LIBRARY.
# So, on Linux, emodule_wish fails if the installed tcl is earlier than
# 7.5, as it uses some functions that weren't in 7.4.

tcl=${GEOMROOT}/data/tcltk/tcl7.4
tk=${GEOMROOT}/data/tcltk/tk4.0

if [ -d "$tcl" ]; then
  TCL_LIBRARY="$tcl"; export TCL_LIBRARY
fi
if [ -d "$tk" ]; then
  TK_LIBRARY="$tk"; export TK_LIBRARY
fi

thisdir=`dirname $0`
if [ -f $thisdir/libtcl.so.1 ]; then
  LD_LIBRARY_PATH=${LD_LIBRARY_PATH}${LD_LIBRARY_PATH+:}$thisdir
  export LD_LIBRARY_PATH
fi
exec $thisdir/emodule_wish ${1+"$@"}
