/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef STUBDEFS
#define STUBDEFS

#include "geomclass.h"

extern GeomClass *StubMethods();

/*
 * This file is #include'd by aspiring per-class stub routines.
 * Each STUBMETHODS() macro creates a Present tag indicating that the
 * corresponding library is not loaded, and a Methods() routine
 * which complains if called.
 * They're useful as components of a libstub.a library used to link with
 * applications that only need a few of the OOGL object-types.
 * Assuming classA, classB, etc. are needed, link as in
 *    -lgeom -lclassA -lclassB ... -lgeom -lstub   -lbbox -l3d -lm
 *
 * Use of the method-specific stubs (e.g. libstubdraw) is quite different;
 * see stubdraw.c.
 */

#if defined(__STDC__) || defined(__ANSI_CPP__)

#define STUBMETHODS(prefix, meth, lib) \
	int prefix##Present = 0; \
	GeomClass *prefix##Methods() { return StubMethods(meth, lib); }

#else /*plain C*/

#define	STUBMETHODS(prefix, meth, lib) \
	int prefix/**/Present = 0; \
	GeomClass *prefix/**/Methods() { return StubMethods(meth, lib); }
#endif
#endif
