/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef NDMESHDEF
#define NDMESHDEF

#include "bbox.h"
#include "meshflag.h"

#ifndef NULL
#define NULL 0
#endif

#ifndef	FALSE
#define	FALSE 0
#endif

#define NDMESHMAGIC	GeomMagic ('N', 1)

typedef struct NDMesh NDMesh;


extern GeomClass *NDMeshMethods( void );
extern char	*NDMeshName( void );
extern NDMesh	*NDMeshFLoad( FILE *, char * );
extern NDMesh	*NDMeshLoad( char * );
extern NDMesh	*NDMeshSave( NDMesh *, char * );
extern NDMesh	*NDMeshFSave( NDMesh *, FILE * );
extern BBox	*NDMeshBound( NDMesh *, Transform );
extern Geom	*NDMeshBoundSphere( NDMesh *, Transform, int );
extern NDMesh	*NDMeshDice( NDMesh *, int (*proc)() );
extern NDMesh	*NDMeshDraw( NDMesh * );
extern NDMesh	*NDMeshPick( NDMesh *, Pick *, Appearance *, Transform );
extern NDMesh   *NDMeshTransform( NDMesh *, Transform );

#endif /*MESHDEF*/
