/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "mggl.h"

typedef struct mgglcontext {
  struct mgcontext mgctx;	/* The mgcontext */
  int born;			/* Has window been displayed on the screen? */
  int win;			/* GL window ID, or 0 */
  long zmin, zmax;		/* max z-buffer value */
  short is_PI;			/* Personal Iris? (pgon vs tmesh speed) */
  short turbo;			/* Turbo PI flag: for bug workaround */
  void (*d4f)();		/* For shaded colors: mggl_d4f() or c4f() */
  ColorA Cd;			/* Cached diffuse color = mat->diffuse * Kd */
  int lmcolor;			/* lmcolor: LMC_DIFFUSE or LMC_COLOR */
  int cantwoside;		/* hardware will do 2-sided lighting (auto normal flipping) */
  void (*n3f)();		/* For everted normals: n3f(n, p) */ 
  Point3 cpos;			/* current-coordinate position of camera
				 * (used for software normal flipping) */

  long znudge;			/* _mgc.zfnudge in integer Z-buffer units */
  long znear, zfar;		/* Current Z-buffer lsetdepth() limits */
  int oldopts;			/* For knowing when we need to gconfig() */
  vvec room;			/* Scratch space */
  void *GLXdisplay;		/* X11 Display pointer; if non-NULL, mixed model */
  int singlewin, doublewin;	/* X window id's for single- & double-buf */
				/* windows -- only relevant in GLX mode */
  int tevbound;			/* Texturing currently enabled? */
  TxUser *curtex;		/* Currently-bound texture (NULL if none) */
  int dither;			/* dither enabled? */
  TxUser *bgimage;		/* background image */
} mgglcontext;


#define	MAXZNUDGE	8	/* Max possible depth of mggl_closer()/farther() calls */

/* We save the current W2C/C2W xforms on each call to mggl_worldbegin()
 * because the ModelView matrix stack actually stores both our object
 * xform and the view matrix:
 *
 *   ModelView = [ obj xform ] * [ W2C ]
 *
 * Since we use the GL ModelView stack to keep track of our object xform,
 * instead of using the actual stack in the mgcontext struct, having
 * ModelView = W2C corresponds to [ obj xform ] = identity.  We save W2C
 * and C2W on each mggl_worldbegin() because _mgc->cam might change
 * during the course of the frame, but isn't supposed to be reinterpreted
 * until the next mggl_worldbegin().
 */

#define _mgglc		((mgglcontext*)_mgc)

void mggl_d4f( float c[4] );
void mggl_n3fevert( Point3 *n, HPoint3 *p );
void mggl_txpurge( TxUser *tu );
