/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:42 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 3 */

/*
 * This function contains 26 FP additions, 20 FP multiplications,
 * (or, 18 additions, 12 multiplications, 8 fused multiply/add),
 * 15 stack variables, and 24 memory accesses
 */
static const fftw_real K866025403 = FFTW_KONST(+0.866025403784438646763723170752936183471402627);
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_3(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (3 * iostride);
     {
	  fftw_real tmp31;
	  fftw_real tmp32;
	  fftw_real tmp33;
	  fftw_real tmp34;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp31 = X[0];
	  tmp32 = X[iostride];
	  tmp33 = X[2 * iostride];
	  tmp34 = tmp32 + tmp33;
	  X[iostride] = tmp31 - (K500000000 * tmp34);
	  X[0] = tmp31 + tmp34;
	  Y[-iostride] = K866025403 * (tmp33 - tmp32);
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 2) {
	  fftw_real tmp11;
	  fftw_real tmp28;
	  fftw_real tmp16;
	  fftw_real tmp24;
	  fftw_real tmp21;
	  fftw_real tmp25;
	  fftw_real tmp22;
	  fftw_real tmp27;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp11 = X[0];
	  tmp28 = Y[-2 * iostride];
	  {
	       fftw_real tmp13;
	       fftw_real tmp15;
	       fftw_real tmp12;
	       fftw_real tmp14;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp13 = X[iostride];
	       tmp15 = Y[-iostride];
	       tmp12 = c_re(W[0]);
	       tmp14 = c_im(W[0]);
	       tmp16 = (tmp12 * tmp13) - (tmp14 * tmp15);
	       tmp24 = (tmp14 * tmp13) + (tmp12 * tmp15);
	  }
	  {
	       fftw_real tmp18;
	       fftw_real tmp20;
	       fftw_real tmp17;
	       fftw_real tmp19;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp18 = X[2 * iostride];
	       tmp20 = Y[0];
	       tmp17 = c_re(W[1]);
	       tmp19 = c_im(W[1]);
	       tmp21 = (tmp17 * tmp18) - (tmp19 * tmp20);
	       tmp25 = (tmp19 * tmp18) + (tmp17 * tmp20);
	  }
	  tmp22 = tmp16 + tmp21;
	  tmp27 = tmp24 + tmp25;
	  {
	       fftw_real tmp23;
	       fftw_real tmp26;
	       fftw_real tmp29;
	       fftw_real tmp30;
	       ASSERT_ALIGNED_DOUBLE();
	       X[0] = tmp11 + tmp22;
	       tmp23 = tmp11 - (K500000000 * tmp22);
	       tmp26 = K866025403 * (tmp24 - tmp25);
	       Y[-2 * iostride] = tmp23 - tmp26;
	       X[iostride] = tmp23 + tmp26;
	       Y[0] = tmp27 + tmp28;
	       tmp29 = tmp28 - (K500000000 * tmp27);
	       tmp30 = K866025403 * (tmp21 - tmp16);
	       X[2 * iostride] = -(tmp29 - tmp30);
	       Y[-iostride] = tmp30 + tmp29;
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp8;
	  fftw_real tmp10;
	  fftw_real tmp6;
	  fftw_real tmp3;
	  fftw_real tmp5;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  tmp3 = X[iostride];
	  tmp5 = X[2 * iostride];
	  {
	       fftw_real tmp7;
	       fftw_real tmp9;
	       fftw_real tmp2;
	       fftw_real tmp4;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp7 = c_im(W[0]);
	       tmp8 = tmp7 * tmp3;
	       tmp9 = c_im(W[1]);
	       tmp10 = tmp9 * tmp5;
	       tmp2 = c_re(W[0]);
	       tmp4 = c_re(W[1]);
	       tmp6 = (tmp2 * tmp3) + (tmp4 * tmp5);
	  }
	  X[0] = tmp1 + tmp6;
	  Y[0] = tmp8 + tmp10;
	  X[iostride] = tmp1 + (K866025403 * (tmp8 - tmp10)) - (K500000000 * tmp6);
     }
}

static const int twiddle_order[] =
{1, 2};
fftw_codelet_desc fftw_hc2hc_forward_3_desc =
{
     "fftw_hc2hc_forward_3",
     (void (*)()) fftw_hc2hc_forward_3,
     3,
     FFTW_FORWARD,
     FFTW_HC2HC,
     51,
     2,
     twiddle_order,
};
