/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:49 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 9 */

/*
 * This function contains 209 FP additions, 146 FP multiplications,
 * (or, 136 additions, 73 multiplications, 73 fused multiply/add),
 * 43 stack variables, and 72 memory accesses
 */
static const fftw_real K1_500000000 = FFTW_KONST(+1.500000000000000000000000000000000000000000000);
static const fftw_real K939692620 = FFTW_KONST(+0.939692620785908384054109277324731469936208134);
static const fftw_real K342020143 = FFTW_KONST(+0.342020143325668733044099614682259580763083368);
static const fftw_real K984807753 = FFTW_KONST(+0.984807753012208059366743024589523013670643252);
static const fftw_real K173648177 = FFTW_KONST(+0.173648177666930348851716626769314796000375677);
static const fftw_real K300767466 = FFTW_KONST(+0.300767466360870593278543795225003852144476517);
static const fftw_real K1_705737063 = FFTW_KONST(+1.705737063904886419256501927880148143872040591);
static const fftw_real K642787609 = FFTW_KONST(+0.642787609686539326322643409907263432907559884);
static const fftw_real K766044443 = FFTW_KONST(+0.766044443118978035202392650555416673935832457);
static const fftw_real K1_326827896 = FFTW_KONST(+1.326827896337876792410842639271782594433726619);
static const fftw_real K1_113340798 = FFTW_KONST(+1.113340798452838732905825904094046265936583811);
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);
static const fftw_real K866025403 = FFTW_KONST(+0.866025403784438646763723170752936183471402627);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);
static const fftw_real K1_732050807 = FFTW_KONST(+1.732050807568877293527446341505872366942805254);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_9(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (9 * iostride);
     {
	  fftw_real tmp198;
	  fftw_real tmp226;
	  fftw_real tmp220;
	  fftw_real tmp205;
	  fftw_real tmp208;
	  fftw_real tmp203;
	  fftw_real tmp212;
	  fftw_real tmp223;
	  fftw_real tmp215;
	  fftw_real tmp224;
	  fftw_real tmp204;
	  fftw_real tmp209;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp219;
	       fftw_real tmp196;
	       fftw_real tmp197;
	       fftw_real tmp217;
	       fftw_real tmp218;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp218 = Y[-3 * iostride];
	       tmp219 = K1_732050807 * tmp218;
	       tmp196 = X[0];
	       tmp197 = X[3 * iostride];
	       tmp217 = tmp197 - tmp196;
	       tmp198 = tmp196 + (K2_000000000 * tmp197);
	       tmp226 = tmp219 - tmp217;
	       tmp220 = tmp217 + tmp219;
	  }
	  {
	       fftw_real tmp199;
	       fftw_real tmp202;
	       fftw_real tmp213;
	       fftw_real tmp211;
	       fftw_real tmp210;
	       fftw_real tmp214;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp199 = X[iostride];
	       tmp205 = Y[-iostride];
	       {
		    fftw_real tmp200;
		    fftw_real tmp201;
		    fftw_real tmp206;
		    fftw_real tmp207;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp200 = X[4 * iostride];
		    tmp201 = X[2 * iostride];
		    tmp202 = tmp200 + tmp201;
		    tmp213 = K866025403 * (tmp200 - tmp201);
		    tmp206 = Y[-2 * iostride];
		    tmp207 = Y[-4 * iostride];
		    tmp208 = tmp206 - tmp207;
		    tmp211 = K866025403 * (tmp207 + tmp206);
	       }
	       tmp203 = tmp199 + tmp202;
	       tmp210 = tmp199 - (K500000000 * tmp202);
	       tmp212 = tmp210 - tmp211;
	       tmp223 = tmp210 + tmp211;
	       tmp214 = (K500000000 * tmp208) + tmp205;
	       tmp215 = tmp213 + tmp214;
	       tmp224 = tmp214 - tmp213;
	  }
	  X[0] = tmp198 + (K2_000000000 * tmp203);
	  tmp204 = tmp198 - tmp203;
	  tmp209 = K1_732050807 * (tmp205 - tmp208);
	  X[3 * iostride] = tmp204 - tmp209;
	  X[6 * iostride] = tmp204 + tmp209;
	  {
	       fftw_real tmp221;
	       fftw_real tmp216;
	       fftw_real tmp222;
	       fftw_real tmp228;
	       fftw_real tmp225;
	       fftw_real tmp227;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp221 = (K1_113340798 * tmp212) + (K1_326827896 * tmp215);
	       tmp216 = (K766044443 * tmp212) - (K642787609 * tmp215);
	       tmp222 = tmp216 + tmp220;
	       X[iostride] = (K2_000000000 * tmp216) - tmp220;
	       X[7 * iostride] = tmp221 - tmp222;
	       X[4 * iostride] = -(tmp221 + tmp222);
	       tmp228 = (K1_705737063 * tmp223) + (K300767466 * tmp224);
	       tmp225 = (K173648177 * tmp223) - (K984807753 * tmp224);
	       tmp227 = tmp226 - tmp225;
	       X[2 * iostride] = (K2_000000000 * tmp225) + tmp226;
	       X[8 * iostride] = tmp228 + tmp227;
	       X[5 * iostride] = tmp227 - tmp228;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 8) {
	  fftw_real tmp88;
	  fftw_real tmp131;
	  fftw_real tmp179;
	  fftw_real tmp104;
	  fftw_real tmp151;
	  fftw_real tmp169;
	  fftw_real tmp93;
	  fftw_real tmp98;
	  fftw_real tmp99;
	  fftw_real tmp145;
	  fftw_real tmp153;
	  fftw_real tmp175;
	  fftw_real tmp181;
	  fftw_real tmp172;
	  fftw_real tmp180;
	  fftw_real tmp138;
	  fftw_real tmp152;
	  fftw_real tmp109;
	  fftw_real tmp114;
	  fftw_real tmp115;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp84;
	       fftw_real tmp100;
	       fftw_real tmp87;
	       fftw_real tmp149;
	       fftw_real tmp103;
	       fftw_real tmp130;
	       fftw_real tmp129;
	       fftw_real tmp150;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp84 = X[0];
	       tmp100 = Y[0];
	       {
		    fftw_real tmp85;
		    fftw_real tmp86;
		    fftw_real tmp101;
		    fftw_real tmp102;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp85 = X[3 * iostride];
		    tmp86 = Y[-6 * iostride];
		    tmp87 = tmp85 + tmp86;
		    tmp149 = K866025403 * (tmp85 - tmp86);
		    tmp101 = Y[-3 * iostride];
		    tmp102 = X[6 * iostride];
		    tmp103 = tmp101 - tmp102;
		    tmp130 = K866025403 * (tmp101 + tmp102);
	       }
	       tmp88 = tmp84 + tmp87;
	       tmp129 = tmp84 - (K500000000 * tmp87);
	       tmp131 = tmp129 - tmp130;
	       tmp179 = tmp129 + tmp130;
	       tmp104 = tmp100 + tmp103;
	       tmp150 = tmp100 - (K500000000 * tmp103);
	       tmp151 = tmp149 + tmp150;
	       tmp169 = tmp150 - tmp149;
	  }
	  {
	       fftw_real tmp89;
	       fftw_real tmp92;
	       fftw_real tmp132;
	       fftw_real tmp135;
	       fftw_real tmp105;
	       fftw_real tmp108;
	       fftw_real tmp133;
	       fftw_real tmp136;
	       fftw_real tmp94;
	       fftw_real tmp97;
	       fftw_real tmp139;
	       fftw_real tmp142;
	       fftw_real tmp110;
	       fftw_real tmp113;
	       fftw_real tmp140;
	       fftw_real tmp143;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp90;
		    fftw_real tmp91;
		    fftw_real tmp106;
		    fftw_real tmp107;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp89 = X[iostride];
		    tmp90 = X[4 * iostride];
		    tmp91 = Y[-7 * iostride];
		    tmp92 = tmp90 + tmp91;
		    tmp132 = tmp89 - (K500000000 * tmp92);
		    tmp135 = K866025403 * (tmp90 - tmp91);
		    tmp105 = Y[-iostride];
		    tmp106 = Y[-4 * iostride];
		    tmp107 = X[7 * iostride];
		    tmp108 = tmp106 - tmp107;
		    tmp133 = K866025403 * (tmp106 + tmp107);
		    tmp136 = tmp105 - (K500000000 * tmp108);
	       }
	       {
		    fftw_real tmp95;
		    fftw_real tmp96;
		    fftw_real tmp111;
		    fftw_real tmp112;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp94 = X[2 * iostride];
		    tmp95 = Y[-5 * iostride];
		    tmp96 = Y[-8 * iostride];
		    tmp97 = tmp95 + tmp96;
		    tmp139 = tmp94 - (K500000000 * tmp97);
		    tmp142 = K866025403 * (tmp95 - tmp96);
		    tmp110 = Y[-2 * iostride];
		    tmp111 = X[5 * iostride];
		    tmp112 = X[8 * iostride];
		    tmp113 = tmp111 + tmp112;
		    tmp140 = K866025403 * (tmp111 - tmp112);
		    tmp143 = tmp110 + (K500000000 * tmp113);
	       }
	       tmp93 = tmp89 + tmp92;
	       tmp98 = tmp94 + tmp97;
	       tmp99 = tmp93 + tmp98;
	       {
		    fftw_real tmp141;
		    fftw_real tmp144;
		    fftw_real tmp173;
		    fftw_real tmp174;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp141 = tmp139 + tmp140;
		    tmp144 = tmp142 + tmp143;
		    tmp145 = (K173648177 * tmp141) - (K984807753 * tmp144);
		    tmp153 = (K984807753 * tmp141) + (K173648177 * tmp144);
		    tmp173 = tmp139 - tmp140;
		    tmp174 = tmp143 - tmp142;
		    tmp175 = (K342020143 * tmp173) - (K939692620 * tmp174);
		    tmp181 = (K939692620 * tmp173) + (K342020143 * tmp174);
	       }
	       {
		    fftw_real tmp170;
		    fftw_real tmp171;
		    fftw_real tmp134;
		    fftw_real tmp137;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp170 = tmp136 - tmp135;
		    tmp171 = tmp132 + tmp133;
		    tmp172 = (K173648177 * tmp170) + (K984807753 * tmp171);
		    tmp180 = (K173648177 * tmp171) - (K984807753 * tmp170);
		    tmp134 = tmp132 - tmp133;
		    tmp137 = tmp135 + tmp136;
		    tmp138 = (K766044443 * tmp134) - (K642787609 * tmp137);
		    tmp152 = (K766044443 * tmp137) + (K642787609 * tmp134);
		    tmp109 = tmp105 + tmp108;
		    tmp114 = tmp110 - tmp113;
		    tmp115 = tmp109 + tmp114;
	       }
	  }
	  X[0] = tmp88 + tmp99;
	  {
	       fftw_real tmp119;
	       fftw_real tmp125;
	       fftw_real tmp123;
	       fftw_real tmp127;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp117;
		    fftw_real tmp118;
		    fftw_real tmp121;
		    fftw_real tmp122;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp117 = tmp104 - (K500000000 * tmp115);
		    tmp118 = K866025403 * (tmp93 - tmp98);
		    tmp119 = tmp117 - tmp118;
		    tmp125 = tmp118 + tmp117;
		    tmp121 = tmp88 - (K500000000 * tmp99);
		    tmp122 = K866025403 * (tmp114 - tmp109);
		    tmp123 = tmp121 - tmp122;
		    tmp127 = tmp121 + tmp122;
	       }
	       {
		    fftw_real tmp116;
		    fftw_real tmp120;
		    fftw_real tmp124;
		    fftw_real tmp126;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp116 = c_re(W[5]);
		    tmp120 = c_im(W[5]);
		    Y[-2 * iostride] = (tmp116 * tmp119) - (tmp120 * tmp123);
		    X[6 * iostride] = (tmp120 * tmp119) + (tmp116 * tmp123);
		    tmp124 = c_re(W[2]);
		    tmp126 = c_im(W[2]);
		    Y[-5 * iostride] = (tmp124 * tmp125) - (tmp126 * tmp127);
		    X[3 * iostride] = (tmp126 * tmp125) + (tmp124 * tmp127);
	       }
	  }
	  Y[-8 * iostride] = tmp104 + tmp115;
	  {
	       fftw_real tmp158;
	       fftw_real tmp147;
	       fftw_real tmp161;
	       fftw_real tmp162;
	       fftw_real tmp155;
	       fftw_real tmp157;
	       fftw_real tmp146;
	       fftw_real tmp154;
	       fftw_real tmp128;
	       fftw_real tmp148;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp158 = K866025403 * (tmp138 - tmp145);
	       tmp146 = tmp138 + tmp145;
	       tmp147 = tmp131 + tmp146;
	       tmp161 = tmp131 - (K500000000 * tmp146);
	       tmp162 = K866025403 * (tmp153 - tmp152);
	       tmp154 = tmp152 + tmp153;
	       tmp155 = tmp151 + tmp154;
	       tmp157 = tmp151 - (K500000000 * tmp154);
	       tmp128 = c_re(W[0]);
	       tmp148 = c_im(W[0]);
	       X[iostride] = (tmp128 * tmp147) + (tmp148 * tmp155);
	       Y[-7 * iostride] = (tmp128 * tmp155) - (tmp148 * tmp147);
	       {
		    fftw_real tmp165;
		    fftw_real tmp167;
		    fftw_real tmp164;
		    fftw_real tmp166;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp165 = tmp158 + tmp157;
		    tmp167 = tmp161 + tmp162;
		    tmp164 = c_re(W[3]);
		    tmp166 = c_im(W[3]);
		    Y[-4 * iostride] = (tmp164 * tmp165) - (tmp166 * tmp167);
		    X[4 * iostride] = (tmp166 * tmp165) + (tmp164 * tmp167);
	       }
	       {
		    fftw_real tmp159;
		    fftw_real tmp163;
		    fftw_real tmp156;
		    fftw_real tmp160;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp159 = tmp157 - tmp158;
		    tmp163 = tmp161 - tmp162;
		    tmp156 = c_re(W[6]);
		    tmp160 = c_im(W[6]);
		    Y[-iostride] = (tmp156 * tmp159) - (tmp160 * tmp163);
		    X[7 * iostride] = (tmp160 * tmp159) + (tmp156 * tmp163);
	       }
	  }
	  {
	       fftw_real tmp186;
	       fftw_real tmp177;
	       fftw_real tmp189;
	       fftw_real tmp190;
	       fftw_real tmp183;
	       fftw_real tmp185;
	       fftw_real tmp176;
	       fftw_real tmp182;
	       fftw_real tmp168;
	       fftw_real tmp178;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp186 = K866025403 * (tmp175 - tmp172);
	       tmp176 = tmp172 + tmp175;
	       tmp177 = tmp169 + tmp176;
	       tmp189 = tmp169 - (K500000000 * tmp176);
	       tmp190 = K866025403 * (tmp180 + tmp181);
	       tmp182 = tmp180 - tmp181;
	       tmp183 = tmp179 + tmp182;
	       tmp185 = tmp179 - (K500000000 * tmp182);
	       tmp168 = c_re(W[1]);
	       tmp178 = c_im(W[1]);
	       Y[-6 * iostride] = (tmp168 * tmp177) - (tmp178 * tmp183);
	       X[2 * iostride] = (tmp178 * tmp177) + (tmp168 * tmp183);
	       {
		    fftw_real tmp193;
		    fftw_real tmp195;
		    fftw_real tmp192;
		    fftw_real tmp194;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp193 = tmp186 + tmp185;
		    tmp195 = tmp189 + tmp190;
		    tmp192 = c_re(W[4]);
		    tmp194 = c_im(W[4]);
		    X[5 * iostride] = (tmp192 * tmp193) + (tmp194 * tmp195);
		    Y[-3 * iostride] = (tmp192 * tmp195) - (tmp194 * tmp193);
	       }
	       {
		    fftw_real tmp187;
		    fftw_real tmp191;
		    fftw_real tmp184;
		    fftw_real tmp188;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp187 = tmp185 - tmp186;
		    tmp191 = tmp189 - tmp190;
		    tmp184 = c_re(W[7]);
		    tmp188 = c_im(W[7]);
		    X[8 * iostride] = (tmp184 * tmp187) + (tmp188 * tmp191);
		    Y[0] = (tmp184 * tmp191) - (tmp188 * tmp187);
	       }
	  }
     }
     if (i == m) {
	  fftw_real tmp11;
	  fftw_real tmp34;
	  fftw_real tmp64;
	  fftw_real tmp37;
	  fftw_real tmp65;
	  fftw_real tmp17;
	  fftw_real tmp23;
	  fftw_real tmp5;
	  fftw_real tmp28;
	  fftw_real tmp7;
	  fftw_real tmp41;
	  fftw_real tmp67;
	  fftw_real tmp51;
	  fftw_real tmp29;
	  fftw_real tmp19;
	  fftw_real tmp52;
	  fftw_real tmp44;
	  fftw_real tmp68;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp33;
	       fftw_real tmp36;
	       fftw_real tmp8;
	       fftw_real tmp10;
	       fftw_real tmp35;
	       fftw_real tmp32;
	       fftw_real tmp9;
	       fftw_real tmp31;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp32 = Y[-iostride];
	       tmp33 = K866025403 * tmp32;
	       tmp36 = K1_500000000 * tmp32;
	       tmp8 = X[iostride];
	       tmp9 = X[4 * iostride];
	       tmp10 = tmp8 + tmp9;
	       tmp35 = K866025403 * (tmp9 - tmp8);
	       tmp11 = tmp8 + tmp10;
	       tmp31 = tmp8 - (K500000000 * tmp10);
	       tmp34 = tmp31 - tmp33;
	       tmp64 = tmp31 + tmp33;
	       tmp37 = tmp35 + tmp36;
	       tmp65 = tmp36 - tmp35;
	  }
	  {
	       fftw_real tmp1;
	       fftw_real tmp3;
	       fftw_real tmp2;
	       fftw_real tmp4;
	       fftw_real tmp42;
	       fftw_real tmp6;
	       fftw_real tmp15;
	       fftw_real tmp16;
	       fftw_real tmp18;
	       fftw_real tmp40;
	       fftw_real tmp39;
	       fftw_real tmp43;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp1 = X[0];
	       tmp3 = X[2 * iostride];
	       tmp2 = X[3 * iostride];
	       tmp4 = tmp2 + tmp3;
	       tmp42 = K866025403 * (tmp2 - tmp1);
	       tmp6 = tmp1 + tmp2;
	       tmp15 = Y[-2 * iostride];
	       tmp17 = Y[0];
	       tmp16 = Y[-3 * iostride];
	       tmp18 = tmp16 + tmp17;
	       tmp40 = K866025403 * (tmp16 - tmp17);
	       tmp23 = tmp15 - tmp16;
	       tmp5 = tmp1 + tmp4;
	       tmp28 = tmp1 - (K500000000 * tmp4);
	       tmp7 = tmp6 + tmp3;
	       tmp39 = tmp3 - (K500000000 * tmp6);
	       tmp41 = tmp39 + tmp40;
	       tmp67 = tmp39 - tmp40;
	       tmp51 = K866025403 * (tmp2 - tmp3);
	       tmp29 = K866025403 * (tmp16 + tmp15);
	       tmp19 = tmp15 - tmp18;
	       tmp52 = (K500000000 * tmp23) + tmp17;
	       tmp43 = tmp15 + (K500000000 * tmp18);
	       tmp44 = tmp42 + tmp43;
	       tmp68 = tmp43 - tmp42;
	  }
	  {
	       fftw_real tmp20;
	       fftw_real tmp24;
	       fftw_real tmp22;
	       fftw_real tmp12;
	       fftw_real tmp14;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp20 = K866025403 * tmp19;
	       tmp24 = (tmp23 - tmp17) + (K500000000 * tmp19);
	       tmp22 = K866025403 * (tmp11 - tmp7);
	       tmp12 = tmp7 + tmp11;
	       tmp14 = tmp5 - (K500000000 * tmp12);
	       X[0] = tmp5 + tmp12;
	       {
		    fftw_real tmp25;
		    fftw_real tmp26;
		    fftw_real tmp13;
		    fftw_real tmp21;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp25 = c_im(W[2]);
		    tmp26 = c_re(W[2]);
		    X[3 * iostride] = (tmp25 * (tmp22 - tmp24)) + (tmp26 * (tmp14 + tmp20));
		    tmp13 = c_re(W[5]);
		    tmp21 = c_im(W[5]);
		    X[6 * iostride] = (tmp13 * (tmp14 - tmp20)) - (tmp21 * (tmp22 + tmp24));
	       }
	  }
	  {
	       fftw_real tmp63;
	       fftw_real tmp75;
	       fftw_real tmp70;
	       fftw_real tmp80;
	       fftw_real tmp74;
	       fftw_real tmp77;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp63 = tmp28 + tmp29;
	       tmp75 = tmp52 - tmp51;
	       {
		    fftw_real tmp66;
		    fftw_real tmp69;
		    fftw_real tmp72;
		    fftw_real tmp73;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp66 = (K173648177 * tmp64) - (K984807753 * tmp65);
		    tmp69 = (K939692620 * tmp67) + (K342020143 * tmp68);
		    tmp70 = tmp66 - tmp69;
		    tmp80 = K866025403 * (tmp66 + tmp69);
		    tmp72 = (K984807753 * tmp64) + (K173648177 * tmp65);
		    tmp73 = (K342020143 * tmp67) - (K939692620 * tmp68);
		    tmp74 = tmp72 + tmp73;
		    tmp77 = K866025403 * (tmp73 - tmp72);
	       }
	       {
		    fftw_real tmp62;
		    fftw_real tmp71;
		    fftw_real tmp78;
		    fftw_real tmp81;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp62 = c_re(W[1]);
		    tmp71 = c_im(W[1]);
		    X[2 * iostride] = (tmp62 * (tmp63 + tmp70)) + (tmp71 * (tmp74 + tmp75));
		    tmp78 = tmp63 - (K500000000 * tmp70);
		    tmp81 = tmp75 - (K500000000 * tmp74);
		    {
			 fftw_real tmp76;
			 fftw_real tmp79;
			 fftw_real tmp82;
			 fftw_real tmp83;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp76 = c_re(W[4]);
			 tmp79 = c_im(W[4]);
			 X[5 * iostride] = (tmp76 * (tmp77 + tmp78)) + (tmp79 * (tmp80 + tmp81));
			 tmp82 = c_re(W[7]);
			 tmp83 = c_im(W[7]);
			 X[8 * iostride] = (tmp82 * (tmp78 - tmp77)) + (tmp83 * (tmp81 - tmp80));
		    }
	       }
	  }
	  {
	       fftw_real tmp30;
	       fftw_real tmp53;
	       fftw_real tmp46;
	       fftw_real tmp58;
	       fftw_real tmp50;
	       fftw_real tmp56;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp30 = tmp28 - tmp29;
	       tmp53 = tmp51 + tmp52;
	       {
		    fftw_real tmp38;
		    fftw_real tmp45;
		    fftw_real tmp48;
		    fftw_real tmp49;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp38 = (K766044443 * tmp34) - (K642787609 * tmp37);
		    tmp45 = (K173648177 * tmp41) - (K984807753 * tmp44);
		    tmp46 = tmp38 + tmp45;
		    tmp58 = K866025403 * (tmp38 - tmp45);
		    tmp48 = (K642787609 * tmp34) + (K766044443 * tmp37);
		    tmp49 = (K984807753 * tmp41) + (K173648177 * tmp44);
		    tmp50 = tmp48 + tmp49;
		    tmp56 = K866025403 * (tmp49 - tmp48);
	       }
	       {
		    fftw_real tmp27;
		    fftw_real tmp47;
		    fftw_real tmp55;
		    fftw_real tmp59;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp27 = c_re(W[0]);
		    tmp47 = c_im(W[0]);
		    X[iostride] = (tmp27 * (tmp30 + tmp46)) + (tmp47 * (tmp50 + tmp53));
		    tmp55 = tmp30 - (K500000000 * tmp46);
		    tmp59 = tmp53 - (K500000000 * tmp50);
		    {
			 fftw_real tmp54;
			 fftw_real tmp57;
			 fftw_real tmp60;
			 fftw_real tmp61;
			 ASSERT_ALIGNED_DOUBLE();
			 tmp54 = c_re(W[3]);
			 tmp57 = c_im(W[3]);
			 X[4 * iostride] = (tmp54 * (tmp55 + tmp56)) + (tmp57 * (tmp58 + tmp59));
			 tmp60 = c_re(W[6]);
			 tmp61 = c_im(W[6]);
			 X[7 * iostride] = (tmp60 * (tmp55 - tmp56)) + (tmp61 * (tmp59 - tmp58));
		    }
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8};
fftw_codelet_desc fftw_hc2hc_backward_9_desc =
{
     "fftw_hc2hc_backward_9",
     (void (*)()) fftw_hc2hc_backward_9,
     9,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     155,
     8,
     twiddle_order,
};
