/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * prop_install.c
 */

/*
 * Create PROP postmaster object
 */
#include <pm.h>
#include <defaults.h>
#include <prop.h>

static char *OBJ_NAME = "Prop";

static char *PROP[] = {
  "Prop.Reset",
  "Prop.N_Ifields", "Prop.Ifields_Names", "Prop.Ifields",
  "Prop.N_Dfields", "Prop.Dfields_Names", "Prop.Dfields",
  "Prop.N_Cfields", "Prop.Cfields_Names", "Prop.Cfields",
  "Prop.Cfields_Num_Choices", "Prop.Cfields_All_Choices",
  "Prop.Name", "Prop.Algorithms",
  "Prop.Load_Int", "Prop.Int_Num", "Prop.Load_Iter", 
};

typedef enum {
  RESET=0,
  N_IFIELDS, IFIELDS_NAMES, IFIELDS,
  N_DFIELDS, DFIELDS_NAMES, DFIELDS,
  N_CFIELDS, CFIELDS_NAMES, CFIELDS,
  CFIELDS_NUM_CHOICES, CFIELDS_ALL_CHOICES,
  NAME, ALGORITHMS,
  LOAD_INT, INT_NUM, LOAD_ITER
} PROP_t;

void
prop_install()
{
  int i;
  void prop_reset(), load_iter(), load_int();

  pm(CREATE_OBJ, OBJ_NAME,
     CREATE_ELEM, PROP[RESET], FNCT,
     CREATE_ELEM, PROP[N_IFIELDS], INT,
     CREATE_ELEM, PROP[IFIELDS_NAMES], STRNG_LIST,
     CREATE_ELEM, PROP[IFIELDS], INT_LIST,
     CREATE_ELEM, PROP[N_DFIELDS], INT,
     CREATE_ELEM, PROP[DFIELDS_NAMES], STRNG_LIST,
     CREATE_ELEM, PROP[DFIELDS], DBL_LIST,
     CREATE_ELEM, PROP[N_CFIELDS], INT,
     CREATE_ELEM, PROP[CFIELDS_NAMES], STRNG_LIST,
     CREATE_ELEM, PROP[CFIELDS], INT_LIST,
     CREATE_ELEM, PROP[CFIELDS_NUM_CHOICES], INT_LIST,
     CREATE_ELEM, PROP[CFIELDS_ALL_CHOICES], STRNG_LIST,
     CREATE_ELEM, PROP[NAME], STRNG,
     CREATE_ELEM, PROP[ALGORITHMS], STRNG_LIST,
     CREATE_ELEM, PROP[LOAD_INT], FNCT,
     CREATE_ELEM, PROP[INT_NUM], INT,
     CREATE_ELEM, PROP[LOAD_ITER], FNCT,
     NULL);

  pm(INIT, PROP[RESET],
     PUT, PROP[RESET], prop_reset,
     INIT, PROP[NAME], MAX_LONG_STR,
     INIT, PROP[ALGORITHMS], N_Int, MAX_LONG_STR,
     INIT, PROP[LOAD_INT],
     PUT, PROP[LOAD_INT], load_int,
     PUT, PROP[INT_NUM], DEFAULT_INTEGRATOR,
     INIT, PROP[LOAD_ITER],
     PUT, PROP[LOAD_ITER], load_iter,
     NULL);

  for (i=0; i<N_Int; i++) {
    pm(PUT, PROP[ALGORITHMS], i, Int_Sel[i].Int_Name, NULL);
  }
}

void
prop_reset()
{
  if( *((int *) pm( GET, "Model.Mapping_Flag", NULL )) ) 
    {
      pm(EXEC, PROP[LOAD_ITER], NULL);
    }
  else
    {
      pm(EXEC, PROP[LOAD_INT], NULL);
    }
}
