/*  -------------------------------------------------------------------

This program is the property of:

                             Cornell University 
                        Center for Applied Mathematics 
                              Ithaca, NY 14853

and may be used, modified and distributed freely, subject to the 
following restrictions:

       Any product which incorporates source code from the dstool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.

DsTool is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of FITNESS 
FOR A PARTICULAR PURPOSE.  The software is provided as is without 
any obligation on the part of Cornell faculty, staff or students to 
assist in its use, correction, modification or enhancement.

  -----------------------------------------------------------------  */
/*
 * oned_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `oned.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "oned_ui.h"

/*
 * Initialize an instance of object `oned'.
 */
oned_win_objects *
oned_win_objects_initialize(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (oned_win_objects *) calloc(1, sizeof (oned_win_objects))))
		return (oned_win_objects *) NULL;
	if (!ip->win)
		ip->win = oned_win_win_create(ip, owner);
	if (!ip->pan)
		ip->pan = oned_win_pan_create(ip, ip->win);
	if (!ip->points)
		ip->points = oned_win_points_create(ip, ip->pan);
	if (!ip->iter)
		ip->iter = oned_win_iter_create(ip, ip->pan);
	if (!ip->sketch)
		ip->sketch = oned_win_sketch_create(ip, ip->pan);
	if (!ip->diagonal)
		ip->diagonal = oned_win_diagonal_create(ip, ip->pan);
	if (!ip->clear)
		ip->clear = oned_win_clear_create(ip, ip->pan);
	if (!ip->forward)
		ip->forward = oned_win_forward_create(ip, ip->pan);
	if (!ip->backward)
		ip->backward = oned_win_backward_create(ip, ip->pan);
	if (!ip->contin)
		ip->contin = oned_win_continue_create(ip, ip->pan);
	return ip;
}

/*
 * Create object `oned' in the specified instance.
 */
Xv_opaque
oned_win_win_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	void oned_done_proc();
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 282,
		XV_HEIGHT, 176,
		XV_LABEL, "One Dimensional Mappings",
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_DONE_PROC,oned_done_proc,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `pan' in the specified instance.
 */
Xv_opaque
oned_win_pan_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `points' in the specified instance.
 */
Xv_opaque
oned_win_points_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern Panel_setting	oned_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Number of points:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100000,
		PANEL_MIN_VALUE, 1,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
	        PANEL_NOTIFY_PROC, oned_text_notify,
		NULL);
	return obj;
}
/*
 * Create object `iter' in the specified instance.
 */
Xv_opaque
oned_win_iter_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern Panel_setting	oned_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 48,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Map iterate:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100000,
		PANEL_MIN_VALUE, 1,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
	        PANEL_NOTIFY_PROC, oned_text_notify,
		NULL);
	return obj;
}

/*
 * Create object `sketch' in the specified instance.
 */
Xv_opaque
oned_win_sketch_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void		oned_sketch_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		PANEL_LABEL_STRING, "Sketch map",
		PANEL_NOTIFY_PROC, oned_sketch_notify,
		NULL);
	return obj;
}

/*
 * Create object `diagonal' in the specified instance.
 */
Xv_opaque
oned_win_diagonal_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void		oned_diagonal_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 112,
		PANEL_LABEL_STRING, "Draw diagonal",
		PANEL_NOTIFY_PROC, oned_diagonal_notify,
		NULL);
	return obj;
}

/*
 * Create object `clear' in the specified instance.
 */
Xv_opaque
oned_win_clear_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void		oned_clear_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 112,
		PANEL_LABEL_STRING, "Clear",
		PANEL_NOTIFY_PROC, oned_clear_notify,
		NULL);
	return obj;
}

/*
 * Create object `forward' in the specified instance.
 */
Xv_opaque
oned_win_forward_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void		oned_forward_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 144,
		PANEL_LABEL_STRING, "Forwards",
		PANEL_NOTIFY_PROC, oned_forward_notify,
		NULL);
	return obj;
}

/*
 * Create object `backward' in the specified instance.
 */
Xv_opaque
oned_win_backward_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void		oned_backward_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 101,
		XV_Y, 144,
		PANEL_LABEL_STRING, "Backwards",
		PANEL_NOTIFY_PROC, oned_backward_notify,
		NULL);
	return obj;
}
/*
 * Create object `backward' in the specified instance.
 */
Xv_opaque
oned_win_continue_create(ip, owner)
	oned_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void		oned_continue_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 196,
		XV_Y, 144,
		PANEL_LABEL_STRING, "Continue",
		PANEL_NOTIFY_PROC, oned_continue_notify,
		NULL);
	return obj;
}

