// cl_LF_I_mul().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_LF.h"


// Implementation.

#include "cl_LF_impl.h"
#include "cl_integer.h"
#include "cl_I.h"
#include "cl_DS.h"
#include "cl_F.h"

cl_R cl_LF_I_mul (const cl_LF& x, const cl_I& y)
{
// Method:
// If y=0, return 0.
// If x=0.0, return x.
// If y is longer than x, convert y to a float and multiply.
// Else multiply the mantissa of x with the absolute value of y, then round.
	if (eq(y,0)) { return 0; }
	if (TheLfloat(x)->expo == 0) { return x; }
	var cl_signean sign = -(cl_signean)minusp(y); // Vorzeichen von y
	var cl_I abs_y = (sign==0 ? y : -y);
	var uintL y_exp = integer_length(abs_y);
	var uintC len = TheLfloat(x)->len;
#ifndef CL_LF_PEDANTIC
	if (ceiling(y_exp,intDsize) > len)
		return x * cl_I_to_LF(y,len);
#endif
	// x lnger als y, direkt multiplizieren.
	SAVE_NUM_STACK;
	var const uintD* y_MSDptr;
	var uintC y_len;
	var const uintD* y_LSDptr;
	I_to_NDS_nocopy(abs_y, y_MSDptr=,y_len=,y_LSDptr=,cl_false,); // NDS zu y bilden, y_len>0
	if (mspref(y_MSDptr,0)==0) y_len--; // NUDS zu y bilden, y_len>0
	// Multiplizieren.
	var uintD* prodMSDptr;
	var uintC prodlen;
	UDS_UDS_mul_UDS(len,arrayLSDptr(TheLfloat(x)->data,len),
	                y_len,y_LSDptr,
	                prodMSDptr=,prodlen=,);
	// x fing mit 0 Nullbits an, y mit maximal intDsize-1 Nullbits,
	// daher fngt das Produkt mit maximal intDsize Nullbits an.
	var uintL shiftcount;
	if (mspref(prodMSDptr,0)==0) {
		shiftcount = intDsize;
		msshrink(prodMSDptr); prodlen--;
	} else {
		integerlengthD(mspref(prodMSDptr,0), shiftcount = intDsize -);
		if (shiftcount > 0)
			shiftleft_loop_lsp(prodMSDptr mspop (len+1),len+1,shiftcount,0);
	}
	// Produkt ist nun normalisiert: hchstes Bit =1.
	// exponent := exponent(x) + intDsize*y_len - shiftcount
	var uintL uexp = TheLfloat(x)->expo;
	var uintL iexp = intDsize*y_len - shiftcount; // >= 0 !
	uexp = uexp + iexp;
	if ((uexp < iexp) || (uexp > LF_exp_high))
		cl_error_floating_point_overflow();
	// Runden:
	var uintD* midptr = prodMSDptr mspop len;
	var uintC restlen = prodlen - len;
	if ( (restlen==0)
	     || ((sintD)mspref(midptr,0) >= 0) // nchstes Bit =0 -> abrunden
	     || ( ((mspref(midptr,0) & ((uintD)bit(intDsize-1)-1)) ==0) // Bit =1, weitere Bits >0 -> aufrunden
	          && !test_loop_msp(midptr mspop 1,restlen-1)
	          // round-to-even
	          && ((lspref(midptr,0) & bit(0)) ==0)
	   )    )
	  // abrunden
	  {}
	  else
	  // aufrunden
	  { if ( inc_loop_lsp(midptr,len) )
	      // bertrag durchs Aufrunden
	      { mspref(prodMSDptr,0) = bit(intDsize-1); // Mantisse := 10...0
	        if (++uexp == LF_exp_high+1) { cl_error_floating_point_overflow(); }
	  }   }
	return encode_LFu(TheLfloat(x)->sign ^ sign, uexp, prodMSDptr, len);
}
// Bit complexity (N = max(length(x),length(y))): O(M(N)).

