// cl_malloca(), cl_freea().

#ifndef _CL_MALLOCA_H
#define _CL_MALLOCA_H

// Replacement for alloca().
// ptr = cl_malloca(size) returns a memory block of given size. It can (but
// need not be) freed using cl_freea(ptr).
// freea(ptr) returns all blocks allocated since the allocation of ptr,
// including ptr itself.

#ifdef HAVE_STDLIB_H
  #include <stdlib.h>
#else
  #include <sys/types.h>
#endif

extern void* cl_malloca (size_t size);
extern void cl_freea (void* ptr);

// Hooks for num_stack_array().
// ptr = cl_malloca_getstack();  returns the current cl_malloca() state.
// cl_malloca_setstack(ptr);     frees all blocks allocated since ptr.
extern struct malloca_header* cl_malloca_list;
inline void* cl_malloca_getstack (void)
	{ return (void*)cl_malloca_list; }
extern void cl_malloca_setstack (void* ptr);

#endif /* _CL_MALLOCA_H */
