// as_cl_RA().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_number.h"


// Implementation.

#include "cl_N.h"

inline cl_boolean cl_RA_p (const cl_number& x)
{
	if (!x.pointer_p())
		switch (cl_tag((x).word)) {
		case cl_FN_tag:
			return cl_true;
		}
	else
		switch (((cl_heap*)x.pointer)->typetag) {
		case cl_typetag_bignum:
		case cl_typetag_ratio:
			return cl_true;
		}
	return cl_false;
}

const cl_RA& as_cl_RA (const cl_number& x, const char * filename, int line)
{
	if (cl_RA_p(x)) {
		DeclareType(cl_RA,x);
		return x;
	} else
		cl_as_error(x,"a rational number",filename,line);
}
