// General vectors of complex numbers.

#ifndef _CL_GV_COMPLEX_H
#define _CL_GV_COMPLEX_H

#include "cl_number.h"
#include "cl_GV.h"
#include "cl_io.h"

typedef cl_heap_GV<cl_N> cl_heap_GV_N;

struct cl_GV_N : public cl_GV<cl_N,cl_GV_any> {
public:
	// Constructors.
	cl_GV_N ();
	cl_GV_N (const cl_GV_N&);
	cl_GV_N (uintL len);
	// Assignment operators.
	cl_GV_N& operator= (const cl_GV_N&);
	// Private pointer manipulations.
	cl_GV_N (cl_heap_GV_N* p) : cl_GV<cl_N,cl_GV_any> (p) {}
	cl_GV_N (cl_private_thing p) : cl_GV<cl_N,cl_GV_any> (p) {}
};
inline cl_GV_N::cl_GV_N (const cl_GV_N& x) : cl_GV<cl_N,cl_GV_any> (as_cl_private_thing(x)) {}
CL_DEFINE_ASSIGNMENT_OPERATOR(cl_GV_N,cl_GV_N)
extern cl_heap_GV_N* cl_make_heap_GV_N (uintL len);
inline cl_GV_N::cl_GV_N (uintL len)
	: cl_GV<cl_N,cl_GV_any> (cl_make_heap_GV_N(len)) {}

// Private pointer manipulations. Never throw away a `struct cl_heap_GV_N *'!
extern cl_GV_N cl_null_GV_N;
inline cl_GV_N::cl_GV_N ()
	: cl_GV<cl_N,cl_GV_any> ((cl_heap_GV_N*) cl_null_GV_N) {}
CL_REQUIRE(cl_GV_N)

// Copy a vector.
extern cl_GV_N copy (const cl_GV_N&);

// Output.
inline void fprint (cl_ostream stream, const cl_GV_N& x)
{
	extern cl_print_flags cl_default_print_flags;
	extern void print_vector (cl_ostream stream, const cl_print_flags& flags, void (* fun) (cl_ostream, const cl_print_flags&, const cl_number&), const cl_GV_N& vector);
	extern void print_number (cl_ostream stream, const cl_print_flags& flags, const cl_number& z);
	print_vector(stream, cl_default_print_flags,
	             (void (*) (cl_ostream, const cl_print_flags&, const cl_number&))
	             &print_number,
	             x);
}
CL_DEFINE_PRINT_OPERATOR(cl_GV_N)

// Debugging support.
#ifdef CL_DEBUG
extern int cl_GV_N_debug_module;
static void* cl_GV_N_debug_dummy[] = { &cl_GV_N_debug_dummy,
	&cl_GV_N_debug_module
};
#endif

#endif /* _CL_GV_COMPLEX_H */
