CP_manipulate.cmd  script for "CirclePack"
Ken Stephenson, 1992

[1]:=act 0;close -p1;close -p2;set_cycle 5000;infile_read square5x5.p;set_screen -c 0.0 -.1 -h 2.3;disp -w -c -t A small packing we'll use to illustrate manipulations.;

[2]:=copy 1;disp -w -c -nc -t We will make the changes in canvas 1.;act 1;disp -w -c -t NOTE: most actions easier by mouse, but we use line commands.;

[3]:=disp -w -c -t First we add circles using 'add_cir 11 24 35 23' and 'fix';add_cir 11 24 35 23;fix;disp -c

[4]:=add_cir 11 24 35 23;add_cir 11 24 35 23;set_rad .187 50 51 52 53;set_rad .357 46 47 48 49;fix;disp -w -c -t We applied same action twice more, draw the underlying complex.;disp -f;

[5]:=enclose 0 11 24 35 23;disp -w -c -f -t 'enclose 0 11 24 35 23' closes up corners, but things don't fit right.;

[6]:=disp -w -u -t We 'repack' and 'fix' to get packing.;repack;fix;disp -c -f;
 
[7]:=add_gen 2 6;fix;disp -w -c -f -t Now 'add_gen 2 6' adds 2 gen's of 6-degree circles. A mess!;

[8]:=repack;fix;disp -w -c -f -t We have had to 'repack' and 'fix' again.;

[9]:=infile_path sample_cut.g;disp -w -c -g -t Having read in a path, we next apply 'cookie'.;

[10]:=cookie;disp -w -c -g -t 'cookie' cuts away circles outside the path.;

[11]:=disp -w -c -t Next we plan an 'adjoin' to paste a copy of pack 0 to pack 1.;

[12]:=disp -p0 -w -c -e 11 12 12 13 13 22 22 23 -nc 11 23; disp -w -c -e 69 68 68 67 67 66 66 93 -nc 93 69 -t We will identify the circles along marked edges.;

[13]:=adjoin 1 0 69 11 4;fix;disp -w -c -t We used 'adjoin 1 0 93 11 4', results go to pack 1, needs 'repack'.;

[14]:=repack;fix;disp -w -c -cf b(93,69) -cf 68 67 66 -t We have outlined the adjoined copy of pack 0.

[15]:=disp -w -c -t As a final operation, we will remove circles 76 and 77.;disp -nc 76 77;

[16]:=rm_cir 76;disp -w -c -nc 76  -t 'rm_cir 76' removes 76, but note that the old 77 is now 76.;

[17]:=rm_cir 76;disp -w -c -t Deletions change numbering, so be cautious.;

[18]:=disp -w -c -t The final packing can be saved with 'write filename'.;

    Now some branch point examples.

[19]:=act 0;close -p1;close -p2;set_cycle 5000;infile_read smallhex.p;copy 2;set_screen -c 0.0 -.1 -h 2.3;disp -w -c -t A script with some less standard operations of CirclePack.;

[20]:=disp -w -c -cffg 12 -t Branch points: Set angle sum `aim' as 4Pi. 'repack' -> Pack 1.;copy 1;act 1;set_aim 4.0 12;repack;fix;disp -w -c -cffg 12 -t The picture is quite confused, there are two `sheets' of circles.;

[21]:=center_vert 12;set_screen -h .6;disp -w -c -cffg 12 -t Look more closely at the branch point.;

[22]:=disp -w -c -t Watch as the 6 faces about the branch point are drawn.; disp -fffg 17  18  2  3  26  21;

[23]:=set_screen -r -c 0.0 -.1 -h 2.3;disp -w -c -t Now we will set the bdry radii to infinity and repack.;set_rad -.1 b;

[24]:=repack;fix;disp -w -c -cffg 12 -t Result: Andreev packing, analogue of 2-fold Blaschke product.;

Overlapping circle example.

[25]:=copy -p2 0;act 0;disp -w -c;set_screen -c 0 -.1 -h 2.3;disp -w -c -t Next we will work with `overlapping' circle packings.;

[26]:=copy 1;act 1;set_over .333 a;repack;fix;disp -w -c -t Here each pair of neighbors overlaps by Pi/3.;

[27]:=set_over -d;set_over .5 a;repack;fix;disp -w -c -t  Here each pair overlaps by Pi/2 (the max allowed).;

Specifying boundary angle aims

[28]:=copy -p2 0;act 0;add_gen 2 6;gamma 42;spiral 1.0 1.0;disp -w -c -t Next we illustrate setting of boundary angle sums `aims'.;copy 1;

[29]:=disp -w -c -cffg 65  70  80  85 -t Assign 'aims' pi to all bdry except pi/2 to indicated circles.;copy 1;h_to_e -p1;set_aim -p1 1.0 b;set_aim -p1 .5 65  70  80  85;repack -p1;

[30]:=act 1;fix;disp -p1 -w -c -f -cffg 65  70  80  85 -t Here it is repacked in euclidean plane.; 

[]:= script demo.cmd

smallhex.p
NODECOUNT:   37

ALPHA/BETA/GAMMA:   1  3  9

GEOMETRY:   hyperbolic

FLOWERS: 

1  6     13  11  12  10  19  18  13  

2  6     3  7  11  13  21  22  3  

3  3     4  7  2  22  

4  2     5  7  3  

5  3     14  6  7  4  

6  6     8  12  11  7  5  14  8  

7  6     11  2  3  4  5  6  11  

8  6     9  12  6  14  25  26  9  

9  6     20  10  12  8  26  27  20  

10  6     15  19  1  12  9  20  15  

11  6     2  7  6  12  1  13  2  

12  6     11  6  8  9  10  1  11  

13  6     21  2  11  1  18  24  21  

14  3     25  8  6  5  

15  6     36  16  19  10  20  29  36  

16  6     32  17  19  15  36  37  32  

17  6     23  18  19  16  32  33  23  

18  6     13  1  19  17  23  24  13  

19  6     1  10  15  16  17  18  1  

20  6     15  10  9  27  28  29  15  

21  6     22  2  13  24  30  31  22  

22  3     3  2  21  31  

23  6     24  18  17  33  34  35  24  

24  6     30  21  13  18  23  35  30  

25  2     26  8  14  

26  3     27  9  8  25  

27  3     28  20  9  26  

28  2     29  20  27  

29  3     36  15  20  28  

30  3     31  21  24  35  

31  2     22  21  30  

32  3     33  17  16  37  

33  3     34  23  17  32  

34  2     35  23  33  

35  3     30  24  23  34  

36  3     37  16  15  29  

37  2     32  16  36  

RADII: 
  0.219065   0.256547   0.333333   0.393047   0.333333 
  0.256547   0.272138   0.272138   0.256547   0.230257 
  0.230257   0.230257   0.230257   0.333333   0.256547 
  0.272138   0.256547   0.230257   0.230257   0.272138 
  0.272138   0.333333   0.272138   0.256547   0.393047 
  0.333333   0.333333   0.393047   0.333333   0.333333 
  0.393047   0.333333   0.333333   0.393047   0.333333 
  0.333333   0.393047 

CENTERS:
  0.000000  0.000000    0.331909  -0.191628    0.555490  -0.192427  
  0.668735  0.000000    0.555490  0.192427    0.331909  0.191628  
  0.442921  -0.000000    0.221460  0.383580    0.000000  0.383255  
  -0.110478  0.191353    0.220956  0.000000    0.110478  0.191353  
  0.110478  -0.191353    0.444392  0.384855    -0.331909  0.191628  
  -0.442921  -0.000000    -0.331909  -0.191628    -0.110478  -0.191353  
  -0.220956  0.000000    -0.221460  0.383580    0.221460  -0.383580  
  0.444392  -0.384855    -0.221460  -0.383580    0.000000  -0.383255  
  0.334367  0.579141    0.111098  0.577282    -0.111098  0.577282  
  -0.334367  0.579141    -0.444392  0.384855    0.111098  -0.577282  
  0.334367  -0.579141    -0.555490  -0.192427    -0.444392  -0.384855  
  -0.334367  -0.579141    -0.111098  -0.577282    -0.555490  0.192427  
  -0.668735  -0.000000  

ANGLESUMS: 
  6.283185    6.283185    2.761285    1.673849    2.761285  
  6.283185    6.283185    6.283185    6.283185    6.283185  
  6.283185    6.283185    6.283185    2.761285    6.283185  
  6.283185    6.283185    6.283185    6.283185    6.283185  
  6.283185    2.761285    6.283185    6.283185    1.673849  
  2.761285    2.761285    1.673849    2.761285    2.761285  
  1.673849    2.761285    2.761285    1.673849    2.761285  
  2.761285    1.673849  

ANDREEV_RADII: 
 0.313152  0.459209  -0.165710  -0.115629  -0.165704  0.459210  0.512382  0.512397  0.459210  0.348290  0.348287  0.348305  0.348302  -0.165715  0.459204  0.512393  0.459195  0.348285  0.348302  0.512386  0.512403  -0.165710  0.512398  0.459208  -0.115622  -0.165699  -0.165702  -0.115627  -0.165714  -0.165707  -0.115622  -0.165709  -0.165729  -0.115626  -0.165714  -0.165708  -0.115623 

END 

square5x5.p
NODECOUNT:   41

ALPHA/BETA/GAMMA:   3  1  1

GEOMETRY:   hyperbolic

FLOWERS: 

1  4     6  4  2  32  29  

2  8     1  4  7  5  3  33  30  32  1  

3  8     2  5  8  16  14  40  31  33  2  

4  4     1  6  7  2  1  

5  4     2  7  8  3  2  

6  4     11  9  7  4  1  

7  8     4  6  9  12  10  8  5  2  4  

8  8     3  5  7  10  13  20  18  16  3  

9  4     6  11  12  7  6  

10  4     7  12  13  8  7  

11  2     12  9  6  

12  4     13  10  7  9  11  

13  4     22  20  8  10  12  

14  8     3  16  18  17  15  41  38  40  3  

15  4     39  41  14  17  19  

16  4     3  8  18  14  3  

17  4     14  18  19  15  14  

18  8     16  8  20  22  21  19  17  14  16  

19  4     15  17  18  21  23  

20  4     8  13  22  18  8  

21  4     18  22  23  19  18  

22  4     23  21  18  20  13  

23  2     19  21  22  

24  2     29  27  25  

25  4     24  27  30  28  26  

26  4     25  28  31  36  34  

27  4     24  29  30  25  24  

28  4     25  30  31  26  25  

29  4     1  32  30  27  24  

30  8     27  29  32  2  33  31  28  25  27  

31  8     26  28  30  33  3  40  38  36  26  

32  4     29  1  2  30  29  

33  4     30  2  3  31  30  

34  4     26  36  38  37  35  

35  2     34  37  39  

36  4     26  31  38  34  26  

37  4     34  38  39  35  34  

38  8     36  31  40  14  41  39  37  34  36  

39  4     35  37  38  41  15  

40  4     31  3  14  38  31  

41  4     38  14  15  39  38  

RADII: 
  0.245613   0.212859   0.203912   0.093927   0.085988 
  0.257906   0.222474   0.212839   0.103290   0.093928 
  0.306509   0.257903   0.245613   0.212842   0.245613 
  0.085986   0.093928   0.222470   0.257906   0.093928 
  0.103294   0.257903   0.306507   0.306963   0.257906 
  0.245613   0.103343   0.093934   0.258065   0.222514 
  0.212855   0.093944   0.085994   0.258065   0.306963 
  0.093946   0.103343   0.222506   0.257902   0.085989 
  0.093932 

CENTERS:
  0.000000  0.411670    0.000023  0.205421    -0.000000  0.000000  
  -0.101808  0.305374    -0.101767  0.101800    -0.205864  0.411514  
  -0.205424  0.205494    -0.205411  0.000048    -0.305270  0.305340  
  -0.305333  0.101898    -0.412191  0.412268    -0.411446  0.205982  
  -0.411654  0.000113    -0.000078  -0.205412    -0.000183  -0.411657  
  -0.101814  -0.101751    -0.101949  -0.305316    -0.205524  -0.205388  
  -0.206049  -0.411414    -0.305397  -0.101739    -0.305407  -0.305195  
  -0.411542  -0.205790    -0.412336  -0.412115    0.412377  0.412419  
  0.411511  0.206014    0.411803  0.000172    0.305341  0.305394  
  0.305381  0.101834    0.205918  0.411606    0.205488  0.205464  
  0.205430  0.000001    0.101867  0.305372    0.101794  0.101777  
  0.411888  -0.205713    0.412564  -0.412163    0.305615  -0.101733  
  0.305218  -0.305466    0.205493  -0.205458    0.205678  -0.411626  
  0.101801  -0.101778    0.101692  -0.305420  

END

sample_cut.g
 PATH 
0.335800 0.879800  0.441600 0.806200  0.524400 -0.021800  0.243800 -0.799200  -0.372600 -0.808400  -0.749800 -0.523200  -0.947600 0.272600  -0.579600 0.751000  0.345000 0.884400 
END
