/* cp_cmd.c  to parse and call routines specified by command-line or 
mouse-selected text. */

#include "cp_head.h"
#include <sys/times.h>

extern char *get_selection();
extern Menu_item brush_m_item;
static char buff[BUFSIZE],cmd[2*BUFSIZE],data[2*BUFSIZE],next[BUFSIZE];

int
sort_cmd(cmd_stream) /* pick off individual commands in a stream. Return 1
if at least one parsing succeeded. Note: can have nested calls to 
this when executing named script cmds. */
char *cmd_stream;
{
	int count=0,flag=0,n;
	char *command,local_stream[BUFSIZE],buffer[16],*token_ptr;
	Textsw_index back1;

	strcpy(local_stream,cmd_stream);
	token_ptr=local_stream;
	while (*(token_ptr)==';') token_ptr++;
	stripsp(token_ptr);
	if ( (n=strcspn(token_ptr,";"))>0)
	 {
		command=token_ptr;
		if (*(token_ptr+n)!='\0') flag=1;
		*(token_ptr+n)='\0';
		token_ptr=token_ptr+n+1;
		stripsp(token_ptr);
		while (*(token_ptr)==';') token_ptr++;
		if ( (count=(handle_cmd(command)!=0) ) 
		   && *command!='!' && !cmd_search_depth) 
			strcpy(cmd_history,command);
		while ( flag && (n=strcspn(token_ptr,";"))>0 )
		 {
			flag=0;
			command=token_ptr;
			stripsp(command);
			if (*(token_ptr+n)!='\0') flag=1;
			*(token_ptr+n)='\0';
			token_ptr=token_ptr+n+1;
			stripsp(token_ptr);
			while (*(token_ptr)==';') token_ptr++;
			if (!handle_cmd(command))
			 {
				flag=0;
				continue;
			 }
			if (!cmd_search_depth && *command!='!')
			 {
				if (count) 
				 {
					strcat(cmd_history,";");
					strcat(cmd_history,command);
				 }
				else strcpy(cmd_history,command);
			 }
			count++;
		 }
	 }
	if ((back1=(Textsw_index)xv_get(msg_sw,TEXTSW_LENGTH))>0) back1--;
	xv_set(msg_sw,TEXTSW_INSERTION_POINT,back1,0);
	sprintf(buffer," (%d cmds)",count);
	textsw_insert(msg_sw,buffer,strlen(buffer));
	return count;
} /* sort_cmd */

int
handle_cmd(command) /* takes care of a single command only */
char *command;
{
	int p,count,hflag=0,i;
	char *dpoint;
	
	stripsp(command);
	dpoint=command;
	if (!grab_next(&dpoint,cmd)) return 0; /* command was empty */
	if (*dpoint==' ') dpoint++; /* should be a blank next */
	stripsp(dpoint);
	if (strncmp(dpoint,"-p",2)) p=current_p;
	else /* pack number is specified */
	 {
		dpoint +=2;
		if (!grab_next(&dpoint,next) 
			|| (next[0]!='-' && strlen(next)>1)) return 0;
		if (next[0]=='-') p=current_p;
		else if ((i=atoi(next))>=0 && i<NUM_PACKS) p=i;
		else return 0; /* no pack specified */
	 }
	strcpy(data,dpoint); /* rest is data */
	stripsp(data);
	if ((count=parse_cmd(&packdata[p],&hflag)) && hflag)
		/* if hflag is set, put cmd in history */
	 {
		sprintf(buf,"%s -p%d %s\n",cmd,p,data); 
		hmsg(buf);
	 }
	return count;
} /* handle_cmd */

int
parse_cmd(p,hflag) /* set hflag=1 to put this command (if successful)
into the history file. */
struct p_data *p;
int *hflag;
{
	int v,w,p1,spec_num,i=0,count=0,vert,n;
	int pass,d,j,hits,pnum=pack_num(p);
	char *dpoint,*nextpoint,*endptr;
	char filename[NAME_MAX],named_cmd[32];
	float radius,factor,ang,hh,h,dum,x,y;
	extern struct Vertlist *node_link_parse();
	struct Vertlist *vertlist,*trace;
	complex ctr,a;
	Rect rect;
	Mobius *newMob;
	Textsw_index pos;
	Textsw_status sw_status;

	dpoint=data;

/* UNLOCKED cases; locked packings skip these commands */

if (!p->locks)
 {
	switch (cmd[0])
	 {
case 'a':
 {
				/* ============ add barycenter ======== */
	if (!strncmp(cmd,"add_b",5))
	 {
		return (*hflag=add_barys(p,data));
	 }

				/* ============ add circle ============ */
	if (!strncmp(cmd,"add_cir",7))
	 {
		return (*hflag=add_circles(p,data));
	 }
				/* ========= add vert to edge =========== */
	if (!strncmp(cmd,"add_e",5))
	 {
		return (*hflag=split_flips(p,data,1));
	 }
				/* ========== add generations ======= */
	if (!strncmp(cmd,"add_gen",7))
	 {
		if (sscanf(data,"%d %d",&n,&d)!=2 
		   || n<1 || d<3 || d>MAX_PETALS) return 0;
		for (i=1;i<=n;i++)
		for (j=1;j<=p->num_bdry_comp;j++)
		 	count += add_layer(p, 
				p->bdry_starts[j],
				p->bdry_starts[j],d);
		return (*hflag=count);		
	 }
				/* ========== add ideal vertex ======= */
	if (!strncmp(cmd,"add_ideal",9))
	 {
		if ( p->num_bdry_comp==1  /* only 1 bdry comp? */
		   && (v=p->bdry_starts[1])>0 
		   && v<=p->nodecount 
		   && p->packK_ptr[v].bdry_flag );
		else if (sscanf(data,"%d",&v)!=1 || v < 1 
		   || v>p->nodecount 
		   || !p->packK_ptr[v].bdry_flag)
			return 0;
		return (ideal_bdry_node(p,v));
	 }
				/* ============== add layers ========== */
	if (!strncmp(cmd,"add_lay",7))
	 {
		if (sscanf(data,"%d %d %d",&v,&w,&d)!=3
		   || d<3 || d>MAX_PETALS 
		   || !p->packK_ptr[v].bdry_flag
		   || !p->packK_ptr[w].bdry_flag) return 0;
		if (w==v) v=p->packK_ptr[w].flower[0];
		return (*hflag=add_layer(p,v,w,d));
	 }
				/* ============= set alpha ========== */
	if (!strncmp(cmd,"alpha",5) )
	 {
		if (sscanf(data,"%d",&vert)==1) 
			return (set_alpha(p,vert));
		else return 0;
	 }
	break;
 }
case 'b':
 {
				/* ============== set beta =========== */
	if (!strncmp(cmd,"beta",4) )
	 {
		if (sscanf(data,"%d",&vert)==1) 
			return (set_beta(p,vert));
		else return 0;
	 }
	break;
 }
case 'c':
 {
				/* ============== compute: centers ======= */
	if (!strncmp(cmd,"compute_cent",12))
	 {
		return (comp_pack_centers(p));
	 }
				/* ============== cookie cutting ======= */
	if (!strncmp(cmd,"cookie",6))
	 {
		return (*hflag=cookie_cutter(p));
	 }
	break;
 }
case 'd':
 {
				/* ============== double ========== */
	if (!strncmp(cmd,"double",12))
	 {
		return (double_K(p,data));
	 }
	break;
 }
case 'e':
 {
				/* ============ enclose ============ */
	if (!strncmp(cmd,"enclose",7))
	 {
		if (*hflag=enfoldcall(p,data)) return 1;
		return 0;
	 }
				/* ========== e_to_h (outdated) ======== */
	if (!strncmp(cmd,"e_to_h",6))
	 {
		if (p->hes<0)
		 {strcpy(msgbuf,"Pack is already hyperbolic.");emsg();return 1;}
		geom_to_h_call(p,data);
		return (*hflag=1);
	 }
				/* ========== e_to_s (outdated) ========== */
	if (!strncmp(cmd,"e_to_s",6))
	 {
		if (p->hes>0)
		 {strcpy(msgbuf,"Pack is already spherical.");emsg();return 1;}
		geom_to_s_call(p,data);
		return (*hflag=1);
	 }
	break;
 }
case 'F':
 {
				/* ==== redo all housekeeping ======== */
	if (!strncmp(cmd,"Fix",3))
	 {
		return (*hflag=fix_call(p," -F"));
	 }
	break;
 }
case 'f':
 {
				/* ===== fexec ======= */
	if (!strncmp(cmd,"fexec",5))
	 {
	 	return (*hflag=fexec_call(data));
	 }
				/* == fix: comp centers and-or ang sums === */

	if (!strncmp(cmd,"fix",3))
	 {
		return (*hflag=fix_call(p,data));
	 }
				/* ============= flip edge ========= */
	if (!strncmp(cmd,"flip",4))
	 {
		return (*hflag=split_flips(p,data,2));
	 }
	break;
 }
case 'g':
 {
				/* ========== geom_to_h ================ */
	if (!strncmp(cmd,"geom_to_h",9))
	 {
		if (p->hes<0)
		 {strcpy(msgbuf,"Pack is already hyperbolic.");emsg();return 1;}
		geom_to_h_call(p,data);
		return (*hflag=1);
	 }
				/* ========== geom_to_s ================ */
	if (!strncmp(cmd,"geom_to_s",9))
	 {
		if (p->hes>0)
		 {strcpy(msgbuf,"Pack is already spherical.");emsg();return 1;}
		geom_to_s_call(p,data);
		return (*hflag=1);
	 }
				/* ========== geom_to_e ======== */
	if (!strncmp(cmd,"geom_to_e",9))
	 {
		if (p->hes==0)
		 {strcpy(msgbuf,"Pack is already euclidean.");emsg();return 1;}
		geom_to_e_call(p,data);
		return (*hflag=1);
	 }
	break;
 }
case 'h':
 {
				/* ========== h_to_e (outdated) ======== */
	if (!strncmp(cmd,"h_to_e",6))
	 {
		if (p->hes==0)
		 {strcpy(msgbuf,"Pack is already euclidean.");emsg();return 1;}
		geom_to_e_call(p,data);
		return (*hflag=1);
	 }
				/* ============ hex_refine ======== */
	if (!strncmp(cmd,"hex_refine",10))
	 {
		if (*hflag=hex_refine(p)) return 1;
		return 0;
	 }
				/* ============ hex_walk ======== */
	if (!strncmp(cmd,"hex_walk",8))
	 {
		if (sscanf(data,"%d %d %d",&v,&w,&n)!=3) 
		 {strcpy(msgbuf,"Usage: hex_walk v w n");emsg();return 0;}
		if (*hflag=hex_parallel_call(p,v,w,n,&a,1)) 
		 {
			sprintf(msgbuf,"hex_walk: pack %d modulus = %lf+i%lf; abs val = %lf",
				p,a.re,a.im,cAbs(a));
			msg();
			return 1;
		 }
		return 0;
	 }
	break;
 }
case 'i':
 {
				/* ========== increment rad ========== */
	if (!strncmp(cmd,"inc_rad",7))
	 {
		factor=inc_factor;
		return (crement_radii(p,factor,data));
	 }
				/* ========== infile_read ========== */
	if (!strncmp(cmd,"infile_read",11))
	 {
		return (read_infile(p,data));
	 }
	break;
 }
case 'M':
 {
				/* ========== Mobius_inv ============= */
	if (!strncmp(cmd,"Mobius_inv",10))
	 {
		return (apply_Mobius(p,data,-1));
	 }
				/* ========== Mobius ============= */
	if (!strncmp(cmd,"Mobius",6))
	 {
		return (apply_Mobius(p,data,1));
	 }
	break;
 }
case 'N':
 {
				/* ========== NSpole ============= */
	if (!strncmp(cmd,"NSpole",6))
	 {
		return (NSpole(p,data));
	 }
	break;
 }
case 'n':
 {
 				/* ========== norm_scale =========== */
 	if (!strncmp(cmd,"norm_scale",10))
 	 {
 	 	return (*hflag=norm_scale(p,data));
 	 }
 	break;
 }
case 'p':
 {
 				/* =========== pfacered ============ */
	if (!strncmp(cmd,"pfacered",8))
	 {
		return (pfacered(p));
	 }	
				/* =========== puncture ============ */
	if (!strncmp(cmd,"puncture",8))
	 {
		return (puncture(p,data));
	 }
	break;	
 }
case 'r':
 {
				/* ====== read = Caution, no confirm === */
	if (!strncmp(cmd,"read",4) && strncmp(cmd,"read_p",6))
	 {
		if (sscanf(data,"%s",filename)!=1) return 0; /* blank */
		set_packing_path();
		strcpy(buff,path);
		strcat(buff,filename);
		strcpy(filename,buff); /* now have full pathname */
		return (*hflag=readcall(p,filename));
	 }
				/* ========= reorient ======= */
	if (!strncmp(cmd,"reorient",8))
	 {
		return (*hflag=reverse_orient(p));
	 }		
				/* ========== repack ======== */
	if (!strncmp(cmd,"repack",6))
	 {
		stripsp(data);
		if (p->overlap_status) n=1; /* use old routines */
		else n=0;
		if (data[0]=='-')
		 {
		   if (data[1]=='v') /* just certain verts */
		    {
		      dpoint=data+2;
		      if ( (vertlist=node_link_parse(p,
			dpoint,&endptr,&hits))!=NULL)
		       {
			  trace=vertlist;
			  do {
				if (p->packR_ptr[trace->v].aim>=0)
				 {
				     if (p->hes<okerr)
					h_riffle_vert(p,trace->v);
				     else if (p->hes==0)
					e_riffle_vert(p,trace->v);
				     else if (p->hes>=okerr)
					s_riffle_vert(p,trace->v);
				     count++;
				 }
				trace=trace->next;
			    } while (trace!=NULL);
			   vert_free(&vertlist);
		       }
		      else
		       {
			  if (p->hes<okerr) 
			   h_riffle_vert(p,p->active_node);
			  else if (p->hes==0)
			   e_riffle_vert(p,p->active_node);
			  else if (p->hes>=okerr)
			   s_riffle_vert(p,p->active_node);
			  count++;
		       }
		      return (*hflag=count);
		    }
		   else if (data[1]=='n') n=0; /* use new routines */
		   else if (data[1]=='o') 
			n=1; /* use old reliable routines */
		   else return 0;
		 }
		if (sscanf(data,"%d",&pass)!=1 || pass < 1 || pass > 10010)
			pass = totalpasses;
		rifflecall(p,pass,1,n);
		return (*hflag=1);
	 }
				/* ============== remove bdry circle ======== */
	if (!strncmp(cmd,"rm_cir",6))
	 {
		return (*hflag=remove_circle(p,data));
	 }		
				/* ============ remove edge ============ */
	if (!strncmp(cmd,"rm_edge",7))
	 {
		if (sscanf(data,"%d %d",&v,&w)!=2) return 0;
		return (*hflag=remove_edge(p,v,w));
	 }
				/* ============ remove quad vert ======== */
	if (!strncmp(cmd,"rm_quad",7))
	 {
		return (*hflag=remove_quad_vert(p,data));
	 }
	break;
 }
case 's':
 {
				/* ========== eucl scaling ====*/
	if (!strncmp(cmd,"scale",5))
	 {
		if (!p->status) return 0;
		if (!strlen(data) || !sscanf(data,"%lf",&factor) || factor==0)
			factor=eucl_factor;
		eucl_scale(p,factor);
		return (*hflag=1);
	 }
				/* ========== seed ======== */
	if (!strncmp(cmd,"seed",4))
	 {
		if (seed_start(p,data))
		 {
			sprintf(buf,"seed -p%d %s\n",p,data); 
			hmsg(buf);
			return 1;
		 }
		else return 0;
	 }
				/* ========== set_aim ======= */
	if (!strncmp(cmd,"set_aim",7))
	 {
		return (*hflag=set_aims(p,data));
	 }
				/* ============= set_overlaps ==========*/
	if (!strncmp(cmd,"set_over",8))
	 {
		return (*hflag=set_overlapscall(p,data));
	 }
				/* ========== set_radii ===== */
	if (!strncmp(cmd,"set_rad",7))
	 {
		n=strcspn(data," ");
		strncpy(buf,data,n);
		*(buf+n)='\0';
		if (n==0 ||strpbrk(buf,".")==NULL 
		   || sscanf(buf,"%lf",&radius)!=1 ) 
		 {
		   strcpy(msgbuf,"Indicate floating point radius first (with decimal pt).");
		   emsg();
		   return 0;
		 }
		if (p->hes>=0 && radius<=0)
		 {
		   strcpy(msgbuf,"Radius positive for eucl and spherical packs.");
		   emsg();
		   return 0;
		 }
		return (*hflag=set_radii(p,radius,data+n+1));
	 }
				/* ===== set_random radii/overlaps = */
	if (!strncmp(cmd,"set_rand",8))
	 {
		return (*hflag=randize(p,data));
	 }
				/* ========== set_center ===== */
	if (!strncmp(cmd,"set_center",7))
	 {
		if (sscanf(data,"%lf %lf %d",&x,&y,&v)!=3 
			|| v<1 || v>p->nodecount)
		 {
		   strcpy(msgbuf,"Usage: x, y, v.");
		   emsg();
		   return 0;
		 }
		if (p->hes< 0 && (x*x+y*y)>=1.0)
		 {
		   strcpy(msgbuf,"Center must be in disc for hyperbolic packs.");
		   emsg();
		   return 0;
		 }
		p->packR_ptr[v].center.re=x;
		p->packR_ptr[v].center.im=y;
		return (*hflag=1);
	 }
				/* ========== slit ================= */
	if (!strncmp(cmd,"slit",4))
	 {
		return (*hflag=slit_complex(p,data));
	 }
				/* ========== special command ======== */
	if (!strncmp(cmd,"special",7))
	 {
		if (!sscanf(cmd+7,"%d",&spec_num)) 
		 {
			strcpy(msgbuf,"Can't read special number.");
			emsg();
			return 0;
		 }
		stripsp(data);
		if (*data=='\0') return 0; 
		if (spec_num==1) 
		 {
			sprintf(buff,"%d ",p);
			strcat(buff,data);
			return (*hflag=special1(buff));
		 }
		if (spec_num==2) 
		 {
			sprintf(buff,"%d ",p);
			strcat(buff,data);
			return (*hflag=special2(buff));
		 }
		if (spec_num==3) return (*hflag=special3(data));
		if (spec_num==4) return (*hflag=special4(data));
		if (spec_num==5) return (*hflag=special5(data));
		if (spec_num==6) return (*hflag=special6(data));
		if (spec_num==7) return (*hflag=special7(data));
		if (spec_num==8) return (*hflag=special8(data));
		else return 0;
	 }
				/* ========== spiral ======== */
	if (!strncmp(cmd,"spiral",6))
	 {
		return (*hflag=spiral(pnum,data) );
	 }
				/* ==========  swap nodes ========== */
	if (!strncmp(cmd,"swap",4))
	 {
		return (*hflag=swap_nodes(p,data));
	 }
	break;
 }
	 } /* end of unlocked switch */
 } /* end of if: unlocked only */

/* LOCKED and UNLOCKED packings both go through here */

	switch (cmd[0])
	 {
case '[':
 {
				/* == exe named cmd in script file == */
	strncpy(named_cmd,cmd+1,30);
	named_cmd[31]='\0';
	n=strcspn(named_cmd,"]\0");
	if (n==0 || named_cmd[n]!=']') return 0;
	named_cmd[n]='\0';
	if (exe_named_cmd(named_cmd)) return 1;
	return 0;
 }
case 'a':
 {
				/* ========== active pack =========== */
	if (!strncmp(cmd,"act",3))
	 {
		if (strlen(data) && sscanf(data,"%d",&n) 
			&& n>=0 && n<NUM_PACKS)
		 {chg_active_pack(n); return 1;}
		return 0;
	 }
				/* ============ adjoin ============ */
	if (!strncmp(cmd,"adjoin",6))
	 {
		if (*hflag=adjoincall(data)) return 1;
		return 0;
	 }
	break;
 }
case 'c':
 {
				/* ============ center pt ============ */
	if (!strncmp(cmd,"center_point",12))
	 {
		if (sscanf(data,"%lf %lf",&(ctr.re),&(ctr.im))!=2) return 0;
		return (center_point(p,ctr));
	 }
				/* ============ center vert ============ */
	if (!strncmp(cmd,"center_vert",11))
	 {
		if (sscanf(data,"%d",&v)!=1 || v<1 || v>p->nodecount)
			v=p->active_node;
		return (center_point(p,
			p->packR_ptr[v].center));
	 }
				/* ============ change directory ====== */
	if (!strcmp(cmd,"cd")) 
	 {
		if (!sscanf(data,"%s",next)) return 0;
		buf[0]='\0';
		if (next[0]=='~') 
		 {
			sprintf(buf,"%s/",home_dir);
			next[0]=' ';
			stripsp(next);
		 }
		strcat(buf,next);
		chdir(buf);
		getcwd(buf,BUFSIZE);
		working_dir=(char *)malloc((strlen(buf)+2)*sizeof(char));
		strcpy(working_dir,buf);
		sprintf(buf,"CirclePack (dir; %s)",working_dir);
		xv_set(base_frame,XV_LABEL,buf,0);

	 }
				/* ============ close various windows ====== */
	if (!strncmp(cmd,"close",5))
	 {
		nextpoint=data;
		stripsp(data);
		if (!grab_next(&nextpoint,next)) {next[0]='s';next[1]='\0';}
		if (next[0]=='c') xv_set(cmd_frame,WIN_SHOW,FALSE,0);
		else if (next[0]=='h') xv_set(history_frame,WIN_SHOW,FALSE,0);
		else if (next[0]=='m') xv_set(msg_frame,WIN_SHOW,FALSE,0);
		else if (next[0]=='p') xv_set(setup_frame,WIN_SHOW,FALSE,0);
		else if (next[0]=='w') xv_set(text_frame,WIN_SHOW,FALSE,0); 
		else if (next[0]=='?') xv_set(help_frame,WIN_SHOW,FALSE,0);
		else if (next[0]=='d') xv_set(script_frame,WIN_SHOW,FALSE,0);
		else if (next[0]=='p') xv_set(setup_frame,WIN_SHOW,FALSE,0);
		else if (next[0]=='s' && next[1]=='m') 
		 {manip_frame_done_proc(manip_frame[pnum]);}
		else if (next[0]=='s' && next[1]=='p') 
			xv_set(screen_frame[pnum],WIN_SHOW,FALSE,0);
		else if (next[0]=='s') canvas_life(pnum,0);
		else return 0;
		return 1;
	 }
				/* === set colors: circles/tris  ==== */
	if (!strncmp(cmd,"color",9))
	 {
		nextpoint=data;
		stripsp(data);
		if (!grab_next(&nextpoint,next) || next[0]!='-') return 0;
		if (next[1]=='c') /* color circles */
		 {
			data[0]=' ';data[1]=' ';
			stripsp(data);
			if (!strncmp(data,"bg",2)) 
				return (color_circles(p,4,"\0"));
			if (!strncmp(data,"fg",2)) 
				return (color_circles(p,5,"\0"));
			if (!strncmp(data,"rad",3))
				return (color_circles(p,1,"\0"));
			if (!strncmp(data,"-q",2)) /* compare to q */
			 {
				*data=' ';*(data+1)=' ';
				return (color_circles(p,3,data));
			 }
			if (!strncmp(data,"-p",2)) /* copy from pack p */
			 {
				*data=' ';*(data+1)=' ';
				return (color_circles(p,7,data));
			 }
			if (!strncmp(data,"-k",2)) /* by curvature */
			 {
				*data=' ';*(data+1)=' ';
				return (color_circles(p,8,data));
			 }
			else return (color_circles(p,6,data));
		 }
		if (next[1]=='f') /* color faces */
		 {
			data[0]=' ';data[1]=' ';
			stripsp(data);
			if (!strncmp(data,"bg",2)) 
				return (color_faces(p,4,"\0"));
			if (!strncmp(data,"fg",2)) 
				return (color_faces(p,5,"\0"));
			if (!strncmp(data,"area",3))
				return (color_faces(p,1,"\0"));
			if (!strncmp(data,"-q",2)) /* compare to q */
			 {
				*data=' ';*(data+1)=' ';
				return (color_faces(p,3,data));
			 }
			if (!strncmp(data,"-p",2)) /* copy from pack p */
			 {
				*data=' ';*(data+1)=' ';
				return (color_faces(p,7,data));
			 }
			else return (color_faces(p,6,data));
		 }
		else return 0;
	 }
				/* ========== copy ======== */
	if (!strncmp(cmd,"copy",4)) 
	 {
		if (!sscanf(data,"%d",&p1)) return 0;
		sprintf(buff,"%d %d",pnum,p1);
		copy_packcall(buff);
		return (*hflag=1);
	 }
	break;
 }
case 'd':
 {
				/* ========== drawing operations ========*/
	if (!strncmp(cmd,"disp",4))
	 {
		return (display_call(p,data));
	 }
				/* ========== delay ============== */
	if (!strncmp(cmd,"delay",5))
	 {
		if (sscanf(data,"%d",&n) && n>0) timedelay((float)n);
		return 1;
	 }
				/* ========== decrement radius =========== */	
	if (!strncmp(cmd,"dec_rad",7))
	 {
		factor=(1.0)/inc_factor;
		return (crement_radii(p,factor,data));
	 }
	break;
 }
case 'e':
 {
 				/* ============ exec  =============== */
 	if (!strncmp(cmd,"exec",4))
 	 {
 		return (*hflag=init_remote(data));
 	 }
				/* ============ eucl_write ============ */
	if (!strncmp(cmd,"eucl_write",10))
	 {
		if (sscanf(data,"%s",filename)!=1) return 0; /* blank */
		set_packing_path();
		strcpy(buff,path);
		strcat(buff,filename);
		strcpy(filename,buff); /* now have full pathname */
		return (*hflag=writeeucldata(p,filename));
	 }	
	break;
 }
case 'f':
 {
				/* set 'next_face' indices */
	if (!strncmp(cmd,"f_next",6))
	 {
		return (set_face_next(p,data));
	 }
				/* set 'index_flag' of faces */
	if (!strncmp(cmd,"f_index",7))
	 {
		return (set_face_index(p,data));
	 }
	if (!strncmp(cmd,"f_red",5))
	 {
		return (set_face_red(p,data));
	 }
	if (!strncmp(cmd,"f_rnext",7))
	 {
		return (set_face_rnext(p,data));
	 }
	break;
 }
case 'g':
 {
				/* ============ set gamma ============== */
	if (!strncmp(cmd,"gamma",5) )
	 {
		if (sscanf(data,"%d",&vert)==1) 
			return (set_gamma(p,vert));
		else return 0;
	 }
	break;
 }
case 'i':
 {
				/* ========== infile_path ========== */
	if (!strncmp(cmd,"infile_path",11))
	 {
		return (path_infile(data));
	 }
				/* ========== infile_cmds ======== */
	if (!strncmp(cmd,"infile_cmds",11))
	 {
		return (cmds_infile(data));
	 }
	 	break;
 }
case 'm':
 {
				/* ====== mark circles/faces ======== */ 
	if (!strncmp(cmd,"mark",4))
	 {
		marking(p,data);
		return 1;
	 }
				/* ====== msg_remote: to process === */ 
	if (!strncmp(cmd,"msg_r",5) || !strncmp(cmd,"m_r",3) 
		|| !strncmp(cmd,"mr",2))
	 {
		nextpoint=data;
		stripsp(data);
		if (sscanf(data," %s %[^\n]1000",next,msgbuf)<2) 
			return 0; /* empty message */
		if (v=atoi(next)) /* numerical name of routine */
		 {
			if (v>=NUM_PROC) /* take v as actual pid */
			 {
				w=-1;
				for (i=0;i<NUM_PROC;i++)
				   if (remote[i].pid==v) {w=i;break;}
				if (w<0) return 0;
			 }
			else if (v>=0 && v<NUM_PROC && remote[v].pid) w=v;
		 }
		else /* string name of routine */
		 {
			w=-1;
			for (i=0;i<NUM_PROC;i++)
			   if (strcmp(remote[i].moniker,next)==0) 
				{w=i;break;}
			if (w<0) return 0;
		 }
		msg_remote(w);
		return 1;		
	 }

				/* ========== display a msg ====== */ 
	if (!strncmp(cmd,"msg",3))
	 {
		strncpy(msgbuf,data,300);
		msg();
	 	return 1;
	 }
	break;
 }
case 'n':
 {
				/* ========== set active node ======== */
	if (!strncmp(cmd,"node_active",11) )
	 {
		if (sscanf(data,"%d",&vert)==1 && vert>0 
		   && vert<=p->nodecount)
		 {
			p->active_node=vert;
			return 1;
		 }
		else return 0;
	 }
	break;
 }
case 'o':
 {
				/* ======= open various windows ===== */
	if (!strncmp(cmd,"open",4))
	 {
		nextpoint=data;
		stripsp(data);
		if (!grab_next(&nextpoint,next)) {next[0]='s';next[1]='\0';}
		if (next[0]=='c') xv_set(cmd_frame,WIN_SHOW,TRUE,0);
		else if (next[0]=='h') xv_set(history_frame,WIN_SHOW,TRUE,0);
		else if (next[0]=='m') xv_set(msg_frame,WIN_SHOW,TRUE,0);
		else if (next[0]=='p') xv_set(setup_frame,WIN_SHOW,TRUE,0);
		else if (next[0]=='w') xv_set(text_frame,WIN_SHOW,TRUE,0); 
		else if (next[0]=='?') xv_set(help_frame,WIN_SHOW,TRUE,0);
		else if (next[0]=='d') xv_set(script_frame,WIN_SHOW,TRUE,0);
		else if (next[0]=='s' && next[1]=='m')
		 {
			if ((int)xv_get(canvas_frame[pnum],WIN_SHOW)) 
			 {
			   frame_get_rect(canvas_frame[pnum],&rect);
			   xv_set(manip_frame[pnum],
				WIN_X,(int)(rect.r_left+rect.r_width+5),
				WIN_Y,(int)rect.r_top,WIN_SHOW,TRUE,0);
			 }
		 }
		else if (next[0]=='s' && next[1]=='p') 
		 {
			if ((int)xv_get(canvas_frame[pnum],WIN_SHOW)) 
				xv_set(screen_frame[pnum],WIN_SHOW,TRUE,0);
		 }
		else if (next[0]=='s') canvas_life(pnum,1);
		else return 0;
		return 1;
	 }
	break;
 }
case 'p':
 {
				/* =========== print (postscript) ======= */
	if (!strncmp(cmd,"print",11)) 
	 {
		if (!canvas[pnum] || !p->status)
		 {
			strcpy(msgbuf,"Note, pack is empty.");
			msg();
			return 0;
		 }
		return (*hflag=post_canvas(p));
	  }
				/* ============ custom printing ========*/
	if (!strncmp(cmd,"post",4))
	 {
		n=print_call(custom_fp,p,data);
		return (*hflag=n);
	 } 
				/* ============ print working directory =*/
	if (!strcmp(cmd,"pwd"))
	 {
		getcwd(buf,BUFSIZE);
		sprintf(msgbuf,"\nCurrent directory: %s.",buf);
		msg();
		return 0;	 	
	 } 
	break;		
 }
case 'q':
 {
				/* ============= quit ============ */
	if (!strncmp(cmd,"quit",4) || !strncmp(cmd,"exit",4) )
	 { quit();return 0;}
	break;
 }
case 'r':
 {
				/* ============ read_path ============ */
	if (!strncmp(cmd,"read_path",9))
	 {
		if (sscanf(data,"%s",filename)!=1) return 0; /* blank */
		return (read_path_file(filename));
	 }
				/* ============ rotate ============ */
	if (!strncmp(cmd,"rotate",6))
	 {
		if (sscanf(data,"%lf",&ang)!=1) return 0;
		return (rotate(p,ang*M_PI));
	 }
 	break;
}
case 's':
 {
				/* ==== open/load script subwindow  ==== */
	if (!strncmp(cmd,"script",6))
	 {
		xv_set(script_frame,WIN_SHOW,TRUE,0);
		if (sscanf(data,"%s",filename)==1)
		 {
		   if ((int)xv_get(script_sw,TEXTSW_MODIFIED))
		    {
			sprintf(buf,
			   "Script contents have been modified: overwrite??");
			if (!confirm_action(buf)) return 0;
		    }
		   xv_set(script_sw,
			TEXTSW_FILE,filename,
			TEXTSW_FIRST,0,
			TEXTSW_INSERTION_POINT,0,
			0);
		 }
		return 1;
	 }
				/* ============ set ============== */

	if (!strncmp(cmd,"set_",3))
	 {
		cmd[0]=cmd[1]=cmd[2]=cmd[3]=' ';
		stripsp(cmd);
		if (!strncmp(cmd,"accur",5) &&
			sscanf(data,"%lf",&dum)==1 && dum>0 && dum<.10)
		 {
			toler=dum;
			if (okerr>(.01)*toler) okerr = (.01)*toler;
			return 1;
		 }

		if (!strncmp(cmd,"cycle",5) &&
			sscanf(data,"%d",&i)==1 && i>0 && i<10001)
		 {
			totalpasses=i;
			return 1;
		 }
		if (!strncmp(cmd,"draw",4))
		 {
		 	if (data[0]=='f') draw_speed=0; /* fast */
		 	else if (data[0]=='s') draw_speed=1; /* slow */
		 	else draw_speed= (draw_speed) ? 0 : 1;
		 }
		if (!strncmp(cmd,"toler",5) &&
			sscanf(data,"%lf",&dum)==1 && dum>0 && dum<.10)
		 {
			toler=dum;
			return 1;
		 }
		if (!strncmp(cmd,"err",3) &&
			sscanf(data,"%lf",&dum)==1 && dum>0 && dum<.10)
		 {
			if (dum<=(.01)*toler) {okerr=dum;return 1;}
			return 0;
		 }
		if (!strncmp(cmd,"iter",4) &&
			sscanf(data,"%d",&i)==1 && i>0 && i<15)
		 {
			iterates=i;
			return 1;
		 }
		if (!strncmp(cmd,"post",4) &&
			sscanf(data,"%d",&i)==1 && i>0 && i<8)
		 {
			sc_print_size=i;
			return 1;
		 }
		if (!strncmp(cmd,"brush",10)
			&& sscanf(data,"%d",&i)==1 && i>0 && i<15)
		 {
			line_thick=i;
			XSetLineAttributes(display,gc,line_thick,
				LineSolid,CapRound,JoinRound);
			return 1;
		 }

		if (!strncmp(cmd,"eucl_scale",10))
		 {
			if (sscanf(data,"%lf",&dum)==1 && dum>=.5 && dum<=1.5)
			 {
				eucl_factor=dum;
				xv_set(Eucl_factor,PANEL_VALUE,
					(int)(dum*100.0),0);
				return 1;
			 }
		 }
		if (!strncmp(cmd,"inc_factor",10))
		 {
			if (sscanf(data,"%lf",&dum)==1 && dum>=1.0 && dum<=2.0)
			 {
				inc_factor=dum;
				xv_set(radius_inc,PANEL_VALUE,
					(int)((dum-1.0)*100.0),0);
				return 1;
			 }
		 }
		if (!strncmp(cmd,"Mobius",6))
		 {
			newMob=(Mobius *)malloc(sizeof(Mobius));
			if ((n=sscanf(data,"%lf %lf %lf %lf %lf %lf %lf %lf %d",
				&(newMob->a.re),&(newMob->a.im),
				&(newMob->b.re),&(newMob->b.im),
				&(newMob->c.re),&(newMob->c.im),
				&(newMob->d.re),&(newMob->d.im), 
				&(newMob->flip)))>=8 )
			 {
			if (cAbs(csub(cmult(newMob->a,newMob->d),
				cmult(newMob->b,newMob->c)))>okerr )
			 {
				if (n==8) newMob->flip=0; /* default */	
				Mob=*newMob;
				free(newMob);
				return 1;
			 }
			 }
			else
			 {
				sprintf(msgbuf,"Mobius usage: 8 reals (and a 1 to reverse orientation).");
				emsg();
				free(newMob);
				return 0;
			 }
		 }
		if (!strncmp(cmd,"fill_pattern",12))
		 {
			if (!strncmp(data,"solid",5)) 
			 {XSetFillStyle(display,gc_fill,FillSolid);return 1;}
			else 
			 {XSetFillStyle(display,gc_fill,FillStippled);return 1;}
		 }
		if (!strncmp(cmd,"sphere_view",11) || !strncmp(cmd,"sv",2))
		 {
			return sphere_view(p->screen,data);
		 }
		if (!strncmp(cmd,"sph_pts",7) && sscanf(data,"%d",&i)==1 
			&& i>10 && i<500)
		 {
			num_plot=i;
			return 1;
		 }
		if (!strncmp(cmd,"screen",6))
		 {
			nextpoint=data;
			if (!grab_next(&nextpoint,next) || next[0]!='-')
				return 0;
			do
			 {
			   if (next[0]!='-') return count;
			   if (next[1]=='c' || next[1]=='v') 
				/* center screen on x y coord or vert v */
			    {
				i=0;
				if (next[1]=='v' 
				   && grab_next(&nextpoint,next)
				   && sscanf(next,"%d",&v)==1
				   && p->status 
				   && v>0 && v<= p->nodecount)
				 {
				   x=p->packR_ptr[v].center.re;
				   y=p->packR_ptr[v].center.im;
				   i=1;
				 }
				else if (next[1]=='c' 
				  && grab_next(&nextpoint,next)
				  && sscanf(next,"%lf",&x)==1 
				  && grab_next(&nextpoint,next)
				  && sscanf(next,"%lf",&y)==1 )
				 {i=1;}
				if (i)
				 {
				   if (p->hes>okerr)
				    {
				     sprintf(buff,"0.0 0.0 %lf",-x/M_PI);
				     sphere_view(p->screen,buff);
				     sprintf(buff,"-i 0.0 %lf 0.0",y/M_PI-.5);
				     sphere_view(p->screen,buff);
				    }
				   else
				    { 
				      h=(p->screen->box.ry-
					p->screen->box.ly)/2.0;
				      p->screen->box.ry=y+h;
				      p->screen->box.ly=y-h;
				      hh=(p->screen->box.rx-
					p->screen->box.lx)/2.0;
				      p->screen->box.rx=x+hh;
				      p->screen->box.lx=x-hh;
				    }
				   count++;
				 }
			    }
			   else if (next[1]=='h') /* set height (and width) */
			    {
				if (grab_next(&nextpoint,next)
				  && sscanf(next,"%lf",&h)==1 
				  && h>0.0)
				 {
				   hh = h/2.0;
				   y=(p->screen->box.ry+
					p->screen->box.ly)/2.0;
				   p->screen->box.ry=y+hh;
				   p->screen->box.ly=y-hh;
				   x=(p->screen->box.rx+
					p->screen->box.lx)/2.0;
				   hh=h*(p->screen->pix_box.rx)/
					p->screen->pix_box.ry/2.0;
				   p->screen->box.rx=x+hh;
				   p->screen->box.lx=x-hh;
				   count++;
				 }
			    }
			   else if (next[1]=='f') /* mult height by factor*/
			    {
				if (grab_next(&nextpoint,next)
				   && sscanf(next,"%lf",&factor)==1
				   && factor > 0.01)
				 {
				   h=p->screen->box.ry-p->screen->box.ly;
				   hh = h*factor/2.0;
				   y=(p->screen->box.ry+
					p->screen->box.ly)/2.0;
				   p->screen->box.ry=y+hh;
				   p->screen->box.ly=y-hh;
				   x=(p->screen->box.rx+
					p->screen->box.lx)/2.0;
				   hh=hh*(p->screen->pix_box.rx)/
					p->screen->pix_box.ry;
				   p->screen->box.lx=x-hh;
				   p->screen->box.rx=x+hh;
				   count++;
				 }
			    }
			 } /* end of do */
			while (nextpoint!=NULL && grab_next(&nextpoint,next) );
			return count;
		 }				
	 } /* end of "set_" commands */
	 			/* ========== show red chain ======== */
	if (!strncmp(cmd,"show_red",8))
	 {
	 	return (*hflag=pfacered(p));
	 }
	break;
 }
case 'w':
 {
				/* ====== write_path ======= */
	if (!strncmp(cmd,"write_path",10))
	 {
		nextpoint=data;
		if (!grab_next(&nextpoint,next) 
		   || sscanf(next,"%s",filename)!=1) 
			return 0;
		return (*hflag=write_path_file(filename));
	 }
				/* ==== write ===== Caution, no confirm === */
	else if (!strncmp(cmd,"write",5))
	 {
		nextpoint=data;
		if (!grab_next(&nextpoint,next)) return 0;
		j=2; /* standard (default) */
		if (next[0]=='-')
		 {
			if (next[1]=='c') j=0;
			else if (next[1]=='m') j=1;
			else if (next[1]=='d') j=2;
			else if (next[1]=='M') j=3;
			else if (next[1]=='s') j=4;
			else return 0;
		 }
		else nextpoint=data;
		if (sscanf(nextpoint,"%s",filename)!=1) return 0; /* blank */
		if (j==4) /* write to script file */
		 {
			pos=(Textsw_index)xv_get(script_sw,
				TEXTSW_INSERTION_POINT);
			if ((*hflag=writecall(p,"/tmp/script-hold.p",2)))
			 {
			   xv_set(script_sw,TEXTSW_INSERTION_POINT,
				TEXTSW_INFINITY,NULL);
			   sprintf(buf,"\n\n%s \n",filename);
			   textsw_insert(script_sw,buf,strlen(buf));
			   xv_set(script_sw,TEXTSW_STATUS,&sw_status,
				TEXTSW_INSERT_FROM_FILE,
				"/tmp/script-hold.p",NULL);
			   if (sw_status!=TEXTSW_STATUS_OKAY) *hflag=0;
			   xv_set(script_sw,TEXTSW_INSERTION_POINT,pos,NULL);

			 }
			if (*hflag==0)
			 {
	sprintf(buf,"Intermediate write to or from /tmp/script-hold.p failed.");
				emsg();
				return 0;
			 }
		 	else return (*hflag);
		 }			
		set_packing_path();
		strcpy(buff,path);
		strcat(buff,filename);
		strcpy(filename,buff); /* now have full pathname */
		return (*hflag=writecall(p,filename,j));
	 }
	break;
 }
case '!':
 {
				/* ======= repeat last ====== */
	if (!strncmp(cmd,"!!",2) && !cmd_search_depth) 
		/* note: not permitted when executing named script cmd */ 
	 {
		sort_cmd(cmd_history);
		return 1;
	 }
	break;
 }
case '?':
 {
				/* ============ inquiries =========== */
	if (!strncmp(cmd,"?vert",5)) 
		   return (print_inq_data(p,1,data));
	if (!strncmp(cmd,"?pack",5))
 		   return (print_inq_data(p,2,data));
	if (!strncmp(cmd,"?flower",7))
		   return (print_inq_data(p,4,data));
	if (!strncmp(cmd,"?rad",4))
		   return (print_inq_data(p,5,data));
	if (!strncmp(cmd,"?ang_sum",8))
		   return (print_inq_data(p,6,data));
	if (!strncmp(cmd,"?aim",4))
		   return (print_inq_data(p,7,data));
	if (!strncmp(cmd,"?face",5))
		   return (print_inq_data(p,8,data));

	if (!strncmp(cmd,"?over",5))
		   return (print_inq_data(p,9,data));
	if (!strncmp(cmd,"?cent",5))
		   return (print_inq_data(p,10,data));
	if (!strncmp(cmd,"?alt_rad",8))
		   return (print_inq_data(p,11,data));
	if (!strncmp(cmd,"?kap",4))
		   return (print_inq_data(p,12,data));
	if (!strncmp(cmd,"?screen",7))
		   return (print_inq_data(p,13,data));
	if (!strncmp(cmd,"?param",6))
		   return (print_inq_data(p,14,data));
	if (!strncmp(cmd,"?curv_err",9))
		   return (print_inq_data(p,16,data));
	if (!strncmp(cmd,"?bdry_dist",10))
		   return (print_inq_data(p,17,data));
	if (!strncmp(cmd,"?ratio_ftn",10))
		   return (print_inq_data(p,18,data));
	if (!strncmp(cmd,"?conduct",8))
		   return (print_inq_data(p,20,data));
	if (!strncmp(cmd,"?remote",7))
		   return (print_inq_data(p,21,data));
	break;
 }
	 } /* end of switch */

	return 0;
} /* parse_cmd */

/*========================= 'call' routines here ======================*/
/* generally, these are the ones which yield 'hmsg' . */

geom_to_e_call(p,datastr) /* call to convert pack */
struct p_data *p;
char *datastr;
{
	int flag=0,i,pnum=pack_num(p);
	float *hold;

	if (datastr[0]=='-' && datastr[1]=='l') flag=1;
	if (flag)
	 {
		hold=(float *)malloc((p->nodecount+1)*sizeof(float));
		for (i=1;i<=p->nodecount;i++) 
		   hold[i]=p->packR_ptr[i].rad;
		if (p->hes<0) for (i=1;i<=p->nodecount;i++)
		 {
			if (hold[i]<=0) hold[i]=5.0;
			else hold[i]=(-log(hold[i]));
		 }
	 }
	geom_to_e_pack_convert(p);
	p->hes=-1;
	if (flag) 
	 {
		for (i=1;i<=p->nodecount;i++) 
			p->packR_ptr[i].rad=hold[i];
		free(hold);
	 }
	p->hes=0;
	fillcurves(p);
	set_aim_default(p);
	p->screen->unitcircle=0;
	panel_set(tog[pnum],PANEL_TOGGLE_VALUE,0,FALSE,0);
	sprintf(msgbuf,"Pack %d converted to euclidean data.   ",pnum);msg();
	strcpy(buf,p->file_name);
	strcat(buf," (eucl)\0");
	pmsg(pnum,buf);canvmsg(pnum);
} /* geom_to_e_call */

geom_to_h_call(p,datastr) /* call to convert pack */
struct p_data *p;
char *datastr;
{
	int flag=0,i,pnum=pack_num(p);
	float *hold;

	if (datastr[0]=='-' && datastr[1]=='l') flag=1;
	if (flag)
	 {
		hold=(float *)malloc((p->nodecount+1)*sizeof(float));
		for (i=1;i<=p->nodecount;i++) 
		   hold[i]=p->packR_ptr[i].rad;
	 }
	geom_to_h_pack_convert(p);
	p->hes=-1;
	if (flag) 
	 {
		for (i=1;i<=p->nodecount;i++) 
			p->packR_ptr[i].rad=hold[i];
		free(hold);
	 }
	fillcurves(p);
	set_aim_default(p);
	p->screen->unitcircle=1;
	panel_set(tog[pnum],PANEL_TOGGLE_VALUE,0,TRUE,0);
	sprintf(msgbuf,"Pack %d converted to hyp data.   ",pnum);msg();
	strcpy(buf,p->file_name);
	strcat(buf," (hyp)\0");
	pmsg(pnum,buf);canvmsg(pnum);
} /* geom_to_h_call */

geom_to_s_call(p,datastr) /* call to convert pack */
struct p_data *p;
char *datastr;
{
	int flag=0,i,pnum=pack_num(p);
	float *hold;

	if (datastr[0]=='-' && datastr[1]=='l') flag=1;
	if (flag)
	 {
		hold=(float *)malloc((p->nodecount+1)*sizeof(float));
		for (i=1;i<=p->nodecount;i++) 
		   hold[i]=p->packR_ptr[i].rad;
		if (p->hes<0) for (i=1;i<=p->nodecount;i++)
		 {
			if (hold[i]<=0) hold[i]=5.0;
			else hold[i]=(-log(hold[i]));
		 }
	 }
	geom_to_s_pack_convert(p);
	p->hes=-1;
	if (flag) 
	 {
		for (i=1;i<=p->nodecount;i++) 
			p->packR_ptr[i].rad=hold[i];
		free(hold);
	 }
	p->hes=1;
	fillcurves(p);
	set_aim_default(p);
	p->screen->unitcircle=0;
	panel_set(tog[pnum],PANEL_TOGGLE_VALUE,0,TRUE,0);
	sprintf(msgbuf,"Pack %d converted to spherical data.   ",pnum);msg();
	strcpy(buf,p->file_name);
	strcat(buf," (sph)\0");
	pmsg(pnum,buf);canvmsg(pnum);
} /* geom_to_s_call */

int
rifflecall(p,passes,lpr,flag) /* call to compute radii of packing p.
flag indicates use of old reliable routine versus faster ones. */
int passes,lpr;
struct p_data *p;
{
	int count;

	xv_set(canvas_frame[pack_num(p)],FRAME_BUSY,TRUE,0);
	if (flag)
	 {
		passes *= p->intnode;
		if (p->hes<(-okerr)) count=old_h_riffle(p,passes);
		else if (p->hes<okerr) count=old_e_riffle(p,passes);
		else count=0; /* spherical algorithm not yet working */
	 }
	else
	 {
		if (p->hes<(-okerr)) count=h_riffle(p,passes);
		else if (p->hes<okerr) count=e_riffle(p,passes);
		else count=0; /* spherical algorithm not yet working */
	 }
	xv_set(canvas_frame[pack_num(p)],FRAME_BUSY,FALSE,0);
	if (count && lpr)
	 {
		sprintf(msgbuf," RIFFLED p%d; passes=%d. ",pack_num(p),count);
		msg();
	 }
	return count;
} /* rifflecall */

int	
set_overlapscall(p,datastr) /* set overlaps or inversive distances */
struct p_data *p;
char *datastr;
{
	int j,v,count=0,hits=1,nb;
	float ang,inv_d;
	char *endptr;
	extern struct Edgelist *node_pair_link();
	extern struct Vertlist *node_link_parse();
	extern void free_overlaps();
	extern float comp_inv_dist();
	struct Edgelist *edgelist,*track;
	struct Vertlist *vertlist,*trace;
	struct K_data *pK_ptr;

	pK_ptr=p->packK_ptr;
	stripsp(datastr);
	if (datastr[0]=='-' && datastr[1]=='d') /* set to default */
	 {
		free_overlaps(p);
		fillcurves(p);
		sprintf(msgbuf,"Overlap angles for pack %d set to 0.",
			pack_num(p));
		msg();
		return 1;
	 }
	if (datastr[0]=='-' && datastr[1]=='c') /* set current */
	 {
		datastr[0]=datastr[1]=' ';stripsp(datastr);
		datastr += notspace(datastr);
		if (datastr[0]=='\0') {datastr--;datastr[0]='a';}
		if ((edgelist=node_pair_link(p,datastr,
			&endptr,&hits))!=NULL)
		 {
			if (!alloc_overlaps(p)) return 0;
			track=edgelist;
			do {
			   nb=nghb(p,track->v,track->w);
			   set_overlap(p,track->v,nb,
				comp_inv_dist(p,track->v,track->w));
				/* note: inv_dist routine not very robust */
			   track=track->next;
			   count++;
			 } while (track!=NULL);
			edge_free(&edgelist);
		 }
		fillcurves(p); /* not yet robust for inversive dist */
		sprintf(msgbuf,"Set %d overlap angles for p=%d to current values.",count,pack_num(p));
		msg();
		return count;
	 }
	inv_d=1.0; /* just in case */
	if ( !grab_next(&datastr,next)
		|| (next[0]=='*' && (!sscanf(next+1,"%lf",&ang)
			|| ang<0.0))
	     || (next[0]!='*' && (!sscanf(next,"%lf",&ang)
/* ??			|| ang>0.5 || ang<0.0)) ) */
/* part of attempt to allow overlaps greater than pi/2 */
			|| ang>1.0 || ang<0.0)) )
	 {
		strcpy(msgbuf,"Specify first: angle in [0,1] or '*' and inv dist [0,infty].");
		emsg();
	 	return 0;
	 }
	if (next[0]!='*') 
	 {
		if (ang>0.5)
		 {
		   strcpy(msgbuf,"WARNING: overlap > 0.5 (Pi) specified; behavior not guaranteed.\n repack with -o option.");
		   emsg();
		 }
		inv_d=cos(ang*M_PI);	/* overlap */
	 }
	else inv_d=ang;				/* separated */
	datastr += notspace(datastr);
	if (datastr[0]=='-' && datastr[1]=='f') /* petals of given flowers */
	 {
	 	datastr[0]=datastr[1]=' ';stripsp(datastr);
	 	if (datastr[0]=='\0' || (vertlist=node_link_parse(p,datastr,
			&endptr,&hits))==NULL) return count;
	 	 {
			if (!alloc_overlaps(p)) return 0;
			trace=vertlist;
			do
			 {
			   v=trace->v;
			   for (j=0;j<pK_ptr[v].num+pK_ptr[v].bdry_flag;j++)
			      set_overlap(p,v,j,inv_d);		
			   trace=trace->next;
			   count++;
			 } while (trace!=NULL);
			vert_free(&vertlist);
		 }
		fillcurves(p);
		return count;
	 }			
	if (datastr[0]=='\0') {datastr--;datastr[0]='a';}
	if ((edgelist=node_pair_link(p,datastr,&endptr,&hits))!=NULL)
	 {
		if (!alloc_overlaps(p)) return 0;
		track=edgelist;
		do {
			nb=nghb(p,track->v,track->w);
			set_overlap(p,track->v,nb,inv_d);
			track=track->next;
			count++;
		 } while (track!=NULL);
		edge_free(&edgelist);
	 }
	fillcurves(p);
	if (inv_d<=1.0 && inv_d>=0.0)
	 { 
		sprintf(msgbuf,"Set %d overlap angle(s) for p=%d to %lf pi.", 	
		   count,pack_num(p),acos(inv_d)/M_PI);
		msg();
	 }
	else if (inv_d>1.0)
	 { 
		sprintf(msgbuf,"Set %d inv_distance(s) for p=%d to %lf.", 	
		   count,pack_num(p),inv_d);
		msg();
	 }
	return count;
} /* set_overlapscall */

timedelay(tm) /* time delay about tm seconds. */
float tm;
{
	struct tms buffer;  /* for getting times */
	long starttime,elapsetime;
	
	times(&buffer);
	if (tm>0)
	 {
		starttime=buffer.tms_utime;
		do
		 {
			times(&buffer);
			elapsetime=buffer.tms_utime-starttime;
		 }
		while (elapsetime< tm*12);
	 }
	return;
} /* timedelay */

	
