// $Id: format.cc,v 1.7 1998/08/06 21:08:43 aml Exp $

#include "format.hh"
extern Tcl_HashTable font_hash;


int Format::last_timestamp=0;

char *format_strings[4] = {
  "general","general","general","general"
};

char *format_formats[4] = {
  "%g","%g","%g","%g"
};

Format::Format()
{ 
  alignment = DEFAULT_ALIGNMENT;
  form = DEFAULT_FORMAT;
  timestamp=++last_timestamp;
}

void Format::UpdateTimestamp()
{
  timestamp=++last_timestamp;
}

Background::Background() {
    filllevel = DEFAULT_FILL;
    red = 255;
    green = 255;
    blue = 255;
    item = NO_ITEM;
}

Background::Background(const Background &rig) {
    filllevel = rig.filllevel;
    red = rig.red;
    green = rig.green;
    blue = rig.blue;
    item = NO_ITEM;
}

void Background::operator=(const Background &rig) {
    filllevel = rig.filllevel;
    red = rig.red;
    green = rig.green;
    blue = rig.blue;
    //    item = NO_ITEM;
}

Border::Border() {
    top = DEFAULT_BORDER;
    bottom = DEFAULT_BORDER;
    left = DEFAULT_BORDER;
    right = DEFAULT_BORDER;
    top_item = NO_ITEM;
    bottom_item = NO_ITEM;
    left_item = NO_ITEM;
    right_item = NO_ITEM;
    top_item_double = FALSE;
    bottom_item_double = FALSE;
    left_item_double = FALSE;
    right_item_double = FALSE;
}

Border::operator=(const Border &rig) 
{
  top = rig.top;
  bottom = rig.bottom;
  left = rig.left;
  right = rig.right;
  //     top_item = NO_ITEM;
  //     bottom_item = NO_ITEM;
  //     left_item = NO_ITEM;
  //     right_item = NO_ITEM;
  //     top_item_double = FALSE;
  //     bottom_item_double = FALSE;
  //     left_item_double = FALSE;
  //     right_item_double = FALSE;
  // Initializing them leads to incorrect copying and pasting of items.
}

Border::Border(const Border &rig) {
    top = rig.top;
    bottom = rig.bottom;
    left = rig.left;
    right = rig.right;
    top_item = NO_ITEM;
    bottom_item = NO_ITEM;
    left_item = NO_ITEM;
    right_item = NO_ITEM;
    top_item_double = FALSE;
    bottom_item_double = FALSE;
    left_item_double = FALSE;
    right_item_double = FALSE;
}


char *getFont(Tcl_Interp *interp,Fontinfo &font){

    int newv;
    Tcl_HashEntry *entry;
    char *st;
    char buf[256];
    int *keyp;


    keyp = (int*) &font;

    entry = Tcl_CreateHashEntry(&font_hash,(char*)(*keyp),&newv);

    if (newv == 1) {
        sprintf(buf,"computeFont %d %d %d %d",font.family,font.size,
                font.italics,font.bold);
        if (Tcl_Eval(interp,buf) != TCL_OK)
            internal_error();
        st = strsave(interp->result);
        Tcl_SetHashValue(entry,st);
    } else {
        st = (char*)Tcl_GetHashValue(entry);
    }

    return(st);
}







/*
$Log: format.cc,v $
Revision 1.7  1998/08/06 21:08:43  aml
Released alpha version of Abacus.

Revision 1.6  1996/09/17 15:16:30  aml
Fixed problems with copying of cells with non-default formats.
Created printing formats, alignment formats.
Format toolbar now reflects format of active cell.

Revision 1.5  1996/09/16 18:42:47  aml
Some performance problems addressed by reducing tag use.
Several performance problems remain when heavy use is made
of borders and shading in large spreadsheets.

// Revision 1.4  1996/09/04  14:30:01  aml
// Fixed double redrawing of sheets that was taking place.
// Fixed a item reference problem when the sheet is redrawn.
// Fixed misplacement of row labels.
// Created first version of format toolbar.
//
Revision 1.3  1996/09/02 10:51:43  aml
Cell fonts created, loaded and saved.
Row height created.

// Revision 1.2  1996/07/18  10:19:34  aml
// Created formats for cells.
// Load cell now makes copy of old file.
//
Revision 1.1  1996/04/27 11:19:52  aml
Initial revision
*/
