# $Id: line.tcl,v 1.2 1998/10/19 23:25:52 cthulhu Exp $

# Line

proc createLineGraph {cnt} {

    source "[xxl_library]/globalvars.tcl"
    global yScale xScale
    
    set cols [expr [lindex $graphRange 2]-[lindex $graphRange 0]+1]
    set rows [expr [lindex $graphRange 3]-[lindex $graphRange 1]+1]

    set ini [expr (($cols==1)? 0:1)]

    set canvas [canvasFromSheet $activeSheet]
    
    $canvas create rect $graphX $graphY \
	[expr $graphX+$graphWidth] [expr $graphY+$graphHeight] X \
	$graphCol $graphRow $graphCol $graphRow -fill white \
	-tag graph_$cnt
    
    
    #
    # Width of each
    #
    
    
    set gh [expr $graphHeight-2*5*$graphMargin]
    set gw [expr $graphWidth-2*5*$graphMargin]
    set gm [expr 5*$graphMargin]
    
    
    #
    # Find max and min  - procura nos valores das celulas seleccionadas
    #
    
    
    set max -1.0e+20
    set min 1.0e+20
    for {set j $ini} {$j < $cols} {incr j} {
        for {set i 0} {$i < $rows} {incr i} {
	    set x [graphData $activeSheet $cnt $j $i 1]
	    if {$x == ""} {set x 0}
            if {$max < $x} {set max $x} 
            if {$min > $x } {set min $x}
        }
    }
    
    if {$x==0} {set x 1} 
    if {$gw==0} {set gw 1}
    if {$gh==0} {set gh 1}
    if {$max==0} {set max 1}
    
    set xScale $gw
    set yScale $gh
    
    if {$max > 0 && $min < 0} {
        set yDim [expr 1.0*$max-$min] 
	if { [expr $max-$min]==0 } {
	    set zero [expr 1.0*(-$min) / 1]
	} else {
	    set zero [expr 1.0*(-$min) / ($max - $min)]
	}
    } else {
        if {$max > 0} {
            set zero 0.0
            set yDim $max
        } else {
            set zero 1.0
            set yDim [expr -$min]
        }
    }
    
    
    #
    # Draw axes
    # 
    
    
    $canvas create rect [expr $gm+$graphX] [expr $gm+$graphY] [expr $gm+$gw+$graphX] \
	[expr $gm+$gh+$graphY] X \
	$graphCol $graphRow $graphCol $graphRow \
	-fill gray80 -outline gray80 -tag graph_$cnt

    
    #desenha as labels do eixo das ordenadas
    
    
    for {set i 0} {$i <= 10} {incr i} {
	set label [expr $i/10.0*$max]
	
	if {$max>999} {
	    set label [format "%1.0g" $label]
	}
	    
	$canvas create text  $graphCol $graphRow X [expr $graphX-$gm/5] \
	    [expr $graphY+$gm+(10-$i)/10.0*$gh-5] \
	    -text $label -tag graph_$cnt
	
	$canvas create line \
	    [expr $graphX+$gm-4] [expr $graphY+$gm+$gh-$label/$max*$gh] \
	    [expr $graphX+$gm] [expr $graphY+$gm+$gh-$label/$max*$gh]  X \
	    $graphCol $graphRow $graphCol $graphRow  -tag graph_$cnt
    
	#desenha rectas horizontais da esquadria
	drawLine $canvas "white" \
	    0.0 [expr 1.0*$i/10] 1.0 [expr 1.0*$i/10] $cnt
	
    }

    #desenha rectas verticais da esquadria

    for {set i 0} {$i < $rows} {incr i} {
	drawLine $canvas "white" \
	    [expr 1.0*$i/($rows-1)] 0.0 \
	    [expr 1.0*$i/($rows-1)] 1.0 \
	    $cnt
    }

    
    #desenha o eixo das abcissas
    
    drawRectangle $canvas black $zero $zero 1.0 $zero $cnt 5

    if {$ini!=0} {
	for {set i 0} {$i < $rows} {incr i} {
	    set label [string range [graphData $activeSheet $cnt 0 $i] 0 4]
	    
	    $canvas create text  $graphCol $graphRow X [expr $graphX+4*$gm/5+$gw*$i/[expr $rows-1]] \
		[expr $graphY+$gm+$gh-2] \
		-text $label -anchor w -tag graph_$cnt
	    
	}
    }
    
    #
    # Draw legends
    #
    
    if {$ini!=0} {
    
	$canvas create rect [expr $graphX+$graphWidth] [expr $gm+$graphY] \
	    [expr $graphX+$graphWidth+90] [expr $gm+30*$cols+$graphY] X \
	    $graphCol $graphRow $graphCol $graphRow -fill white \
	    -tag graph_$cnt
	
	
	$canvas create text $graphCol [expr $graphRow] X \
	    [expr 2*$gm+$gw+$graphX] [expr $gm+$graphY+5] \
	    -text "Legend:" -anchor w  -tag graph_$cnt
	
	
	for {set i $ini} {$i < $cols} {incr i} {
	    $canvas create rect \
		[expr 2*$gm+$gw+3+$graphX] [expr $gm+30*$i+$graphY] \
		[expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+15+$graphY] \
		X  $graphCol $graphRow $graphCol $graphRow -fill [colorIndex $i]\
		-tag graph_$cnt
	    
	    $canvas create text $graphCol [expr $graphRow-1] X \
		[expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+18+$graphY] \
		-text "Col $i" -anchor w  -tag graph_$cnt
	}
    }
    #
    # Draw Lines
    #
    
    set rw 1.0
    
    if { $rows > 1} {
	for {set j $ini} {$j < $cols} {incr j} {
	    for {set i 1} {$i < $rows} {incr i} {
		set y1 [graphData $activeSheet $cnt $j [expr $i-1] 1]
		if {$y1 ==""} {set y1 0}
		set y2 [graphData $activeSheet $cnt $j $i 1]
		if {$y2 ==""} {set y2 0}
		
		drawLine $canvas [colorIndex $j] \
		    [expr 1.0*($i-1)/($rows-1)] [expr $zero+1.0*$y1/$yDim] \
		    [expr 1.0*$i/($rows-1)] [expr $zero+1.0*$y2/$yDim] \
		    $cnt
	    }
	}
    }
}

# $Log: line.tcl,v $
# Revision 1.2  1998/10/19 23:25:52  cthulhu
# Fixed bug when displaying graphs with total col/row values adding up to zero.
#
# Revision 1.1  1998/08/17 20:11:22  cthulhu
# Initial revision
#
