# $Id: utils.tcl,v 1.12 1998/08/06 21:08:36 aml Exp $

proc rangeName {range} {
set s [ColName [lindex $range 0]][expr [lindex $range 1]+1]:[ColName [lindex $range 2]][expr [lindex $range 3]+1]
return $s
}

proc warnUser {message} {
    global queryReturnCode warningFont
    toplevel .query 
    wm overrideredirect .query true

    frame .query.frame -relief raised -borderwidth 8

    frame .query.frame.l1 

    label .query.frame.l1.stop -image stop_bm
    label .query.frame.l1.msg -text $message -font $warningFont
    pack .query.frame.l1.stop .query.frame.l1.msg -side left -expand yes -padx 10
    pack .query.frame.l1

    frame .query.frame.fr -bd 3 -relief sunken 
    button .query.frame.fr.but -text "Ok" -font $warningFont\
            -command "destroy .query"

    
    pack .query.frame
    pack .query.frame.fr -padx 10 -pady 10
    pack .query.frame.fr.but -expand yes -anchor s -padx 10 -pady 10
    focus .query.frame.fr.but
    grab set .query.frame

    wm transient .query
    dpos .query
    tkwait window .query

}

proc queryUser {message listOfChoices} {
    global queryReturnCode warningFont
    toplevel .query 

    wm overrideredirect .query true

    frame .query.frame -relief raised -borderwidth 8


    frame .query.frame.l1 
    label .query.frame.l1.stop -image stop_bm
    label .query.frame.l1.msg -text $message -font $warningFont
    pack .query.frame.l1.stop .query.frame.l1.msg -side left -expand yes -padx 10
    pack .query.frame.l1
    pack .query.frame

    set cnt 0
    foreach i $listOfChoices {
        
        if {$cnt > 0} {
            button .query.frame.but_$i -text $i -font $warningFont\
                -command "puts Pressed ; set queryReturnCode $cnt ; destroy .query"
            pack .query.frame.but_$i -side left -padx 10 -pady 10 -expand yes
        } else {
            frame .query.frame.fr -bd 3 -relief sunken
            button .query.frame.fr.but_$i -text $i -font $warningFont\
                -command "puts Pressed ; set queryReturnCode $cnt ; destroy .query"
            pack .query.frame.fr -padx 10 -pady 10 -side left -expand yes
            pack .query.frame.fr.but_$i -side left -padx 10 -pady 10 -expand yes
            
        }
        incr cnt
    }
    focus .query.frame.fr.but_[lindex $listOfChoices 0]
    grab set .query

    dpos .query
    tkwait window .query
    return $queryReturnCode
}

proc createListboxMenu {name list_of_items var_name {export 1}} {
    global $var_name tmp_var menu_name

    set tmp_var $var_name
    frame $name.f1
    set menu_name $name

    scrollbar $name.f1.scroll -relief sunken \
        -command "$name.f1.list yview"
    if {$export==1} {
	listbox $name.f1.list -yscroll "$name.f1.scroll set" -relief sunken \
	    -setgrid 1 -bg white
    } else {
	listbox $name.f1.list -yscroll "$name.f1.scroll set" -relief sunken \
	    -setgrid 1 -bg white -exportselection false
    }
    foreach i $list_of_items {
	if {$i!=""} {
	    $name.f1.list insert end $i
	}
    }

    pack $name.f1.scroll -side right -fill y
    pack $name.f1.list -side left -expand yes -fill both
    pack $name.f1 -expand yes -fill both
}

proc ChangeListboxMenu {name list_of_items} {
    $name.f1.list delete 0 end
    
    foreach i $list_of_items {
        $name.f1.list insert end $i
    }
}

proc min {x y} {
    if {$x < $y} {return $x}
    return $y
}

proc max {x y} {
    if {$x > $y} {return $x}
    return $y
}


# $Log: utils.tcl,v $
# Revision 1.12  1998/08/06 21:08:36  aml
# Released alpha version of Abacus.
#
# Revision 1.11  1996/11/22 16:29:13  aml
# First cut at transforming canvas into a true cell widget.
# Text, lines and rectangles are now relative to row and colunm numbers.
# It still has a bug with wrong estimation of column widths.
#
# Revision 1.10  1996/09/04 14:29:55  aml
# Fixed double redrawing of sheets that was taking place.
# Fixed a item reference problem when the sheet is redrawn.
# Fixed misplacement of row labels.
# Created first version of format toolbar.
#
# Revision 1.9  1996/08/29 12:05:44  aml
# Fixed problem with initialization of formulas.
# Insertion in entry is now done properly.
# Focus is slightly better handled.
# Fixed serious problem when canvas changes name and old
# references exist. Also removed double call to redraw that
# was slowing things a lot.
#
# Revision 1.8  1996/08/24 10:16:06  aml
# Scroll almost fixed. We are missing scroll steps.
# Several sheets work again, but need to be fixed right.
#
# Revision 1.7  1996/04/27  11:12:35  aml
# Inserted check and delete button.
# Font selection widget created.
# Fixed bug canvas_information destructor.
#
# Revision 1.6  1996/03/11 15:47:47  aml
# Made redraw more efficient by removing at once all cells before redrawing.
# Fixed problem with unsufficient difinition of logical expressions.
# Added >=, <=, <>, @and and @or functions.
#
# Revision 1.5  1996/03/09 08:32:41  aml
# Fixed problem in string_single_arg macro
# Created if function, boolean evaluations and so on.
# Improved print controls.
#
# Revision 1.4  1996/03/07  20:33:00  aml
# Created print range ability.
# Set in gray non-working menus.
# Created RangeKill command.
# Created round function and macros for single argument functions.
#
# Revision 1.3  1996/02/13  12:03:45  aml
# Fixed bug with range definition via mouse.
# Fixed bug in range iterators.
#
# Revision 1.2  1996/01/09  18:34:51  aml
# Load, save, open, close and exit now work properly (hopefuly).
# Sheet utility functions also work : SheetExists, SheetEmpty, SheetModified
#
# Revision 1.1  1996/01/09  17:38:34  aml
# Initial revision
#