/*								-*- C++ -*-
 * $Id: DEV_memorydc.h,v 1.2 1996-11-19 13:30:00+01 mho Exp $
 *
 * Purpose: device context to draw into wxBitmaps
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef MemoryDC_h
#define MemoryDC_h

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmap;

class wxMemoryDC : public wxCanvasDC {
DECLARE_DYNAMIC_CLASS(wxMemoryDC)
public:
    wxMemoryDC(void);
    wxMemoryDC(wxCanvasDC *old_dc); // Create compatible DC
    ~wxMemoryDC(void);

    // ask, if a part of the DC is exposed
    int IsExposed(float x, float y);
    int IsExposed(float x, float y, float width, float height);
    // necessary, if drawing needs server grabbing (e.g. rubber-bands)
    void BeginDrawing(void) {};
    void EndDrawing(void) {};

    // set bitmap to draw in
    void SelectObject(wxBitmap *bitmap);
};

#endif // MemoryDC_h
