/*								-*- C++ -*-
 * $Id: WIN_checkbox.cpp,v 1.2 1997-01-15 14:58:59+01 mho Exp $
 *
 * Purpose: check box panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_checkbox.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxCheckBox
#include "wx.h"
#define  Uses_ToggleWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy checkbox
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxCheckBox, wxItem)

wxCheckBox::wxCheckBox(void) : wxItem()
{
    __type = wxTYPE_CHECK_BOX;
    bmp=NULL;
}

wxCheckBox::wxCheckBox(wxPanel *panel, wxFunction function, Const char *label,
		       int x, int y, int width, int height,
		       long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_CHECK_BOX;

    Create(panel, function, label, x, y, width, height, style, name);
}

wxCheckBox::wxCheckBox(wxPanel *panel, wxFunction function, wxBitmap *bitmap,
		       int x, int y, int width, int height,
		       long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_CHECK_BOX;

    Create(panel, function, bitmap, x, y, width, height, style, name);
}

wxCheckBox::wxCheckBox(wxPanel *panel, wxFunction function, wxBitmap& bitmap,
		       int x, int y, int width, int height,
		       long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_CHECK_BOX;

    Create(panel, function, bitmap, x, y, width, height, style, name);
}

Bool wxCheckBox::Create(wxPanel *panel, wxFunction function, Const char *label,
			int x, int y, int width, int height,
			long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    Boolean border = !(style & wxNO_BORDER);	// is there a border around the button
    int     margin = (border ? 4 : 0);		// margin around the label
    // create widget
    HWidget() = FWidget() = XtVaCreateManagedWidget
	(name, xfwfToggleWidgetClass, GetParentWidget(parent),
	 XtNlabel,       	label,
	 XtNbackground,  	bg.GetPixel(&cmap),
	 XtNforeground,  	fg.GetPixel(&cmap),
	 XtNfont,        	font.GetInternalFont(),
	 XtNshrinkToFit, 	(width < 0 || height < 0),
	 XtNhighlightThickness, margin/2,
	 XtNtraversalOn, 	border,
	 XtNtopMargin,          margin,
	 XtNbottomMargin,       margin,
 	 XtNalignment,		(style & wxNO_INDICATOR ? XfwfCenter : XfwfLeft),
 	 XtNindicatorType,	(style & wxNO_INDICATOR ? XfwfButtonIndicator : XfwfSquareIndicator),
	 NULL);
    // set data declared in wxItem
    callback = function;
    XtAddCallback(HWidget(), XtNonCallback,  wxCheckBox::OnEventCallback,  (XtPointer)this);
    XtAddCallback(HWidget(), XtNoffCallback, wxCheckBox::OffEventCallback, (XtPointer)this);

    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();
    AllowResize(FALSE);

    return TRUE;
}

Bool wxCheckBox::Create(wxPanel *panel, wxFunction function, wxBitmap *bitmap,
			int x, int y, int width, int height,
			long style, Constdata char *name)
{
    if (!bitmap) {
	wxError("NULL bitmap specified", "wxCheckBox::Create");
	return Create(panel, function, "ERROR", x, y, width, height, style, name);
    } 
    return Create(panel, function, *bitmap, x, y, width, height, style, name);
}

Bool wxCheckBox::Create(wxPanel *panel, wxFunction function, wxBitmap& bitmap,
			int x, int y, int width, int height,
			long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    // check bitmap
    if (!bitmap.Ok()) {
	wxError("uninitialized bitmap specified", "wxCheckBox::Create");
	return Create(panel, function, "ERROR", x, y, width, height, style, name);
    }
    bmp = bitmap;

    Boolean border  = !(style & wxNO_BORDER);	// is there a border around the button
    int     margin = (border ? 4 : 0);		// margin around the label
    // create widget
    HWidget() = FWidget() = XtVaCreateManagedWidget
	(name, xfwfToggleWidgetClass, GetParentWidget(parent),
	 XtNpixmap,      	bitmap.GetPixmap(),
	 XtNmask,        	bitmap.GetMask(),
	 XtNbackground,  	bg.GetPixel(&cmap),
	 XtNforeground,  	fg.GetPixel(&cmap),
	 XtNfont,        	font.GetInternalFont(),
	 XtNshrinkToFit, 	(width < 0 || height < 0),
	 XtNhighlightThickness, margin/2,
	 XtNtraversalOn, 	border,
	 XtNtopMargin,          margin,
	 XtNbottomMargin,       margin,
 	 XtNalignment,		(style & wxNO_INDICATOR ? XfwfCenter : XfwfLeft),
 	 XtNindicatorType,	(style & wxNO_INDICATOR ? XfwfButtonIndicator : XfwfSquareIndicator),
	 NULL);
    // set data declared in wxItem
    callback = function;
    XtAddCallback(HWidget(), XtNonCallback,  wxCheckBox::OnEventCallback,
		  (XtPointer)this);
    XtAddCallback(HWidget(), XtNoffCallback, wxCheckBox::OffEventCallback,
		  (XtPointer)this);

    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();
    AllowResize(FALSE);

    return TRUE;
}

//-----------------------------------------------------------------------------
// alternate SetLabel for changing bitmap
//-----------------------------------------------------------------------------

void wxCheckBox::AllowResize(Bool allow)
{
    XtVaSetValues(HWidget(), XtNshrinkToFit, allow, NULL);
}

void wxCheckBox::SetAlignment(long alignment)
{
    XtVaSetValues(HWidget(), XtNalignment, alignment, NULL);
}

void wxCheckBox::SetLabel(char *label)
{
    XtVaSetValues(HWidget(),
		  XtNlabel,  label,
		  XtNpixmap, None,
		  XtNmask,   None,
		  NULL);
}

void wxCheckBox::SetLabel(wxBitmap *bitmap)
{
    if (!bitmap) {
	wxError("NULL bitmap specified", "wxCheckBox::SetLabel");
	SetLabel("ERROR");
    } else
	SetLabel(*bitmap);
}

void wxCheckBox::SetLabel(wxBitmap& bitmap)
{
    if (!bitmap.Ok()) {
	wxError("uninitialized bitmap specified", "wxCheckBox::SetLabel");
	SetLabel("ERROR");
    } else {
	bmp = bitmap;
	if (bmp.GetDepth() == 1 || bmp.GetDepth() == wxDisplayDepth())
	    XtVaSetValues(HWidget(),
			  XtNlabel,  NULL,
			  XtNpixmap, bitmap.GetPixmap(),
			  XtNmask,   bitmap.GetMask(),
			  NULL);
    }
}

//-----------------------------------------------------------------------------
// wxCheckBox: set & query state
//-----------------------------------------------------------------------------

Bool wxCheckBox::GetValue(void)
{
    Boolean state;
    XtVaGetValues(HWidget(), XtNon, &state, NULL);
    return state;
}

void wxCheckBox::SetValue(Bool state)
{
    XtVaSetValues(HWidget(), XtNon, Boolean(state), NULL);
}

//-----------------------------------------------------------------------------
// callbacks for xfwfToggleWidgetClass
//-----------------------------------------------------------------------------

void wxCheckBox::OnEventCallback(Widget WXUNUSED(w),
				 XtPointer clientData, XtPointer WXUNUSED(ptr))
{
    wxCheckBox     *checkbox = (wxCheckBox*)clientData;
    wxCommandEvent event(wxEVENT_TYPE_CHECKBOX_COMMAND);

    event.eventObject = checkbox;
    event.commandInt  = TRUE;

    checkbox->ProcessCommand(event);
}

void wxCheckBox::OffEventCallback(Widget WXUNUSED(w),
				  XtPointer clientData, XtPointer WXUNUSED(ptr))
{
    wxCheckBox     *checkbox = (wxCheckBox*)clientData;
    wxCommandEvent event(wxEVENT_TYPE_CHECKBOX_COMMAND);

    event.eventObject = checkbox;
    event.commandInt  = FALSE;

    checkbox->ProcessCommand(event);
}
