/*
 * Copyright (c) 1997, 1998 Akira Yoshiyama <yosshy@debian.or.jp>
 * Copyright (c) 1998 Fumitoshi UKAI <ukai@debian.or.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licenses as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * wcrtomb_locale ()
 * for conversion from UCS-4 to multibyte character
 * programed
 *   by A. Yoshiyama (yosshy@jedi.seg.kobe-u.ac.jp)
 *   on Dec.17,1996
 */

#include <wchar.h>
#include <wcsmbs_locale.h>

#if DEBUG
#include <stdio.h>
#include <stdlib.h>
#endif

extern size_t
dll_wcsnrtombs_locale (char *, const wchar_t **, size_t, size_t, mbstate_t *);

size_t
dll_wcrtomb_locale (s, wc, ps)
     char *s;
     wchar_t wc;
     mbstate_t *ps;
{
  static mbstate_t internal = {0, (wint_t)0};
  const wchar_t wcs[2] = {wc, 0};
  const wchar_t *wcsp = (const wchar_t *)wcs;
  size_t result;

#if DEBUG
  fprintf(stderr,"%s:dll_wcrtomb_locale(s, wc, ps)\n",
	getenv(MONENV));
  fprintf(stderr,"s=%p, wc=%x, ps=%p)\n", s, wc, ps);
#endif

  if (ps == NULL)
    ps = &internal;

  if (s == NULL)
    {
      result = (size_t)((ps->count != 0) || (ps->value != (wint_t)0));
      ps->count = 0;
      ps->value = (wint_t)0;
    }
  else
    if (wc == (wchar_t)0)
      {
	*s = '\0';
	ps->count = 0;
	ps->value = (wint_t)0;
	result = (size_t)0;
      }
    else
      result = dll_wcsnrtombs_locale (s, &wcsp, (size_t)1, SIZE_T_MAX, ps);

#if DEBUG
  fprintf(stderr,"dll_wcrtomb_locale:result = %d\n", result);
#endif

  return result;
}
