#!/usr/bin/perl
#
# Copyright (c) 1997,1998 Akira Yoshiyama <yosshy@debian.or.jp>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public Licenses as
# published by the Free Software Foundation; either version 2 of 
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

$count=0;

while (<>) {
    next if (/^\s*#/);
    if (/^\s*(\w+):\s*(\w*)/) {
	$symbol{$1} = $count;
	$default[$count] = 1 if ($2 eq "default");
	$end[$count-1] = 1 if ($count > 0);
    }
    if (/^\s*(0[xX][\da-fA-f]+)\s*(0[xX][\da-fA-f]+)/) {
	$key[$count] = $1;
	$value[$count] = $2;
	$count++;
	next;
    }
    if (/^\s*(0[xX][\da-fA-f]+)\s*(\w+):/) {
	$key[$count] = $1;
	$value[$count] = $2;
	$link[$count] = 1;  #link entry
	$count++;
	next;
    }
}
$end[$count-1] = 1;

print "node_t table_mbs2wcs[] = {\n";
for ($i=0; $i<$count; $i++) {
    print "{$key[$i],\t";

    print "CODE" if ($link[$i] == 0);
    print "LINK" if ($link[$i] == 1);
    print "|DEF_P" if ($default[$i] == 1);
    print "|END_P" if ($end[$i] == 1);

    print ",\t";

    if ($link[$i] == 1) {
	print $symbol{$value[$i]};
    } else {
	print $value[$i];
    }
    print "},\n";
}
print "};\n\nint table_mbs2wcs_maxentry = ",$count,";\n\n";
