#!/usr/bin/perl
#
# Copyright (c) 1997,1998 Akira Yoshiyama <yosshy@debian.or.jp>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public Licenses as
# published by the Free Software Foundation; either version 2 of 
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

if (@ARGV < 2) {
#  print "usage: $0 <caharacterset name> <mask> <esc.policy> [<source file>]";
#  print "esc.policy: {locking,single}";
  print "usage: $0 <caharacterset name> <mask> [<source file>]";
  exit 0;
}

#($charname, $mask, $default, $sourcefile) = @ARGV;
($charname, $mask, $sourcefile) = @ARGV;
$sourcefile = "cat|" if ($sourcefile eq undef);

# print "$charname $mask $outputfile\n";

open (SOURCE, $sourcefile) || die "can't open $source";


while (<SOURCE>) {
  chomp;
  if (!/^#/) {
    @col = split(/\s+/,$_);
    $col[0] = sprintf "%X",hex($col[0])|hex($mask);
    $ucs2{$col[0]}=$col[1];
  }
}

#$oldkey="";
#foreach $key (sort(keys(%jis_upper))) {
#  print OFUCS2 $key,":",$jis_upper{$key},":",$jis_lower{$key},"\n";
#}


#print "map_",$charname,":";
#print "default" if ($default eq "locking");
#print "\n";

foreach $key (sort(keys(%ucs2))) {
  $upper=substr($key,0,2);
  if ($upper ne $oldupper2) {
    print "0x",$upper,"\tmap_",$charname,"_",$upper,":\n";
    $oldupper2 = $upper;
  }
}
print "\n";

foreach $key (sort(keys(%ucs2))) {
  $upper=substr($key,0,2);
  if ($upper ne $oldupper) {
    print "\n" if ($oldupper ne undef);
    print "map_",$charname,"_",$upper,":\n";
    $oldupper = $upper;
  }
  print "0x",substr($key,2,2),"\t",$ucs2{$key},"\n";
}
