/* NOTE: THIS PROGRAM IS UNDER CONSTRUCTION. PLEASE DO NOT USE THIS. */

/*
 * vf2bdf
 * --- Generate a BDF font file (Japanese kanji font) from vector font.
 *
 *  Programmed by Hirotsugu KAKUGAWA, Hiroshima University
 *  E-Mail:  kakugawa@se.hiroshima-u.ac.jp
 *
 * Edition History
 *  18 Jan 1996
 *
 */


/* This is a part of VFlib
 *
 * Copyright (C) 1996  Hirotsugu KAKUGAWA.   All rights reserved.
 *
 * VFlib is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
 * to anyone for the consequences of using it or for whether it serves any
 * particular purpose or works at all, unless he says so in writing.  Refer
 * to the GNU General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * VFlib, but only under the conditions described in the GNU
 * General Public License.  A copy of this license is supposed to have been
 * given to you along with VFlib so you can know your rights and
 * responsibilities.  It should be in a file named COPYING.  Among other
 * things, the copyright notice and this notice must be preserved on all
 * copies. 
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "../src/config.h"
#include "../src/VF.h"
#include "str.h"

#define DEFAULT_SIZE   32
#define BDF_SUFF      ".bdf"


int
main(argc, argv)
  int  argc;
  char **argv;
{
  int     xdots, ydots, yoff, fd, code_from, code_to, i;
  char    *ent, *vfcap, *bdf_fname;

  vfcap = NULL;
  ent   = NULL;
  xdots = DEFAULT_SIZE;
  ydots = DEFAULT_SIZE;
  bdf_fname = NULL;
  code_from = 0x2121;
  code_to   = 0x7424;

  argv++;
  argc--;
  while (argc > 0){
    if (argv[0][0] != '-'){
      ent = *argv;
    } else {
      switch (argv[0][1]){
      case 'f':
	if (--argc == 0)
	  usage();
	ent = *(++argv);
	break;
      case 'x':
	if (--argc == 0)
	  usage();
	xdots = atoi(*(++argv)); 
	break;
      case 'y':
	if (strcmp(argv[0], "y") == 0){
	  if (--argc == 0)
	    usage();
	  ydots = atoi(*(++argv)); 
	} else if (strcmp(argv[0], "yoff") == 0){
	  if (--argc == 0)
	    usage();
	  yoff = atoi(*(++argv)); 
	} else {
	  usage();
	}
	break;
      case 'o':
	if (--argc == 0)
	  usage();
	bdf_fname = *(++argv);
	break;
      case 'v':
	if (--argc == 0)
	  usage();
	vfcap = *(++argv);
	break;
      case 'h':
      default:
	usage();
      }
    }
    argc--;
    argv++;
  }

  if (ent == NULL)
    usage();

  if (bdf_fname == NULL){
    if ((bdf_fname = malloc(strlen(ent)+strlen(BDF_SUFF)+1)) == NULL){
      fprintf(stderr, "No memory\n");
      exit(0);
    } 
    strcpy(bdf_fname, ent);
    strcat(bdf_fname, BDF_SUFF);
  }
  
  if (VF_Init(vfcap) < 0){
    printf("VFlib initialization error\n");
    exit(1);
  }
  if ((fd = VF_OpenFont(ent)) < 0){
    printf("Can't open font: %s\n", ent);
    exit(-1);
  }

  GenerateBDF(fd, xdots, ydots, yoff, bdf_fname, code_from, code_to);

  VF_CloseFont(fd);
  VF_Deinit();
  return 0;
}

usage()
{
  printf("vf2bdf  - vector font to BDF converter.\n");
  printf("Usage vf2bdf [options] font\n");
  printf("Options: \n");
  printf("  -x DOTS  : set width of a character.\n");
  printf("  -y DOTS  : set heght of a character.\n");
  printf("  -o FILE  : set output file.\n");
  printf("  -v FILE  : set vfontcap file. (must be a full path name)\n");
  printf("  -f FONT  : specify font entry name. %s\n");
  printf("  -h       : print this.\n");
  exit(0);
}


int
GenerateBDF(fd, xdots, ydots, yoff, fname, code_from, code_to)
     int   fd, xdots, ydots, yoff;
     char  *fname;
     int   code_from, code_to;
{
  FILE           *bdf;
  int            jiscode, xbytes, page;
  unsigned char  *buff;

  xbytes = (xdots+7)/8;
  if ((buff = calloc(ydots, xbytes)) == NULL){
    fprintf(stderr, "No memory\n");
    exit(0);
  } 
  if ((bdf = fopen(fname, "w")) == NULL){
    fprintf(stderr, "Can't open output file: %s\n", fname);
    exit(0);
  } 

  BDF_Header(bdf, xdots, ydots);
  for (page = 0x2100; page <= 0x7400; page += 0x0100){
    for (jiscode = page+0x21; jiscode <= page+0x7e; jiscode++){
      bzero(buff, xbytes*ydots);
      if (VF_GetBitmap(jiscode, fd, xdots, ydots, xbytes, 0, buff) >= 0)
	BDF_PutChar(bdf, buff, jiscode, xdots, ydots, xbytes);
    }
  }
  BDF_Trailer(bdf, xdots, ydots);
  fclose(bdf);

  return 0;
}


int
BDF_PutChar(bdf, buff, code, xdots, ydots, xbytes)
     FILE          *bdf;
     int           code, xdots, ydots, xbytes;
     unsigned char *buff;
{
  int  x, y;

  fprintf(bdf, "STARTCHAR %4x\n", code);
  fprintf(bdf, "ENCODING %d\n", code);
  fprintf(bdf, "SWIDTH 960 0\n");
  fprintf(bdf, "DWIDTH %d 0\n", xdots);
  fprintf(bdf, "BBX %d %d 0 2\n", xdots, ydots);
  fprintf(bdf, "BITMAP\n");
  for (y = 0; y < ydots; y++){
    for (x = 0; x < (xdots+7)/8; x++)
      fprintf(bdf, "%02X", buff[y*xbytes+x]);
    fprintf(bdf, "\n");
  }
  fprintf(bdf, "ENDCHAR\n");
  return 0;
}

int
BDF_Header(bdf, xdots, ydots, yoff)
     FILE          *bdf;
     int           xdots, ydots, yoff;
{
  fprintf(bdf, "STARTFONT 2.1\n");
  fprintf(bdf, "COMMENT \n");
  fprintf(bdf, "COMMENT BDF font by VF2BDF\n");
  fprintf(bdf, "COMMENT \n");
  fprintf(bdf, "FONT -%s-%s-%s-%s-%s--%d-130-75-75-C-140-JISX0208.1983-0\n", 
	  "Misc", "Fixed", "Medium", "R", "Normal", xdots);
  fprintf(bdf, "SIZE %d 75 75\n", xdots);
  fprintf(bdf, "FONTBOUNDINGBOX %d %d 0 %d\n", xdots, ydots, -yoff);
  fprintf(bdf, "STARTPROPERTIES 19\n");
  fprintf(bdf, "FONTNAME_REGISTRY \"\"\n");
  fprintf(bdf, "FOUNDRY \"Misc\"\n");
  fprintf(bdf, "FAMILY_NAME \"Fixed\"\n");
  fprintf(bdf, "WEIGHT_NAME \"Medium\"\n");
  fprintf(bdf, "SLANT \"R\"\n");
  fprintf(bdf, "SETWIDTH_NAME \"Normal\"\n");
  fprintf(bdf, "ADD_STYLE_NAME \"\"\n");
  fprintf(bdf, "PIXEL_SIZE %d\n", xdots);
  fprintf(bdf, "POINT_SIZE 130\n");
  fprintf(bdf, "RESOLUTION_X 75\n");
  fprintf(bdf, "RESOLUTION_Y 75\n");
  fprintf(bdf, "SPACING \"C\"\n");
  fprintf(bdf, "AVERAGE_WIDTH 140\n");
  fprintf(bdf, "CHARSET_REGISTRY \"JISX0208.1983\"\n");
  fprintf(bdf, "CHARSET_ENCODING \"0\"\n");
  fprintf(bdf, "DEFAULT_CHAR 8481\n");
  fprintf(bdf, "FONT_DESCENT 2\n");
  fprintf(bdf, "FONT_ASCENT 12\n");
  fprintf(bdf, "COPYRIGHT \"Obey the copyright of the origical font.\"\n");
  fprintf(bdf, "ENDPROPERTIES\n");
  fprintf(bdf, "CHARS 6877\n");
  return 0;
}

int
BDF_Trailer(bdf, xdots, ydots)
     FILE          *bdf;
     int           xdots, ydots;
{
  fprintf(bdf, "ENDFONT\n");
  return 0;
}

/*EOF*/
