*DECK QCRJ
      SUBROUTINE QCRJ (LUN, KPRINT, IPASS)
C***BEGIN PROLOGUE  QCRJ
C***PURPOSE  Quick check for RJ.
C***LIBRARY   SLATEC
C***KEYWORDS  QUICK CHECK
C***AUTHOR  Pexton, R. L., (LLNL)
C***DESCRIPTION
C
C            QUICK TEST FOR CARLSON INTEGRAL RJ
C
C***ROUTINES CALLED  NUMXER, R1MACH, RJ, XERCLR, XGETF, XSETF
C***REVISION HISTORY  (YYMMDD)
C   790801  DATE WRITTEN
C   890618  REVISION DATE from Version 3.2
C   891214  Prologue converted to Version 4.0 format.  (BAB)
C   910708  Minor modifications in use of KPRINT.  (WRB)
C***END PROLOGUE  QCRJ
      INTEGER KPRINT, IPASS, CONTRL, KONTRL, LUN, IER
      INTEGER IPASS1, IPASS2, IPASS3, IPASS4, NUMXER
      REAL CONSJ, TRJ, RJ, DIF, R1MACH
      EXTERNAL NUMXER, R1MACH, RJ, XERCLR, XGETF, XSETF
C***FIRST EXECUTABLE STATEMENT  QCRJ
      CALL XERCLR
      CALL XGETF(CONTRL)
      IF ( KPRINT .GE. 3 ) THEN
         KONTRL = +1
      ELSE
         KONTRL = 0
      ENDIF
      CALL XSETF(KONTRL)
C
C  FORCE ERROR 1
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,101)
  101 FORMAT(' RJ - FORCE ERROR 1 TO OCCUR')
      TRJ = RJ(-1.0E0,-1.0E0,-1.0E0,-1.0E0,IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 1 ) THEN
         IPASS1 = 1
      ELSE
         IPASS1 = 0
      ENDIF
      CALL XERCLR
C
C  FORCE ERROR 2
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,102)
  102 FORMAT(' RJ - FORCE ERROR 2 TO OCCUR')
      TRJ = RJ(R1MACH(1),R1MACH(1),R1MACH(1),R1MACH(1),IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 2 ) THEN
         IPASS2 = 1
      ELSE
         IPASS2 = 0
      ENDIF
      CALL XERCLR
C
C  FORCE ERROR 3
C
      IF ( KPRINT .GE. 3 ) WRITE (LUN,103)
  103 FORMAT(' RJ - FORCE ERROR 3 TO OCCUR')
      TRJ = RJ(R1MACH(2),R1MACH(2),R1MACH(2),R1MACH(2),IER)
      IER = NUMXER(IER)
      IF ( IER .EQ. 3 ) THEN
         IPASS3 = 1
      ELSE
         IPASS3 = 0
      ENDIF
      CALL XERCLR
C
C  ARGUMENTS IN RANGE
C
      CONSJ = 0.142975796671567538E0
      TRJ   = RJ(2.0E0,3.0E0,4.0E0,5.0E0,IER)
      CALL XERCLR
      DIF   = TRJ - CONSJ
      IF ( (ABS(DIF/CONSJ).LT.1000.0E0*R1MACH(4)).AND.(IER.EQ.0) ) THEN
         IPASS4 = 1
      ELSE
         IPASS4 = 0
      ENDIF
      IPASS = MIN(IPASS1,IPASS2,IPASS3,IPASS4)
      IF (KPRINT .LE. 0 ) THEN
         GO TO 999
      ELSEIF ( KPRINT .EQ. 1 ) THEN
         IF ( IPASS .EQ. 1 ) THEN
            GO TO 999
         ELSE
            WRITE (LUN,104)
  104       FORMAT(' RJ - FAILED')
            GO TO 999
         ENDIF
      ELSE
         IF ( IPASS .EQ. 1 ) THEN
            WRITE (LUN,105)
  105       FORMAT(' RJ - PASSED')
            GO TO 999
         ELSE
            WRITE (LUN,104)
            IF ( IPASS4 .EQ. 0 ) WRITE (LUN,106) CONSJ, TRJ, DIF
  106       FORMAT(' CORRECT ANSWER =', 1PE14.6 /
     *             'COMPUTED ANSWER =',   E14.6 /
     *             '     DIFFERENCE =',   E14.6 )
            GO TO 999
         ENDIF
      ENDIF
  999 CONTINUE
      CALL XSETF(CONTRL)
      RETURN
      END
