#ifndef _URKDUST__
#define _URKDUST__

#include <ncbi.h>
#include <seqport.h>
#include <sequtil.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct dustdata
{
  FloatHi percent;
  Int4    level, windowsize, minwin, linker, method;
  Boolean flagGraph, flagBrute;
} DustData, PNTR DustDataPtr;

typedef struct dustregion
{
  FloatHi percent;
  Int4    from, to;
  struct  dustregion PNTR next;
} DustRegion, PNTR DustRegionPtr;

typedef struct dustcurrentvalues
{
  Int4    curlevel, curstart, curend;
} DustCurVal, PNTR DustCurValPtr;

#define MAXSEQCHUNK  262144

/*
 caller responsibiliity
  ddp = DustDataNew ();
  drp = Dust... (..., ddp);
  slp = DustFilter (drp, ddp->percentcut, ...);
  DustRegionFree (drp);
  DustDataFree (ddp);
*/

extern DustDataPtr DustDataNew (void);
extern DustDataPtr DustDataFree (DustDataPtr ddp);
extern DustRegionPtr DustRegionNew (DustRegionPtr drp);
extern DustRegionPtr DustRegionFree (DustRegionPtr drp);

extern DustRegionPtr DustSeq (CharPtr seq, Int4 start, Int4 stop,
                              DustDataPtr ddp);
extern DustRegionPtr DustSeqPort (SeqPortPtr spp,
                                  Int4 start, Int4 stop,
                                  DustDataPtr ddp);
extern DustRegionPtr DustBioseq (BioseqPtr bsp,
                                 Int4 start, Int4 stop,
                                 DustDataPtr ddp);
extern DustRegionPtr DustSeqLoc (SeqLocPtr slp,
                                 DustDataPtr ddp);
extern SeqLocPtr DustFilter (DustRegionPtr drp, FloatHi percentcut,
                             SeqIdPtr sip);
extern FloatHiPtr DustForGraph (DustRegionPtr drp, Int4 length,
                                Int4 start, Int4 stop);

#ifdef __cplusplus
}
#endif

#endif
