#include <wintree.h>

/* Zoom */

/* internal defines */
#define ZOOMAX 12

/* internal globals */
static Int4 zooms [ZOOMAX] =
{
  1L, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L
};

static void InitZoomPopup (GeneTreeFormPtr cfp)
{
  Char    buf[16];
  Int2    i;

  if (cfp != NULL)
  {
    SafeHide (cfp->scale);
    Reset (cfp->scale);
    for (i = 1; i < ZOOMAX; i++)
    {
      sprintf (buf, "%ld", (long) (zooms[i]));
      PopupItem (cfp->scale, buf);
    }
    SetValue (cfp->scale, 1);
    SafeShow (cfp->scale);
  }
  return;
}

static void ScaleGeneTree (PopuP p)
{
  GeneTreeFormPtr  cfp;
  Int2            i;
  Int4            sX, sY = 1;

  cfp = (GeneTreeFormPtr) GetObjectExtra (p);
  if (cfp == NULL)
    return;
  Reset (cfp->v);
  Update ();
  i = GetValue (cfp->scale);
  if (i < ZOOMAX && i > 0)
    sX = zooms[i];
  else
    sX = 1;
  AttachPicture (cfp->v, cfp->s, INT4_MIN, INT4_MAX, UPPER_LEFT,
                 sX, sY, NULL);
  return;
}

static void CloseGeneTreeProc (ButtoN b)
{
  WindoW   w;

  if (b != NULL)
  {
    w = (WindoW) GetObjectExtra (b);
    Remove (w);
  }
  return;
}

extern void PictureToGeneTreeForm (ForM f, Pointer data)
{
  GeneTreeFormPtr   cfp;
  VieweR           v1;
  GrouP            g1, g2;
  ButtoN           b;
  SegmenT          s1;
  Int4             sX, sY;
  RecT             r, s;

  sX = 1;
  sY = 1;
  cfp = (GeneTreeFormPtr) GetObjectExtra (f);
  s1 = (SegmenT) data;

  if (s1 != NULL)
  {
    cfp->s = s1;
    g1 = HiddenGroup ((WindoW) cfp->form, -1, 0, NULL);
    v1 = CreateViewer (g1, 200, 140, TRUE, TRUE);
    cfp->v = v1;
    AttachPicture (v1, s1, INT4_MIN, INT4_MAX, UPPER_LEFT,
                   sX, sY, NULL);
    g2 = HiddenGroup ((WindoW) cfp->form, 2, 0, NULL);
    cfp->bottombuts = g2;
    b = PushButton (g2, "Close", CloseGeneTreeProc);
    SetObjectExtra (b, cfp->form, NULL);
    cfp->scale = PopupList (g2, TRUE, ScaleGeneTree);
    InitZoomPopup (cfp);
    SetObjectExtra (cfp->scale, cfp, NULL);
    AlignObjects (ALIGN_VERTICAL, (HANDLE) b, (HANDLE) cfp->scale,
                  NULL);
    AlignObjects (ALIGN_CENTER, (HANDLE) g1, (HANDLE) g2, NULL);
  }
  RealizeWindow ((WindoW) cfp->form);
  ObjectRect (cfp->form, &r);
  GetPosition (v1, &s);
  cfp->voff = s.bottom - s.top;
  GetPosition (g2, &r);
  cfp->butoff = r.top - s.top;

  return;
}

static GeneTreeFormPtr GeneTreeFormNew (void)
{
  GeneTreeFormPtr  cfp;

  cfp = (GeneTreeFormPtr) MemNew (sizeof (GeneTreeForm));

  return cfp;
}

static GeneTreeFormPtr GeneTreeFormFree (GeneTreeFormPtr cfp)
{
  return MemFree (cfp);
}

static void CleanupGeneTreeForm (GraphiC g, VoidPtr data)
{
  GeneTreeFormPtr cfp;

  if ((cfp = (GeneTreeFormPtr) data) != NULL)
  {
    WatchCursor ();
    cfp->s = DeletePicture (cfp->s);
    ArrowCursor ();
  }
  StdCleanupFormProc (g, data);
  return;
}

static void CloseGeneTreeFormProc (WindoW w)
{
  Remove (w);
  return;
}

static void ResizeGeneTreeForm (WindoW w)
{
  GeneTreeFormPtr cfp;
  Int2           height, width, bottom;
  Int2           size, top, left;
  RecT           r, s;

  if ((cfp = (GeneTreeFormPtr) GetObjectExtra (w)) != NULL)
  {
    ObjectRect (w, &r);
    width = r.right - r.left;
    height = r.bottom - r.top;
    if (cfp->v != NULL)
    {
      GetPosition (cfp->v, &s);
      top = s.top;
      left = s.left;
      s.right = width - left;
/*      s.bottom = top + cfp->voff; */
      s.bottom = height - top - 50;
      SetPosition (cfp->v, &s);
      AdjustPrnt (cfp->v, &s, FALSE);
      if (Visible (cfp->v) && AllParentsVisible (cfp->v))
      {
        ViewerWasResized (cfp->v);
      }
      bottom = s.bottom;
    }
    if (cfp->bottombuts != NULL)
    {
      GetPosition (cfp->bottombuts, &s);
      size = s.right - s.left;
      s.left = left + (width - size) / 2;
      s.right = s.left + size;
      size = s.bottom - s.top;
/*      s.top = top + cfp->butoff; */
      s.top = bottom + 25;
      s.bottom = s.top + size;
      SetPosition (cfp->bottombuts, &s);
    }
    Update ();
  }
  return;
}

extern ForM CreateGeneTreeForm (Int2 left, Int2 top, CharPtr title,
                                SegmenT seg)
{
  WindoW         w = NULL;
  GeneTreeFormPtr cfp;

  if (seg == NULL)
    return (ForM) w;

  cfp = GeneTreeFormNew ();
  if (cfp != NULL)
  {
    if ((w = DocumentWindow (left, top, -10, -10, title,
                             CloseGeneTreeFormProc,
                             ResizeGeneTreeForm)) == NULL)
    {
      GeneTreeFormFree (cfp);
      return (ForM) w;
    }
    SetObjectExtra (w, cfp, CleanupGeneTreeForm);
    cfp->form = (ForM) w;
    cfp->actproc = NULL;
    cfp->toform = PictureToGeneTreeForm;
  }
  return (ForM) w;
}

extern void ViewTree (SegmenT seg)
{
  WindoW         w;
  GeneTreeFormPtr cfp;

  if (seg == NULL)
  {
    Message (MSG_ERROR, "No picture to display");
    return;
  }
  if ((w = (WindoW) CreateGeneTreeForm (-50, -33, "Sorted Tree",
                                        seg)) == NULL)
  {
    Message (MSG_ERROR, "Viewer creation error");
    return;
  }
  if ((cfp = (GeneTreeFormPtr) GetObjectExtra (w)) != NULL)
  {
    PictureToGeneTreeForm (cfp->form, seg);
  }
  Show (w);
  Select (w);
  return;
}
