/* 
 * $Id: msql.c,v 1.17 1998/09/27 11:20:12 ch Exp $
 *
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include "msql.h"
#include "libch.h"

int	ch_msql_id=-1;

void ch_msql_open(char *name) {
        if ( (ch_msql_id = msqlConnect("localhost")) == -1) {
                ch_panic("msgConnect failed (%s)\n", msqlErrMsg);
        }
        if ( msqlSelectDB (ch_msql_id,name) == -1) {
                ch_panic("msqlSelectDB failed (%s)\n", msqlErrMsg);
        }
}

void ch_msql_close() {
	msqlClose(ch_msql_id);
}

char *ch_msql_error() {
	return "Not Supported.";
}

int ch_msql_getid() {
	return ch_msql_id;
}

void ch_msql_query(char *query) {
	if (ch_msql_id==-1) {
		ch_panic("ch_msql_query: NO Database opened !!!");
	}
	if (msqlQuery(ch_msql_id,query)==-1) {
		ch_panic("ch_msql_query: ERROR at %s:\n%s\n",query,msqlErrMsg);
	}
} 

int ch_msql_quiet_query(char *query) {
	if (ch_msql_id==-1) return 1;
	if (msqlQuery(ch_msql_id, query)==-1) return 1;
	return 0; 
} 

int ch_msql_num_rows(m_result *res) {
	return msqlNumRows(res);
}

m_result *ch_msql_store_result() {
	return msqlStoreResult();
}

m_row ch_msql_fetch_row(m_result *res) {
	return msqlFetchRow(res);
}

void ch_msql_free_result(m_result *res) {
	msqlFreeResult(res);
}

