/*
 * $Id: debug.c,v 1.9 1998/09/27 11:10:15 ch Exp $
 *
 * This is source code is part of my universal C library "libch".
 * Copyright (C) 1998 Christian Hammer <ch@westend.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * Revision 1.0  1998/02/02 14:46:09  ch
 * Renamed the project from libcgi to libch
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>

int	ch_debugged_yet=0;

/**									*/
/** 	void ch_debug(char *s)						*/
/**		alias 							*/
/**	void ___(char *s)						*/
/** 									*/
/** 	Debug routine. Saves given strings in the /tmp/ch_debugfile.$$ 	*/
/**	that is newly created every start. Survives a CGI prg core dump */
/**									*/
#define ____ ch_debug("LINE:%d",__LINE__);
#define ___ ch_debug
void ch_debug(char *format, ...) {
	FILE	*f;
	va_list	ap;
	char	s[30];

	sprintf(s,"/tmp/ch_debugfile.%d",(int)getpid());
	if (ch_debugged_yet==0) {
		f=fopen(s,"w");
		ch_debugged_yet=1;
	} else {
		f=fopen(s,"a");
	}
	va_start(ap,format);
	vfprintf(f,format,ap);
	fprintf(f,"\n");
	va_end(ap);
	fclose(f);
}

/**									*/
/** 	void ch_panic(char *format, ...)				*/
/** 									*/
/** 	Exits program with given string and logs reason.       	 	*/
/**									*/
void ch_panic(char *format, ...) {
	va_list		ap;
	char		s[255];

	va_start(ap,format);
	ch_debug("\nPANIC !\b");
	vsprintf(s,format,ap);
	ch_debug(s);
	fprintf(stderr,"\nPANIC !\n%s\n",s);
	fflush(stderr);
	va_end(ap);
	exit(EXIT_FAILURE);
}

/**									*/
/**	void *ch_malloc(size_t size)					*/
/**									*/
/**	A normal malloc, but with retrun code check.              	*/
/**									*/
void *ch_malloc(size_t size) {
	void 	*tmp;

	tmp=malloc(size);
	if (tmp==NULL) {
		ch_panic("ch_malloc: not enough memory (%d)",size);
	}

	return tmp;
}

/**									*/
/**	void ch_free(void *pointer)					*/
/**									*/
/**	A normal free, but this one setzt the variable to NULL		*/
/**									*/
void ch_free(void *pointer) {
	free(pointer);
	pointer=NULL;
}


/**									*/
/**	char *ch_done() 						*/
/**									*/
/**	Removes debug file since prg runned to the end w/o problems	*/
/**									*/
void ch_done() {
	char 	s[30];

	sprintf(s,"/tmp/ch_debugfile.%d",(int)getpid());
	printf("\n");
	remove(s);
}

