/*
 * $Id: test3.c,v 1.9 1998/10/06 20:31:32 jon Exp $
 *
 * Test initially created to simulate a problem in nedit.
 * Then augmented to observe callback structures.
 */

#include <Xm/XmP.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <stdio.h>

XtAppContext app;
Widget toplevel, box, push;

int	popdown;

static char *
XdbReason2String(int reason)
{
	switch (reason) {
	case XmCR_NONE:		return "XmCR_NONE";
	case XmCR_HELP:		return "XmCR_HELP";
	case XmCR_VALUE_CHANGED:return "XmCR_VALUE_CHANGED";
	case XmCR_INCREMENT:	return "XmCR_INCREMENT";
	case XmCR_DECREMENT:	return "XmCR_DECREMENT";
	case XmCR_PAGE_INCREMENT:return "XmCR_PAGE_INCREMENT";
	case XmCR_PAGE_DECREMENT:return "XmCR_PAGE_DECREMENT";
	case XmCR_TO_TOP:	return "XmCR_TO_TOP";
	case XmCR_TO_BOTTOM:	return "XmCR_TO_BOTTOM";
	case XmCR_DRAG:		return "XmCR_DRAG";
	case XmCR_ACTIVATE:	return "XmCR_ACTIVATE";
	case XmCR_ARM:		return "XmCR_ARM";
	case XmCR_DISARM:	return "XmCR_DISARM";
#ifdef LesstifVersion
	case XmCR_DUMMY13:	return "XmCR_DUMMY13"; 
	case XmCR_DUMMY14:	return "XmCR_DUMMY14"; 
	case XmCR_DUMMY15:	return "XmCR_DUMMY15";
#endif
	case XmCR_MAP:		return "XmCR_MAP";
	case XmCR_UNMAP:	return "XmCR_UNMAP";
	case XmCR_FOCUS:	return "XmCR_FOCUS";
	case XmCR_LOSING_FOCUS:	return "XmCR_LOSING_FOCUS";
	case XmCR_MODIFYING_TEXT_VALUE:return "XmCR_MODIFYING_TEXT_VALUE";
	case XmCR_MOVING_INSERT_CURSOR:return "XmCR_MOVING_INSERT_CURSOR";
	case XmCR_EXECUTE:	return "XmCR_EXECUTE";
	case XmCR_SINGLE_SELECT:return "XmCR_SINGLE_SELECT";
	case XmCR_MULTIPLE_SELECT:return "XmCR_MULTIPLE_SELECT";
	case XmCR_EXTENDED_SELECT:return "XmCR_EXTENDED_SELECT";
	case XmCR_BROWSE_SELECT:return "XmCR_BROWSE_SELECT";
	case XmCR_DEFAULT_ACTION:return "XmCR_DEFAULT_ACTION";
	case XmCR_CLIPBOARD_DATA_REQUEST:return "XmCR_CLIPBOARD_DATA_REQUEST";
	case XmCR_CLIPBOARD_DATA_DELETE:return "XmCR_CLIPBOARD_DATA_DELETE";
	case XmCR_CASCADING:	return "XmCR_CASCADING";
	case XmCR_OK:		return "XmCR_OK";
	case XmCR_CANCEL:	return "XmCR_CANCEL";
#ifdef LesstifVersion
	case XmCR_DUMMY33:	return "XmCR_DUMMY33"; 
#endif
	case XmCR_APPLY:	return "XmCR_APPLY";
	case XmCR_NO_MATCH:	return "XmCR_NO_MATCH";
	case XmCR_COMMAND_ENTERED:return "XmCR_COMMAND_ENTERED";
	case XmCR_COMMAND_CHANGED:return "XmCR_COMMAND_CHANGED";
	case XmCR_EXPOSE:	return "XmCR_EXPOSE";
	case XmCR_RESIZE:	return "XmCR_RESIZE";
	case XmCR_INPUT:	return "XmCR_INPUT";
	case XmCR_GAIN_PRIMARY:	return "XmCR_GAIN_PRIMARY";
	case XmCR_LOSE_PRIMARY:	return "XmCR_LOSE_PRIMARY";
	case XmCR_CREATE:	return "XmCR_CREATE";
	case XmCR_TEAR_OFF_ACTIVATE:return "XmCR_TEAR_OFF_ACTIVATE";
	case XmCR_TEAR_OFF_DEACTIVATE:return "XmCR_TEAR_OFF_DEACTIVATE";
	case XmCR_OBSCURED_TRAVERSAL:return "XmCR_OBSCURED_TRAVERSAL";
	case XmCR_PROTOCOLS:	return "XmCR_PROTOCOLS";
	default:		return "???";
	}
}

static char *
XdbXmString2String(XmString xms)
{
    char *s = NULL;

#ifdef LesstifVersion
    if (xms == (XmString)XmUNSPECIFIED)
    {
	return "XmUNSPECIFIED";
    }
#endif
    XmStringGetLtoR(xms, XmFONTLIST_DEFAULT_TAG, &s);

    if (s == NULL)
    {
	return "(null)";
    }

    return s;
}

void
cb(Widget w, XtPointer client, XtPointer call)
{
	XmFileSelectionBoxCallbackStruct *cbp =
		(XmFileSelectionBoxCallbackStruct *)call;

	/* Print stuff */
	fprintf(stderr, "Callback Structure :\n");
	fprintf(stderr, "\tReason %s, event %p\n",
		XdbReason2String(cbp->reason),
		cbp->event);
	fprintf(stderr, "\tvalue '%s', length %d\n",
		XdbXmString2String(cbp->value),
		cbp->length);
	fprintf(stderr, "\tmask '%s', length %d\n",
		cbp->mask ? XdbXmString2String(cbp->mask) : "(null)",
		cbp->mask_length);
	fprintf(stderr, "\tdir '%s', length %d\n",
		cbp->dir ? XdbXmString2String(cbp->dir) : "(null)",
		cbp->dir_length);
	fprintf(stderr, "\tpattern '%s', length %d\n",
		cbp->pattern ? XdbXmString2String(cbp->pattern) : "(null)",
		cbp->pattern_length);

	/* Trigger popping down */
	popdown = 1;
}

void
pushme(Widget w, XtPointer client, XtPointer call)
{
	box = XmCreateFileSelectionDialog(toplevel, "Box", NULL, 0);
	XtAddCallback(box, XmNokCallback, cb, NULL);

	popdown = 0;
	XtManageChild(box);
	set_path(box);
	
{
    static XtWidgetGeometry Expected[] = {
   CWWidth | CWHeight            ,    7,   23,  294,  374, 0,0,0, /* Box */
   CWWidth | CWHeight | CWX | CWY,  170,   69,  113,   17, 0,0,0, /* Items */
   CWWidth | CWHeight | CWX | CWY,  170,   86,  113,  154, 0,0,0, /* ItemsListSW */
   CWWidth | CWHeight | CWX | CWY,   98,    0,   15,  135, 0,0,0, /* VertScrollBar */
   CWWidth | CWHeight | CWX | CWY,    0,  139,   94,   15, 0,0,0, /* HorScrollBar */
   CWWidth | CWHeight | CWX | CWY,    0,    0,   94,  135, 0,0,0, /* ItemsList */
   CWWidth | CWHeight | CWX | CWY,   11,  250,  272,   17, 0,0,0, /* Selection */
   CWWidth | CWHeight | CWX | CWY,   11,  267,  272,   31, 0,0,0, /* Text */
   CWWidth | CWHeight | CWX | CWY,    0,  308,  294,    2, 0,0,0, /* Separator */
   CWWidth | CWHeight | CWX | CWY,   11,  320,   66,   43, 0,0,0, /* OK */
   CWWidth | CWHeight | CWX | CWY,   79,  320,   66,   43, 0,0,0, /* Apply */
   CWWidth | CWHeight | CWX | CWY,  147,  320,   66,   43, 0,0,0, /* Cancel */
   CWWidth | CWHeight | CWX | CWY,  215,  320,   66,   43, 0,0,0, /* Help */
   CWWidth | CWHeight | CWX | CWY,   11,   11,  272,   17, 0,0,0, /* FilterLabel */
   CWWidth | CWHeight | CWX | CWY,   11,   69,  149,   17, 0,0,0, /* Dir */
   CWWidth | CWHeight | CWX | CWY,   11,   28,  272,   31, 0,0,0, /* FilterText */
   CWWidth | CWHeight | CWX | CWY,   11,   86,  149,  154, 0,0,0, /* DirListSW */
   CWWidth | CWHeight | CWX | CWY,  134,    0,   15,  135, 0,0,0, /* VertScrollBar */
   CWWidth | CWHeight | CWX | CWY,    0,  139,  130,   15, 0,0,0, /* HorScrollBar */
   CWWidth | CWHeight | CWX | CWY,    0,    0,  130,  135, 0,0,0, /* DirList */ 
    };
    PrintDetails(box,Expected);
};
	/*
	while (popdown == 0) {
	        XtAppProcessEvent(XtWidgetToApplicationContext(w), XtIMAll);
	}

	fprintf(stderr, "Destroying the FSB\n");
	XtDestroyWidget(box);
	*/
}

int
main(int argc, char **argv)
{

  make_tmp_dir_tree();
	toplevel = XtVaAppInitialize(&app, "listTest", NULL, 0,
		&argc, argv, NULL, NULL);

	push = XmCreatePushButton(toplevel, "push", NULL, 0);
	XtVaSetValues(push,
			XtVaTypedArg, XmNlabelString, XtRString, "Push me !", 9,
		NULL);

	XtAddCallback(push, XmNactivateCallback, pushme, NULL);

	XtManageChild(push);

	XtRealizeWidget(toplevel);

  LessTifTestWaitForIt(toplevel);
  LessTifTestPushButton(push);


  LessTifTestMainLoop(toplevel);

	exit(0);
}
