# Tests for Blt widgets.

import os
import Tkinter
import Test
import Pmw

Test.initialise()
testData = ()

# Blt vector type

def _setVectorItem(index, value):
    w = Test.currentWidget()
    w[index] = value

def _getVectorItem(index):
    w = Test.currentWidget()
    return w[index]

def _getVectorSlice(index1, index2):
    w = Test.currentWidget()
    return w[index1:index2]

def _delVectorItem(index):
    w = Test.currentWidget()
    del w[index]

if Test.haveBlt():
    c = Pmw.Blt.Vector
    tests = (
      (c.set, [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]),
      (c.__repr__, (), '[1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0]'),
      (c.set, ((1, 2, 3, 4, 5, 6, 7, 8, 9, 10),)),
      (c.__repr__, (), '[1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0]'),
      (c.__str__, (), 'PY_VEC4'),
      (_getVectorItem, 7, 8),
      (_getVectorSlice, (3, 6), [4.0, 5.0, 6.0, 7.0]),
      (_delVectorItem, 9),
      (c.get, (), [1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0]),
      (c.append, 10),
      (c.get, (), [1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0]),
      (c.length, (), 10),
      (c.append, 5),
      (c.__len__, (), 11),
      (c.count, 5, 2),
      (c.count, 20, 0),
      (c.search, 5, (4, 10)),
      (c.search, 20),
      (c.index, 5, 4),
      # Commented tests do not work because of a bug in the blt vector command.
      # (c.clear, ()),
      (_getVectorItem, 4, 5),
      (c.remove, 5),
      (c.index, 5, 9),
      (c.min, (), 1.0),
      (c.max, (), 10.0),
      # (c.reverse, ()),
      # (c.reverse, ()),
      # (c.get, (), [1.0, 2.0, 3.0, 4.0, 6.0, 7.0, 8.0, 9.0, 10.0, 5.0]),
      # (c.insert, (3, 66)),
      # (c.search, 66, (3,)),
      (c.get, (), [1.0, 2.0, 3.0, 4.0, 6.0, 7.0, 8.0, 9.0, 10.0, 5.0]),
      (c.sort, ()),
      (c.get, (), [1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0]),
      (c.sort_reverse, ()),
      (c.get, (), [10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0]),
      (_setVectorItem, (7, 77)),
      (c.search, 77, (7,)),
      (_setVectorItem, (2, 77)),
      (c.search, 77, (2, 7)),
      (_setVectorItem, (10, 77), 'TclError: can\'t set "PY_VEC4(10)": index "10" is out of range'),
      (c.get, (), [10.0, 9.0, 77.0, 7.0, 6.0, 5.0, 4.0, 77.0, 2.0, 1.0]),
      (c.delete, (1, 3, 5)),
      (c.get, (), [10.0, 77.0, 6.0, 4.0, 77.0, 2.0, 1.0]),
      (c.length, (9), 9),
      #(c.get, (), [10.0, 77.0, 6.0, 4.0, 77.0, 2.0, 1.0, 0.0, 0.0]),
      (c.range, (1, 3), [77.0, 6.0, 4.0]),
    )
    testData = testData + ((c, ((tests, {}),)),)

#=============================================================================

# Blt graph widget

def _axisCommand(graph, value):
  return 'XX ' + value

def _createMarkerButton():
    w = Test.currentWidget()
    button = Tkinter.Button(w, text = 'This is\na button')
    w.marker_create('window', coords=(10, 200), window=button)

if Test.haveBlt():
    if Tkinter.TkVersion >= 8.0:
      graph_num = 28
    else:
      graph_num = 27

    c = Pmw.Blt.Graph
    tests = (
      ('height', 700),
      ('width', 900),
      (c.pack, (), {'fill': 'both', 'expand': 1}),

      (Test.num_options, (), graph_num),
      (c.element_create, 'line1', {'xdata': (1, 2, 3, 4, 5, 6, 7, 8, 9, 10), 'ydata': (7, 2, 1, 4, 7, 3, 9, 3, 8, 5), 'activefill': 'green', 'symbol': 'circle'}),
      (c.element_bar, 'bar1', {'xdata': Test.vector_x, 'ydata': Test.vector_y[0], 'foreground': 'blue'}),
      (c.element_bar, 'bar2', {'xdata': Test.vector_x, 'ydata': Test.vector_y[1], 'foreground': 'magenta'}),
      (c.element_line, 'line2', {'xdata': Test.vector_x, 'ydata': Test.vector_y[2], 'color': 'red'}),

      (c.marker_create, 'text', {'coords': (25, 200), 'rotate': 45, 'text':
	'This is\na marker', 'name': 'myMarker1'}, 'myMarker1'),
      (c.marker_create, 'line', {'coords': (35, 120, 15, 280), 'linewidth': 4}, 'MARKER1'),
      (c.marker_create, 'polygon', {'coords': (35, 40, 45, 40, 45, 120, 35, 120), 'linewidth': 4}, 'MARKER2'),
      (c.marker_create, 'bitmap', {'coords': (25, 200), 'rotate': 45, 'bitmap': 'questhead'}, 'MARKER3'),
      (_createMarkerButton, ()),

      (c.marker_after, 'myMarker1'),
      (c.marker_before, ('myMarker1', 'MARKER3')),
      (c.marker_create, 'text', {'coords': (10, 10), 'text':
	'Bye', 'name': 'myMarker2'}, 'myMarker2'),
      (c.marker_names, 'my*', ('myMarker1', 'myMarker2')),
      (c.marker_exists, 'myMarker2', 1),
      (c.marker_delete, ('my*', 'MARKER3')),
      (c.marker_exists, 'myMarker2', 0),
      (c.marker_names, (), ('MARKER1', 'MARKER2', 'MARKER4')),
      (c.marker_type, 'MARKER1', 'line'),

      ('background', '#ffdddd'),
      ('barmode', 'stacked'),
      ('barwidth', 0.5),
      ('borderwidth', 100),
      ('borderwidth', 10),
      ('barwidth', 0.9),
      ('bottommargin', 100),
      ('bufferelements', 1),
      ('cursor', 'watch'),
      ('font', Test.font['variable']),
      ('foreground', 'blue'),
      ('halo', 20),
      ('barmode', 'aligned'),
      ('invertxy', 1),
      ('justify', 'left'),
      ('leftmargin', 100),
      ('plotbackground', 'aquamarine'),
      ('plotborderwidth', 4),
      ('plotrelief', 'groove'),
      ('relief', 'ridge'),
      ('rightmargin', 100),
      ('takefocus', '0'),
      ('tile', Test.earthris),
      ('barmode', 'normal'),
      ('title', 'Hello there\nmy little lovely'),
      ('topmargin', 100),
      ('invertxy', 0),

      # Change colours so that axis and legend are visible against image tile.
      (c.xaxis_configure, (), {'color': 'green'}),
      (c.yaxis_configure, (), {'color': 'green'}),
      (c.legend_configure, (), {'background': '#ffffcc'}),

      (c.extents, 'leftmargin', 114),

      # These tests are not portable
      # (c.invtransform, (0, 0), (-10.2518, 507.203)),
      # (c.transform, (-10.2518, 507.203), (0.0, 0.0)),

      # Reset margins to automatic
      ('bottommargin', 0),
      ('leftmargin', 0),
      ('rightmargin', 0),
      ('topmargin', 0),

      (c.crosshairs_configure, (), {'mapped': 1}),
      (c.crosshairs_configure, (), {'position': '@300,300'}),
      (c.crosshairs_configure, (), {'color': 'seagreen4'}),
      (c.crosshairs_toggle, ()),
      (c.crosshairs_cget, 'mapped', 0),
      (c.crosshairs_configure, (), {'dashes': (4, 8, 8, 8)}),
      (c.crosshairs_configure, (), {'linewidth': 4}),
      (c.crosshairs_toggle, ()),
      (c.crosshairs_cget, 'mapped', 1),
      (c.crosshairs_off, ()),
      (c.crosshairs_cget, 'mapped', 0),
      (c.crosshairs_on, ()),
      (c.crosshairs_cget, 'mapped', 1),

      # Bug in blt graph widget: no -activebackground option.
      #(c.element_configure, 'bar2', {'activebackground': '#dddd99', 'activeforeground': '#ffffaa'}),
      (c.element_configure, 'bar2', {'activeforeground': '#ffffaa'}),
      (c.element_activate, 'bar1'),
      (c.element_activate, 'bar2'),
      (c.element_deactivate, ('bar1', 'bar2')),
      (c.element_deactivate, ()),
      (c.element_activate, ('bar2',) + tuple(range(Test.vectorSize / 2))),
      (c.element_configure, 'bar1', {'ydata': Test.vector_y[1]}),
      (c.element_configure, 'bar2', {'ydata': Test.vector_y[0]}),

      # These tests are not portable
      # (c.element_closest, (330, 430), {}, {'x': 18.0, 'dist': 17.0, 'name': 'bar1', 'index': 18, 'y': 156.0}),
      # (c.element_closest, (0, 0)),
      # (c.element_closest, (0, 0), {'halo': 500}, {'x': 0.0, 'dist': 154.797, 'name': 'line2', 'index': 0, 'y': 359.0}),
      # (c.element_closest, (0, 0), {'halo': 500, 'interpolate': 1}, {'x': -0.0320109, 'dist': 154.797, 'name': 'line2', 'index': 0, 'y': 358.879}),

      (c.element_type, 'bar2', 'bar'),
      (c.element_type, 'line2', 'line'),

      (c.legend_activate, ('line1', 'bar2',)),
      (c.legend_activate, ()),
      (c.legend_deactivate, ('line1', 'bar2',)),
      (c.legend_deactivate, ()),
      (c.legend_configure, (), {'mapped': 0}),
      (c.legend_cget, 'mapped', 0),
      (c.legend_configure, (), {'mapped': 1}),
      (c.legend_configure, (), {'position': 'left', 'anchor': 'nw', 'ipadx': 100, 'ipady': 100}),
      (c.legend_get, '@150,150', 'line1'),

      (c.postscript_output, '/tmp/tmp.ps', {'landscape': 1}),
      (os.unlink, '/tmp/tmp.ps'),

      (c.element_show, (), ('line1', 'bar1', 'bar2', 'line2')),
      (c.element_show, (('line1', 'bar1'),), ('line1', 'bar1')),
      (c.element_names, (), ('line1', 'line2', 'bar1', 'bar2')),
      (c.element_show, (('line1', 'line2', 'bar1', 'bar2'),), ('line1', 'line2', 'bar1', 'bar2')),
      (c.element_exists, 'bar1', 1),
      (c.element_delete, ('bar1', 'bar2')),
      (c.element_names, (), ('line1', 'line2')),
      (c.element_exists, 'bar1', 0),
      (c.element_delete, ()),
      (c.element_names, (), ('line1', 'line2')),

      (c.grid_configure, (), {'mapped': 1}),
      (c.grid_toggle, ()),
      (c.grid_cget, 'mapped', 0),
      (c.grid_on, ()),
      (c.grid_cget, 'mapped', 1),
      (c.grid_off, ()),

      # These tests are not portable
      # (c.xaxis_invtransform, 0, -37.1153),
      # (c.axis_limits, 'x', (-0.98, 49.98)),
      # (c.axis_transform, ('x', 0), 360),
      # (c.axis_invtransform, ('y', 0), 444.198),
      # (c.yaxis_limits, (), (-6.96, 406.96)),
      # (c.axis_transform, ('y', 0), 620),
      # (c.axis_invtransform, ('x2', 0), -25.1491),
      # (c.axis_limits, 'x2', (-10.4, 10.4)),
      # (c.x2axis_transform, 0, 598),
      # (c.y2axis_invtransform, 0, 12.2713),
      # (c.axis_limits, 'y2', (-10.4, 10.4)),
      # (c.axis_transform, ('y2', 0), 341),
    )
    
    testData = testData + ((c, ((tests, {}),)),)

if __name__ == '__main__':
    Test.runTests(testData)
