# Copyright (c) 1996, 1997, The Regents of the University of California.
# All rights reserved.  See Legal.htm for full text and disclaimer.

import sys
from history import *
import history_test_aux

z = open("history_test_out.txt", "w")
sys.stdout = z

def heartbeat():
    sys.stderr.write ("Bump-bump ")
    sys.stderr.write (`cycle`)
    sys.stderr.write ('\n')

def do_step (i):
    global cycle, time, xx, yy
    xx = i / 2.0
    yy = xx * xx

    cycle = i
    time = i / 100.0

tag1 = textfile_tag ("tag1", "history_test_tag1.txt")
tag1.item ("xx")
tag1.frequency (.03, .50, .05)
tag1.when("xx > 1.4")
tag1.item ("yy")
tag1.item ("zz", "time / 2.")
tag1.item ("ww", "history_test_aux.testfunction (xx)")
tag1.item ("qq", "z", history_test_aux)
hbtag = event_tag ("Heartbeat", "heartbeat ()")
hbtag.frequency (0,10000,2)

xx = 3.0
collector.check ()

for t in collector.tagnames():
        print collector.tag (t)

for i in range(60):
    do_step (i)
    collector.sample (cycle, time)
collector.sample_final (cycle, time)

print "See file history_test_tag1 for data collected by this test."



