/*
	Copyright (c) 1997,1998 Eugene G. Crosser
	Copyright (c) 1998 Bruce D. Lightner (DOS/Windows support)

	You may do virtually what you wish with this software, as long
	as the explicit reference to its original author is retained.

	THIS SOFTWARE IS PROVIDED AS IS AND COME WITH NO WARRANTY OF ANY
	KIND, EITHER EXPRESSED OR IMPLIED.  IN NO EVENT WILL THE
	COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES RESULTING FROM THE
	USE OF THIS SOFTWARE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include "jscan.h"

#ifdef MSWINDOWS
#define READMODE "rb"
#else
#define READMODE "r"
#endif

int main(int argc,char *argv[]) {
	FILE *fp;
	struct stat st;
	unsigned char *buf,*res,*key=NULL,*p,*q;
	size_t bufsize,ressize;
	int i;

	if (argc == 3) {
		key=argv[2];
	} else if (argc != 2) {
		fprintf(stderr,"usage: %s <filename> [<keyword>]\n",argv[0]);
		return -1;
	}

	if ((fp=fopen(argv[1],READMODE)) == NULL) {
		perror(argv[1]);
		return -1;
	}

	if (fstat(fileno(fp),&st)) {
		perror(argv[1]);
		return -1;
	}

	bufsize=st.st_size;
	buf=malloc(bufsize);
	if (buf == NULL) {
		perror("malloc");
		return -1;
	}

	if (fread(buf,bufsize,1,fp) != 1) {
		perror("read");
		free(buf);
		fclose(fp);
		return -1;
	}
	fclose(fp);

	res=buf;
	ressize=bufsize;
	if (jscan(&res,&ressize)) {
		fprintf(stderr,"No camera-specific information in the file\n");
		free(buf);
		return -1;
	}

	if (key) {
		p=jsearch(key,res,ressize);
		if (p == NULL) {
			fprintf(stderr,"Key not found\n");
			free(buf);
			return -1;
		}
		if ((q=strchr(p,'\n'))) *q='\0';
		printf("%s\n",p);
	} else {
		for (i=0;i<ressize;i++)
			printf("%c",res[i]);
		printf("\n");
	}

	free(buf);
	return 0;
}
